const system = require("../system");
const settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
class CtlBase {
  constructor(gname, sname) {
    this.serviceName = sname;
    this.service = system.getObject("service." + gname + "." + sname);
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.logClient = system.getObject("util.logClient");
  }
  getUUID () {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }
  static getServiceName (ClassObj) {

    return ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Ctl")).toLowerCase() + "Sve";
  }
  async update (pobj, qobj, req) {
    const up = await this.service.update(pobj);
    return system.getResult(up);
  }
  async create (pobj, qobj, req) {
    const up = await this.service.create(pobj);
    return system.getResult(up);
  }
  async delete (pobj, qobj, req) {
    const up = await this.service.delete(pobj);
    return system.getResult(up);
  }
  async findAndCountAll (pobj, qobj, req) {
    //设置查询条件
    console.log(pobj)
    const rs = await this.service.findAndCountAll(pobj);
    return system.getResult(rs);
  }
  async refQuery (pobj, qobj, req) {
    //pobj.refwhere.app_id=pobj.app_id;//角色过滤按照公司过滤
    pobj.refwhere.company_id = pobj.company_id;
    let rtn = await this.service.refQuery(pobj);
    return rtn
  }
  async setContextParams (pobj, qobj, req) {
    let custtags = req.headers["x-consumetag"] ? req.headers["x-consumetag"].split("|") : null;
    let lastindex = custtags ? custtags.length - 1 : 0;
    //当自由用户注册时，需要根据前端传来的companykey,查询出公司，给companyid赋值
    req.xctx = {
      appkey: req.headers["xappkey"],//用于系统管理区分应用,比如角色
      fromappkey: req.headers["xfromappkey"],//来源APP，如果没有来源与appkey相同
      companyid: custtags ? custtags[0].split("_")[1] : null,
      fromcompanykey: req.headers["xfromcompanykey"],//专用于自由用户注册,自由用户用于一定属于某个存在的公司
      password: custtags ? custtags[lastindex].split("_")[1] : null,
      username: req.headers["x-consumer-username"],
      userid: req.headers["x-consumer-custom-id"],
      credid: req.headers["x-credential-identifier"],
      regrole: req.headers["xregrole"],
      bizpath: req.headers["xbizpath"],
      codename: req.headers["xcodename"],
      codetitle: req.headers["xcodetitle"] ? decodeURI(req.headers["xcodetitle"]) : '',
      opath: req.headers['xopath'],
      ptags: req.headers['xptags'],
    }
    //添加组织结构路径,如果是上级，取上级
    if (req.xctx.ptags && req.xctx.ptags != "") {
      pobj.opath = req.xctx.ptags
    } else {
      if (!pobj.opath || pobj.opath == "") {
        pobj.opath = req.xctx.opath
      }
    }
    if (!req.xctx.appkey) {
      return [-200, "请求头缺少应用x-app-key"]
    } else {
      let app = await this.cacheManager["AppCache"].cache(req.xctx.fromappkey);
      req.xctx.appid = app.id;
      if (!pobj.app_id) {
        pobj.app_id = app.id;//传递参数对象里注入app_id
      }
    }
    //平台注册时，companyid，companykey都为空
    //自由注册时，companykey不能为空
    // if(!req.xctx.companyid && !req.xctx.companykey){
    //   return [-200,"请求头缺少应用x-app-key"]
    // }
    if (!req.xctx.companyid && req.xctx.fromcompanykey && req.xctx.fromcompanykey != "null" && req.xctx.fromcompanykey != "undefined") {
      let comptmp = await this.cacheManager["CompanyCache"].cache(req.xctx.fromcompanykey);
      req.xctx.companyid = comptmp.id;
    }
    if (req.xctx.companyid) {//在请求传递数据对象注入公司id
      pobj.company_id = req.xctx.companyid;
    }
    if (req.xctx.userid) {//在请求传递数据对象注入公司id
      pobj.userid = req.xctx.userid;
      pobj.username = req.xctx.username;
    }
    pobj.bizpath = req.xctx.bizpath;
  }

  async doexec (methodname, pobj, query, req) {
    try {
      let xarg = await this.setContextParams(pobj, query, req);
      if (xarg && xarg[0] < 0) {
        return system.getResultFail(...xarg);
      }
      var rtn = await this[methodname](pobj, query, req);
      this.logClient.log(pobj, req, rtn, null)
      return rtn;
    } catch (e) {
      this.logClient.log(pobj, req, null, e.stack)
      console.log(e.stack, "出现异常，请联系管理员.......");
      return system.getResultFail(-200, e.message ? e.message : "出现异常，请联系管理员");
    }
  }
}
module.exports = CtlBase;
/*
地址：http://192.168.1.128:401/api/queueAction/producer/springBoard
请求方式：post
    参数：
    {
        "actionType": "produceLogsData",// Y 功能名称
        "actionBody": {
            "opTitle": "",// N 操作的业务标题
            "identifyCode": "logs001",// Y 操作的业务标识
            "messageBody": {//日志的描述信息
                "opUrl": "http://192.168.1.189:4012/api/test/testApi/springBoard",// N 操作的业务Url
                "message": ""// Y 日志消息描述
            }
        }
    }
logs-sytxpublic-msgq-service--日志服务
    */