var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends APIBase {
   constructor() {
      super();
      this.productpriceS = system.getObject("service.product.productpriceSve")
   }
   /**
    * 
    * @param {*} p productname-产品名称/sp名称
    * @param {*} q 
    * @param {*} req 
    * 返回值[
    *    label:'',
    *    code:''
    * ]
    */
   async findRegionsByProductName (p, q, req) {
      let pname = p.productname;
      let sp = p.sp;
      let rs = await this.productpriceS.findRegionsByProductName(pname, sp)
      return system.getResult(rs);
   }

   async findCostBySkuCode (p, q, req) {
      let skucode = p.skucode;
      let rs = await this.productpriceS.findCostBySkuCode(skucode)
      return system.getResult({ cost: rs });
   }

   classDesc () {
      return {
         groupName: "auth",
         groupDesc: "认证相关的包",
         name: "AccessAuthAPI",
         desc: "关于认证的类",
         exam: `
             post  http://p.apps.com/api/auth/accessAuth/getAccessKey
             {
                appKey:xxxxx,
                secret:yyyyyy
             }
         `,
      };
   }
   methodDescs () {
      return [

      ];
   }
   exam () {
      return ``
   }
}
module.exports = ProductAPI;
