﻿var url = require("url");
var system = require("../../base/system");
var metaCtl = system.getObject("web.common.metaCtl");
var userCtl = system.getObject("web.auth.userCtl");
const redisClient = system.getObject("util.redisClient");

module.exports = function (app) {
	app.all("/web/*", async function (req, res, next) {
		var loginsid;
		var jsonUser = req.session.user;
		// var jsonUser = null;
		if(!jsonUser) {
			loginsid = req.headers["xggsaasplatformsid"] || "";
			jsonUser = await redisClient.get(loginsid);
			if(jsonUser) {
				jsonUser = JSON.parse(jsonUser);
			}
		}

		if (req.url.indexOf("uc/userCtl/login") > 0 ||
			req.url.indexOf("common/metaCtl/getApiDoc") > 0 ||
			req.url.indexOf("common/captchaCtl/captcha") > 0 ||

			req.url.indexOf("getRsConfig") > 0) {
			if (jsonUser) {
				req.loginUser = jsonUser;
			} else {
				req.loginUser = null;
			}
			return next();
		}

		if (!jsonUser) {
			res.end(JSON.stringify({ status: -99, msg: "no login" }));
			return;
		}

		if(loginsid) {
			redisClient.setWithEx(loginsid, JSON.stringify(jsonUser), 60 * 60 * 5);
		}
		req.loginUser = jsonUser;
		next();
	});

	app.get("/", async function (req, res) {
		res.render("index", { appinfo: null, app: null });

		// console.log(req.hostname);
		// var appinfo=await metaCtl.getAppInfo(req);
		// if(!appinfo){
		// 	res.render("index",{appinfo:null,app:null});
		// }else{
		// 	res.render("index",appinfo);
		// }
	});
	app.get('/web/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		classPath = gname + "." + classPath;
		var params = [];

		if(req.loginUser) {
			req.query = req.query || {};
			req.query.saas_id = req.loginUser.saas_id;
			req.query.channel_id = req.loginUser.channel_id;
		}
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		params.push(res);
		var p = null;
		var invokeObj = system.getObject("web." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			console.log(req.url, "req.url...................");
			console.log(r, "req###############################");
			res.end(JSON.stringify(r));
		});
	});

	app.post('/web/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		var params = [];
		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);
		req.body.clientIp = tClientIp;
		req.body.agent = req.headers["user-agent"];
		req.body.classname = classPath;

		if(req.loginUser) {
			req.body.saas_id = req.loginUser.saas_id;
			req.body.channel_id = req.loginUser.channel_id;
		}

		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		params.push(res);
		var p = null;
		var invokeObj = system.getObject("web." + classPath);
		if (invokeObj["doexec"]) {
			p = invokeObj["doexec"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
};
