const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class UserService extends ServiceBase {
  constructor() {
    super();
    this.platformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.opuserrelationDao = system.getObject("db.common.opuserrelationDao");
  }

  async login(params) {
    try {
      return await this.callms("uc", "platformLogin", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async registerInner(params) {
    try {
      return await this.callms("uc", "platformRegisterInner", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async resetPasswordInner(params) {
    try {
      return await this.callms("uc", "platformResetPasswordInner", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async info(params) {
    try {
      return await this.callms("uc", "platformInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async enabled(params) {
    try {
      return await this.callms("uc", "platformEnabled", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async mapByIds(params) {
    try {
      return await this.callms("uc", "platforMapByIds", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}

module.exports = UserService;