const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class MerchantuserService extends ServiceBase {
  constructor() {
    super();
  }

  async save(params) {
    try {
      return await this.callms("uc", "merchantSave", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params) {
    try {
      return await this.callms("uc", "merchantInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async enabled(params) {
    try {
      return await this.callms("uc", "merchantEnabled", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params) {
    try {
      return await this.callms("uc", "merchantPage", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async mapByIds(params) {
    try {
      return await this.callms("uc", "merchantMapByIds", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
 
}

module.exports = MerchantuserService;