const system = require("../../../system");
const ServiceBase = require("../../svems.base");
const settings = require("../../../../config/settings");

class TradeService extends ServiceBase {
  constructor() {
    super();
    this.merchantSve = system.getObject("service.saas.merchantSve");
    this.redisClient = system.getObject("util.redisClient");
  }

  async orderPage(params) {
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);

    let res = await this.setMerchantIdsByName(params);
    if (res.status !== 0) {
      return system.getResultSuccess({count: 0, rows: []});
    }
    let rs = await this.callms("trade", "orderPage", params) || {};
    if (rs.data && rs.data.rows) {
      this.transFields(rs.data.rows);
    }
    return rs;
  }

  async orderInfo(params) {
    let rs = await this.callms("trade", "orderInfo", params) || {};
    let order = rs.data;
    if (order) {
      this.transFields([order]);
      let merchant = await this.merchantSve.info({id: order.saas_merchant_id}) || {};
      merchant = merchant.data || {};
      order.merchant_name = merchant.name;
    }
    return rs;
  }

  async updateInvoice(params) {
    let rs = await this.callms("trade", "updateItemInvoice", params);
    return rs;
  }

  async setMerchantIdsByName(params) {
    let merchantName = this.trim(params.merchant_name);
    if (merchantName) {
      let merchantIds = await this.merchantSve.idsLikeName({
        name: merchantName,
        saas_id: this.trim(params.saas_id),
        saas_merchant_id: this.trim(params.saas_merchant_id),
      }) || {};
      if (!merchantIds || !merchantIds.data || merchantIds.data.length == 0) {
        return system.getResult(null);
      }
      params.saas_merchant_ids = merchantIds.data;
    }
    return system.getResultSuccess();
  }

  async itemPage(params) {
    params = params || {};
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);
    let res = await this.setMerchantIdsByName(params);
    if (res.status !== 0) {
      return system.getResultSuccess({count: 0, rows: []});
    }
    let rs = await this.callms("trade", "itemPage", params) || {};
    if (rs.data && rs.data.rows) {
      this.transFields(rs.data.rows);
    }
    return rs;
  }

  async itemByInvoiceId(params) {
    let rs = await this.callms("trade", "itemByInvoiceId", params) || {};
    if (rs.data && rs.data.rows) {
      this.transFields(rs.data.rows);
    }
    return rs;
  }

  async audit1(params) {
    let rs = await this.callms("trade", "orderAudit1", params) || {};
    return rs;
  }

  async audit2(params) {
    let rs = await this.callms("trade", "orderAudit2", params) || {};
    return rs;
  }

  async trade(params) {
    let rs = await this.callms("trade", "orderTrade", params) || {};
    return rs;
  }

  async invoiceTrade(params) {
    let rs = await this.callms("trade", "invoiceTrade", params) || {};
    return rs;
  }

  async tradeFeedBack(params) {
    let rs = await this.callms("trade", "itemTradeOfflineCB", params) || {};
    return rs;
  }

  async cancelInvoice(params) {
    let rs = await this.callms("trade", "cancelItemInvoice", params);
    return rs;
  }

  async cancelInvoiceByDataIds(params) {
    let rs = await this.callms("trade", "cancelInvoiceByDataIds", params);
    return rs;
  }

  transFields(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    for (let row of rows) {
      row.amt = system.f2y(row.amt);
      row.actual_amt = system.f2y(row.actual_amt);
      row.deduct_amt = system.f2y(row.deduct_amt);
      row.service_tax = system.f2y(row.service_tax);
      row.service_rate = system.f2y(row.service_rate);
    }
  }
}

module.exports = TradeService;