const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
const axios = require("axios");

class OrderService extends ServiceBase {
  constructor() {
    super();
  }

  async microAdd(params) {
    var rs = await this.callms("order", "saasOrderMicroAdd", params);
    return rs;
  }

  async info(params) {
    var rs = await this.callms("order", "saasOrderInfo", params);
    return rs;
  }

  async platformInfo(params) {
    var rs = await this.callms("order", "saasOrderPlatformOrderInfo", params);
    return rs;
  }

  async page(params) {
    var rs = await this.callms("order", "saasOrderPage", params);
    if (rs && rs.data && rs.data.rows) {
      this.transOrderField(rs.data.rows);
    }
    return rs;
  }

  /**
   * fn:审核后推送交付系统
   * @param params
   * @returns {Promise<{msg: string, data, bizmsg: *|string, status: number}|*|undefined>}
   */
  async audit(params) {
    console.log(`审核参数` + JSON.stringify(params));
    var rs = await this.callms("order", "saasOrderBulkAudit", params);
    console.log( `审核结果 ${rs} `);
    console.log(JSON.stringify(rs));
    if(params.audit_status == "20" && rs.status === 0 && params.ids && params.ids.length > 0) {
      for(let id of params.ids) {
        this.pushOrderToDeliver(id,params.deliver_id);
      }
    }
    return rs;
  }

  /**
   * fn:推送订单到交付系统
   * @param id
   * @returns {Promise<void>}
   */
  async pushOrderToDeliver(id,deliver_id) {

    console.log("推送参数  "+id +"===>"+deliver_id)
    let order = await this.callms("order", "saasOrderInfo", {id: id}) || {};
    console.log("查询到的订单" + JSON.stringify(order));
    order = order.data;
    if (!order) {
      return;
    }
    let notifyApi = settings.outApi().deliverNotifyApi;
    let data = {
      product_id: order.product_id,
      source_id: 1002,
      source_no: order.id,
      customer_name: order.bminfo.legal_name,
      contact_mobile: order.bminfo.legal_mobile,
      desc: "saas个体户注册",
      saas_deliver_api: notifyApi,
      bminfo: order.bminfo,
      guest_mail_addr:order.saasOrderDeliverInfo.deliver_addr|| "",
      guest_mail_to:order.saasOrderDeliverInfo.deliver_man || "",
      guest_mail_mobile:order.saasOrderDeliverInfo.deliver_mobile || "",
      saas_id:order.saas_id,
      deliver_id:deliver_id,
      price:order.price || 0
    };
    console.log("推送订单到交付平台参数"+JSON.stringify(data))
    // 推送订单到交付平台
    let url = settings.deliverSysApi().orderPushApi;
    console.log("推送订单到交付平台URL"+url)
    let res = await axios({
      method: 'post',
      url: url,
      data: data
    });
    console.log(res.data);
    if(res.status == 200 && res.data && res.data.status == 0 && res.data.data) {
      await this.updateOrder({id: id, deliver_order_id: res.data.data.id});
    }
  }

  async updateOrder(params) {
    let rs = await this.callms("order", "saasOrderUpdate", params);
    return rs;
  }

  // 服务交付
  async sveDeliver(params) {
    let rs = await this.callms("order", "saasOrderSveDeliver", params);
    return rs;
  }

  // 服务交付
  async sveBusinessmen(params) {
    let rs = await this.callms("order", "saasOrderBusinessmen", params);
    return rs;
  }
  // 交付信息 map by 信用代码
  async mapByCreditCodes(params) {
    let rs = await this.callms("order", "saasBusinessmenMapByCreditCodes", params);
    return rs;
  }

  async deliver(params) {
    var rs = await this.callms("order", "saasOrderBulkDeliver", params);
    return rs;
  }

  transOrderField(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    for (let row of rows) {
      row.price = system.f2y(row.price);
    }
  }

  async cancelInvoiceByDataIds(params) {
    let rs = await this.callms("order", "cancelInvoiceByDataIds", params);
    return rs;
  }


}
module.exports = OrderService;