const system = require("../../../system");
const ServiceBase = require("../../svems.base");
var settings = require("../../../../config/settings");
const axios = require("axios");

class DeliverService extends ServiceBase {
  constructor() {
    super();
    this.synlogDao = system.getObject("db.log.synlogDao");
  }

  async all(params) {
    var rs = await this.callms("common", "deliverAll", params);
    await this.doPercent(rs.data);
    return rs;
  }

  async page(params) {
    var rs = await this.callms("common", "deliverPage", params);
    await this.doPercent(rs.data.rows);
    return rs;
  }

  async info(params) {
    var rs = await this.callms("common", "deliverInfo", params);
    await this.doPercent([rs.data]);
    return rs;
  }

  async enabled(params) {
    var rs = await this.callms("common", "deliverEnable", params);
    this.synEnabled(params);
    return rs;
  }

  async synEnabled(params) {
    var rs = await this.callms("common", "deliverInfo", params);
    let deliver = rs.data;
    if(!deliver) {
      return;
    }

    let data = {
      companyNo: deliver.id,
      name: deliver.name,
      serviceStatus: deliver.isEnabled ? 1 : 0,
    }

    let url = settings.ntapi().updateCompanyStatus;
    this.callApi(url, data, "启用/禁用");
  }

  async resetPassword(params) {
    var rs = await this.callms("common", "deliverResetPassword", params);
    return rs;
  }

  async save(params) {
    params.invoiceDivide = 0;
    params.businessmenDivide = 0;
    var rs = await this.callms("common", "deliverSave", params);
    await this.doPercent([rs.data]);
    if(rs && rs.data && rs.data.id) {
      this.synSave(rs.data.admin_id, params.password);
    }
    return rs;
  }

  async synSave(id, password) {
    let rs = await this.callms("common", "deliverUserInfo", {id: id});
    if(!rs || !rs.data || !rs.data.user || !rs.data.deliver) {
      return;
    }

    let user = rs.data.user;
    // 是否已经推送过
    if (user.nt_user_id) {
      return;
    }

    let deliver = rs.data.deliver;
    let data = {
      companyNo: deliver.id,
      companyName: deliver.name,
      path: user.org_path,
      staffNo: user.id,
      staffName: user.real_name,
      loginId: user.ucname,
      pwd: password,
    };
    if(user.id = deliver.admin_id) {
      data.classType = "manager";
      data.className = "管理员";
    } else {
      if(user.isAdmin) {
        data.classType = "leader";
        data.className = "主管";
      } else {
        data.classType = "member";
        data.className = " 普通员工";
      }
    }
    let url = settings.ntapi().synUserDetails;
    let res = await this.callApi(url, data, "创建交付商");
    if(res && res.data && res.data.datas) {
      let _d = res.data.datas;
      await this.callms("common", "deliverSynUpdate", {user_id: id, nt_user_id: _d.id, nt_company_id: _d.companyId});
    }
  }

  async del(params) {
    return await this.callms("common", "deliverDelete", params);
  }

  async doPercent(rows) {
    if(!rows) {
      return;
    }
    for(var row of rows) {
      if(!row) {
        continue;
      }
      row.invoiceDivide = system.f2y(row.invoiceDivide);
      row.businessmenDivide = system.f2y(row.businessmenDivide);
    }
  }
}
module.exports = DeliverService;