var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class ChannelCtl extends CtlBase {
  constructor() {
    super();
    this.channelSve = system.getObject("service.saas.channelSve");
    this.saasbusinessSve = system.getObject("service.saas.saasbusinessSve");
    this.businessscopeSve = system.getObject("service.common.businessscopeSve");
  }

  async dics(params, pobj2, req) {
    try {
      return await this.channelSve.dics(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params, pobj2, req) {
    try {
      return await this.channelSve.info(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params, pobj2, req) {
    try {
      return await this.channelSve.page(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


  async save(params, pobj2, req) {
    try {
      let check = this.checkSaveParams(params);
      if (check.status !== 0) {
        return check;
      }
      // 此操作涉及到三个微服务，没有事务！没有事务！没有事务！！！
      // 1. 创建saas记录
      let saasrs = await this.saasbusinessSve.openSaasBusiness({
        "companyName": params.name,
        "domain": "ss-platform",
        "mobile": "18811051022",
        "passwd": "051022",
        "realName": "张娇"
      });
      // 2. 经营范围创建
      // 3. 渠道增加

      // return await this.channelSve.save(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  checkSaveParams(params) {
    let term = Number(params.term || 1);
    let term_end = this.trim(params.term_end);

    let validity = Number(params.validity || 1);
    let validity_end = this.trim(params.validity_end);

    if (!this.trim(params.name)) {
      return system.getResult(null, "请填写渠道名称");
    }
    if (!this.trim(params.short_name)) {
      return system.getResult(null, "请填写渠道简称");
    }
    if (!this.trim(params.credit_code)) {
      return system.getResult(null, "请填写统一社会信用代码");
    }
    // if(!this.trim(params.business_lincense_img)) {return system.getResult(null, ""); }   // 营业执照暂不验证
    if (!this.trim(params.tax_type)) {
      return system.getResult(null, "请选择纳税人类型");
    }
    if (!this.trim(params.residence)) {
      return system.getResult(null, "请填写住所");
    }
    if (!this.trim(params.business_scope)) {
      return system.getResult(null, "请填写经营范围");
    }
    if (term == 2 && !term_end) {
      return system.getResult(null, "请填写营业期限固定日期");
    }

    if (validity == 2 && !validity_end) {
      return system.getResult(null, "请填写有效期限固定日期");
    }

    if (!this.trim(params.account_name)) {
      return system.getResult(null, "请填写账户名称");
    }
    if (!this.trim(params.account_bank_name)) {
      return system.getResult(null, "请填写开户行");
    }
    if (!this.trim(params.account_bank_no)) {
      return system.getResult(null, "请填写开户账号");
    }
    if (!this.trim(params.account_mobile)) {
      return system.getResult(null, "请填写联系电话");
    }

    if (!this.trim(params.contact_man)) {
      return system.getResult(null, "请填写联系人姓名");
    }
    if (!this.trim(params.contact_mobile)) {
      return system.getResult(null, "请填写联系人电话");
    }
    if (!this.trim(params.contact_email)) {
      return system.getResult(null, "请填写联系人邮箱");
    }
    if (!this.trim(params.contact_addr)) {
      return system.getResult(null, "请填写联系人地址");
    }
    return system.getResultSuccess();
  }


}
module.exports = ChannelCtl;