var APIBase = require("../../api.base");
var system = require("../../../system");

class TestAPI extends APIBase {
  constructor() {
    super();
    this.orderSve = system.getObject("service.saas.orderSve");
    this.saasinvoiceSve = system.getObject("service.saas.saasinvoiceSve");
  }

  async statusNotify(pobj, query, req) {
    if (pobj.status == "1190") {
      if (!pobj.source_no) {
        return system.getResult(null, "订单号不存在");
      }
      let data = {
        id: pobj.source_no,
        sve_deliver_express_no: pobj.guest_mail_no,
        sve_deliver_express_img: pobj.guest_mail_img
      };
      // 客户交付交付订单状态是1190时的推送信息
      return await this.orderSve.sveDeliver(data);
    } else if (pobj.status == "1000000" || pobj.status ==  "2000000") {  //建账信息
      if (!pobj.source_no) {
        return system.getResult(null, "订单号不存在");
      }
      let res = await this.orderSve.sveBusinessmen(pobj);
      return res;
    }else if(pobj.state=="3000000"){
      //发票完成推送
      let res = await this.saasinvoiceSve.saveSaasInvoice(pobj);
      return res;
    }
    return pobj;
  }

  exam() {
    return "";
  }

  classDesc() {
    return {
      groupName: "",
      groupDesc: "",
      name: "",
      desc: "",
      exam: "",
    };
  }

  methodDescs() {
    return [
      {
        methodDesc: "",
        methodName: "",
        paramdescs: [
          {
            paramDesc: "",
            paramName: "",
            paramType: "",
            defaultValue: "",
          }
        ],
        rtnTypeDesc: "",
        rtnType: ""
      }
    ];
  }
}

module.exports = TestAPI;