const system=require("../system");
const uuidv4 = require('uuid/v4');
class DocBase{
    constructor(){
        this.apiDoc={
            group:"逻辑分组",
            groupDesc:"",
            name:"",
            desc:"请对当前类进行描述",
            exam:"概要示例",
            methods:[]
        };
        this.initClassDoc();
    }
    initClassDoc(){
        this.descClass();
        this.descMethods();
    }
     descClass(){
        var classDesc= this.classDesc();
        this.apiDoc.group=classDesc.groupName;
        this.apiDoc.groupDesc=classDesc.groupDesc;
        this.apiDoc.name=classDesc.name;
        this.apiDoc.desc=classDesc.desc;
        this.apiDoc.exam=this.examHtml();
    }
    examHtml(){
      var exam= this.exam();
      exam=exam.replace(/\\/g,"<br/>");
      return exam;
    }
    exam(){
      throw new Error("请在子类中定义类操作示例");
    }
    classDesc(){
        throw new Error(`
        请重写classDesc对当前的类进行描述，返回如下数据结构
        {
            groupName:"auth",
            groupDesc:"认证相关的包"
            desc:"关于认证的类",
            exam:"",
        }
        `);
    }
    descMethods(){
        var methoddescs=this.methodDescs();
        for(var methoddesc of methoddescs){
            for(var paramdesc of methoddesc.paramdescs){
                this.descMethod(methoddesc.methodDesc,methoddesc.methodName
                    ,paramdesc.paramDesc,paramdesc.paramName,paramdesc.paramType,
                    paramdesc.defaultValue,methoddesc.rtnTypeDesc,methoddesc.rtnType);
            }
        }
    }
    methodDescs(){
        throw new Error(`
        请重写methodDescs对当前的类的所有方法进行描述，返回如下数据结构
        [
            {
                methodDesc:"生成访问token",
                methodName:"getAccessKey",
                paramdescs:[
                    {
                        paramDesc:"访问appkey",
                        paramName:"appkey",
                        paramType:"string",
                        defaultValue:"x",
                    },
                    {
                        paramDesc:"访问secret",
                        paramName:"secret",
                        paramType:"string",
                        defaultValue:null,
                    }
                ],
                rtnTypeDesc:"xxxx",
                rtnType:"xxx"
            }
        ]
        `);
    }
     descMethod(methodDesc,methodName,paramDesc,paramName,paramType,defaultValue,rtnTypeDesc,rtnType){
        var mobj=this.apiDoc.methods.filter((m)=>{
            if(m.name==methodName){
                return true; 
            }else{
                return false;
            }
        })[0];
        var param={
            pname:paramName,
            ptype:paramType,
            pdesc:paramDesc,
            pdefaultValue:defaultValue,
        };
        if(mobj!=null){
            mobj.params.push(param);
        }else{
            this.apiDoc.methods.push(
                {
                    methodDesc:methodDesc?methodDesc:"",
                    name:methodName,
                    params:[param],
                    rtnTypeDesc:rtnTypeDesc,
                    rtnType:rtnType
                }
            );
        }
    }
}
module.exports=DocBase;

  