module.exports = (db, DataTypes) => {
  const enums={
     price:"宝币兑换率",
     initGift:"初次赠送",
     apiCallPrice:"API调用价格",
     apiInitGift:"API初次赠送次数",
     logOpWrite:"操作日志步骤是否写入，0否，1是",
  }
  var PConfig=db.define("pconfig", {
    name: {
      type:DataTypes.STRING,
      allowNull: false,
      // get(){
      //   const ctype = this.getDataValue("configType");
      //   return enums[ctype];
      // }
    },
    configType: {
      type:DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(enums),
      set:function(val){
        this.setDataValue("name",enums[val]);
        this.setDataValue("configType",val);
      }
    },
    configValue: {
      type:DataTypes.STRING,
      allowNull: false,
    },
    appkey: {
      type:DataTypes.STRING,
      allowNull: false,
    },
  },{
     paranoid: true,//假的删除
     underscored: true,
     version: true,
     freezeTableName: true,
     tableName: 'p_config',
     validate: {
     },
  });
  PConfig.enums=enums;
  return PConfig;
}
