const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
//开放平台缓存所有的应用的访问token
class ApiAccessKeyCache extends CacheBase {
  constructor() {
    super();
    this.appDao = system.getObject("db.common.appDao");
  }
  desc() {
    return "缓存访问Token";
  }
  prefix() {
    return "gapps_accesskey:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    if (!items || items.length == 0) {
      return null;
    }
    const configValue = await this.appDao.findOne(items[0], val);
    if (configValue) {
      return JSON.stringify(configValue);
    }
    return null;
  }
}
module.exports = ApiAccessKeyCache;
