﻿var url = require("url");
var system = require("../../base/system");
const verify = require("../../base/utils/verify").Verify;
const CtxBody = require("../../base/utils/CtxBody");
const tmSpringboard = require("../../base/controller/tm.springboard");
// var userCtl = system.getObject("web.auth.userCtl");
module.exports = function (app) {
	app.post('/tm/springboard', async function(req, res) {
		let body = req.body || {};
		let _tmSpringboard = new tmSpringboard(body);
		try {
			verify.notNull(body.ActionProcess, 'ActionProcess 不能为空!');
			verify.notNull(body.ActionType, 'ActionType 不能为空!');
			verify.notNull(body.ActionBody, 'ActionBody 不能为空!');
			let data = await _tmSpringboard.transferRequest();
			CtxBody.success(res, data);
			console.log("----返回成功");
		} catch (error) {
			console.error("------error", error);
			await _tmSpringboard.addErrorLog(error);
			CtxBody.error(res, error);
		}
	});

};
