var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("service.common.oplogSve");
const regCfg = require("./regCfg")
//gongshang zhuce
class RegCenterOrderService extends AppServiceBase {
  constructor() {
    super();
    this.execlient = system.getObject("util.execClient");
    this.channelApiUrl = settings.channelApiUrl();
    this.centerChannelUrl = settings.centerChannelUrl();
    this.appInfo = {
      aliyuntmtransfer: { appkey: settings.appKey, secret: settings.secret }
    };
  }

  // -------------提交reg需求--------laolan 2020.12.17-------百度reg接入使用--------start------------------
  async getCenterTokenByApp(appinfo) {
    var reqTokenUrl = this.centerChannelUrl + "/api/opreceive/accessAuth/getAppTokenByAppKey";
    var reqParam = appinfo;
    if (!reqParam || !reqParam.uapp_key || !reqParam.uapp_secret) {
      return system.getResult(null, "reqType类型有误，请求失败");
    }
    var param = {
      "actionType": "getAppTokenByAppKey",
      "actionBody": {
        "appkey": reqParam.uapp_key,
        "secret": reqParam.uapp_secret
      }
    };
    
    var rtn = await this.execlient.execPost(param, reqTokenUrl);
    if (!rtn.stdout) {
      return system.getResult(null, "获取token失败");
    }
    var tokenResult = JSON.parse(rtn.stdout);
    return tokenResult;
  }

  async reqcenterchannel2(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "无效应用",
        "errorCode": "ok"
      };
    }
    var self = this;
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "getTokenInfo fail",
        "errorCode": "ok"
      };
    }
    var userpin = "";
    if(pobj.phone&&!pobj.mobile){
      pobj.mobile=pobj.phone;
    }
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.mobile
        }
      };
      // pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
      // pobj.actionBody.mobile = pobj.mobile;//用户手机号
      var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return system.getResultFail(-99, "获取userpin失败");
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        return system.getResultFail(-88, "获取userpin失败!!");
      }
      
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
    var token = tokenInfo.data.token;
    var rtn = null;
    var self = this;
    if (userpin) {
      rtn = await self.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    } else {
      rtn = await self.execlient.execPostTK(sobj, url, token);
      if (rtn.status == 0) {
        return {
          "requestId": rtn.requestId,
          "success": true,
          "errorMsg": "",
          "errorCode": "ok"
        };
      } else {
        return {
          "requestId": rtn.requestId,
          "success": false,
          "errorMsg": rtn.msg,
          "errorCode": "ok"
        };
      }
    }
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }

    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }
  //百度reg 2.3 请求
  async regOrderStatus(pobj) {
    var self = this;
    if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "无效应用",
        "errorCode": "ok"
      };
    }
    // 获取app token
    // var tokenInfo = await this.getCenterToken();
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {}
    };
    var i=0;
    var orderLength = pobj.Length
    for(i=0;i<=orderLength;i++){

      // 引用属性，channel依赖bizId order依赖intentionBizId
      pobj[i].intentionBizId = pobj[i].bizId
      if (pobj.isDirectBuy==1){//直购
        userparam.actionBody.channelUserId = pobj.phone
        userparam.actionBody.mobile = pobj.phone
        userparam.actionBody.userName = pobj.phone
        pobj.publishMobile = pobj.phone
        pobj.channelTypeCode = pobj.consultType;
        if (pobj[i].area) {
          pobj[i].area = regCfg.baiduArea[pobj[i].area]
        }
        pobj[i].province = pobj[i].area;
      }else {
        var sobj = {
          "actionType": "getItemByChannelSolutionNo",
          "actionBody": pobj
        }
        // getItemByChannelSolutionNo
        var url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
        var result = await this.execlient.execPostTK(sobj, url, token);
        if (result.status != 0) {
          return {
            "requestId": result.requestId,
            "success": false,
            "errorMsg": result.msg,
            "errorCode": "ok"
          };
        }
        userparam.actionBody.channelUserId = result.data.channelUserId
        userparam.actionBody.mobile = result.data.publishMobile
        userparam.actionBody.userName = result.data.publishMobile
        pobj[i].publishMobile = result.data.publishMobile;
        pobj[i].channelNeedNo = result.data.channelNeedNo;
        
        pobj[i].needNo = result.data.needNo;
        pobj[i].channelTypeCode = result.data.channelTypeCode;
        pobj[i].province = result.data.solutionProvince;//北京(新购)?
      }

    }
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
    if (userpinResultTmp.status != 0) {
      return {
        "requestId": userpinResultTmp.requestId,
        "success": false,
        "errorMsg": userpinResultTmp.msg,
        "errorCode": "ok"
      };
    }
    //regOrderStatus
    var url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
    var sobj = {
      "actionType": "regOrderStatus",
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token,userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    return {
      "requestId": result.requestId,
      "success": true,
      "errorMsg": "",
      "errorCode": "ok"
    };
  }
  //百度reg 2.4 请求 关闭reg订单
  async regOrderClose(pobj) {
    var self = this;
    if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "无效应用",
        "errorCode": "ok"
      };
    }
    // 获取app token
    // var tokenInfo = await this.getCenterToken();
    var tokenInfo = await this.getCenterTokenByApp(pobj.appInfo);
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    var sobj = {
      "actionType": "getSolutionByChannelOrderNo",
      "actionBody": pobj
    }
    // getItemByChannelSolutionNo
    var url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
    var result = await this.execlient.execPostTK(sobj, url, token);
    if (result.status != 0 || !result.data) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    if(!result.data.solutionContent || !result.data.solutionContent.customerInfo || !result.data.solutionContent.customerInfo.publishMobile){
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": "方案客户信息有误",
        "errorCode": "ok"
      };
    }
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {
        channelUserId:result.data.solutionContent.customerInfo.publishMobile,
        mobile:result.data.solutionContent.customerInfo.publishMobile,
        userName:result.data.solutionContent.customerInfo.publishMobile
      }
    };
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, token);
    if (userpinResultTmp.status != 0) {
      return {
        "requestId": userpinResultTmp.requestId,
        "success": false,
        "errorMsg": userpinResultTmp.msg,
        "errorCode": "ok"
      };
    }
    var closeobj = {
      "actionType": "regOrderClose",
      "actionBody": pobj
    }
    var url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
    var rtn = await this.execlient.execDataPostByTokenUserPin(closeobj, url, token,userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    return {
      "requestId": result.requestId,
      "success": true,
      "errorMsg": "",
      "errorCode": "ok"
    };
  }
// -------------提交reg需求--------laolan 2020.12.17-------百度reg接入使用--------end------------------
  async paySuccess(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
      // return { "message": "success", "data": {}, "code": 200 }
    }
    var userpin = "";
    if (pobj.phone) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.phone,
          "mobile": pobj.phone,
          "userName": pobj.phone
        }
      };
      var self = this;
      // pobj.actionBody.channelUserId = pobj.mobile;//渠道用户id，没有则用手机号
      // pobj.actionBody.mobile = pobj.mobile;//用户手机号
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/ic/springBoard";
    var token = tokenInfo.data.token;
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      // return { "message": "网络错误", "data": {}, "code": -102 }
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      // return { "message": "true", "data": {}, "code": 200 }
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      // return { "message": result.msg, "data": {}, "code": -102 }
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }

  async orderClose(pobj) {
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var self = this;
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }

    var url = settings.centerChannelUrl() + "/api/opreceive/ic/springBoard";
    var token = tokenInfo.data.token;
    var rtn = await self.execlient.execPostTK(sobj, url, token);
    if (rtn.status == 0) {
      return {
        "requestId": rtn.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": rtn.requestId,
        "success": false,
        "errorMsg": rtn.msg,
        "errorCode": "ok"
      };
    }
  }

  //icp 2.3 请求
  async queryOrderState(pobj) {
    var self = this;
    // 获取app token
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    // 引用属性，channel依赖bizId order依赖intentionBizId
    pobj.intentionBizId = pobj.bizId
    // 获取userpin
    var userparam = {
      actionType: "getLoginByUserName",
      actionBody: {}
    };
    if (pobj.isDirectBuy === "true"){//直购
      if (!pobj.mobile){
        var sobj = {
          "actionType": "getSolutionByChannelSolutionNo",
          "actionBody": pobj
        }
        var url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
        var result = await this.execlient.execPostTK(sobj, url, token);
        if (result.status != 0) {
          return {
            "requestId": result.requestId,
            "success": false,
            "errorMsg": result.msg,
            "errorCode": "ok"
          };
        }
        pobj.mobile = result.data.solutionContent.customerInfo.publishMobile
      }
      userparam.actionBody.channelUserId = pobj.mobile
      userparam.actionBody.mobile = pobj.mobile
      userparam.actionBody.userName = pobj.mobile
      pobj.publishMobile = pobj.mobile
      pobj.channelTypeCode = pobj.bizId.startsWith("EDI")?7:5;
      //pobj.province = pobj.companyLocation+`（${pobj.actionType}）`
      pobj.province = pobj.area
    }else {
      var sobj = {
        "actionType": "getItemByChannelSolutionNo",
        "actionBody": pobj
      }
      // getItemByChannelSolutionNo
      var url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
      var result = await this.execlient.execPostTK(sobj, url, token);
      if (result.status != 0) {
        return {
          "requestId": result.requestId,
          "success": false,
          "errorMsg": result.msg,
          "errorCode": "ok"
        };
      }
      userparam.actionBody.channelUserId = result.data.channelUserId
      userparam.actionBody.mobile = result.data.publishMobile
      userparam.actionBody.userName = result.data.publishMobile
      pobj.publishMobile = result.data.publishMobile;
      pobj.channelNeedNo = result.data.channelNeedNo;
      pobj.needNo = result.data.needNo;
      pobj.channelTypeCode = result.data.channelTypeCode;
      pobj.province = result.data.solutionProvince;//北京(新购)?
    }
    var url = settings.centerChannelUrl() + "/api/opreceive/accessAuth/springBoard";
    var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
    if (userpinResultTmp.status != 0) {
      return {
        "requestId": userpinResultTmp.requestId,
        "success": false,
        "errorMsg": userpinResultTmp.msg,
        "errorCode": "ok"
      };
    }
    // icpNotify
    var url = settings.centerChannelUrl() + "/api/action/regCenterOrder/springBoard";
    var sobj = {
      "actionType": "icpNotify",
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token,userpinResultTmp.data.userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status != 0) {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
    return {
      "requestId": result.requestId,
      "success": true,
      "errorMsg": "",
      "errorCode": "ok"
    };
  }

  // 2020 0925 lin 新增 阿里文网文 服务商侧提供接口2.1 提交用户需求给服务商
  async submitNeedAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          // 为什么2.1 有userId 但是不用 还要用mobile。因为模式不支持
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.userName ? pobj.userName : pobj.mobile
        }
      };
      var self = this;
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    // 2020 0927 lin 新增 type 由 esp.wangwen 转换为 wangwen
    if(pobj.type == "esp.wangwen") {
      pobj.type == "wangwen"
    }
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }

  // 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.2 关闭需求通知服务商
  async needCloseAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    if (pobj.mobile) {
      //获取用户userpin
      var userparam = {
        actionType: "getLoginByUserName",
        actionBody: {
          "channelUserId": pobj.mobile,
          "mobile": pobj.mobile,
          "userName": pobj.userName ? pobj.userName : pobj.mobile
        }
      };
      var self = this;
      var url = settings.centerChannelUrl() + "/api/auth/accessAuth/springBoard";
      var userpinResultTmp = await this.execlient.execPostTK(userparam, url, tokenInfo.data.token);
      if (userpinResultTmp.status != 0 && userpinResultTmp.status != 2060) {
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
      userpin = userpinResultTmp.data.userpin;
      if (!userpin) {
        // return { "message": "网络错误", "data": {}, "code": -102 }
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
    }
    //带userpin请求
    url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }

    // 2020 0927 lin 新增 阿里文网文 服务商侧提供接口2.3 服务单通知服务商
    async produceNoticeAliEsp(pobj) {
      var tokenInfo = await this.getCenterToken();
      if (tokenInfo.status != 0) {
        return {
          "requestId": this.getUUID(),
          "success": true,
          "errorMsg": "",
          "errorCode": "ok"
        };
      }
      var token = tokenInfo.data.token;
      var userpin = "";
      //带userpin请求
      var url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
      var sobj = {
        "actionType": pobj.action_type,
        "actionBody": pobj
      }
      var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
      if (!rtn || !rtn.stdout) {
        return {
          "requestId": self.getUUID(),
          "success": false,
          "errorMsg": "网络错误",
          "errorCode": "ok"
        };
      }
      var result = JSON.parse(rtn.stdout);
      if (result.status == 0) {
        return {
          "requestId": result.requestId,
          "success": true,
          "errorMsg": "",
          "errorCode": "ok"
        };
      } else {
        return {
          "requestId": result.requestId,
          "success": false,
          "errorMsg": result.msg,
          "errorCode": "ok"
        };
      }
    }

  // 2020 0928 lin 新增 阿里文网文 服务商侧提供接口2.4 ⽤户⽅案反馈通知服务商
  async soulutionFeebackAliEsp(pobj) {
    var tokenInfo = await this.getCenterToken();
    if (tokenInfo.status != 0) {
      return {
        "requestId": self.getUUID(),
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    }
    var token = tokenInfo.data.token;
    var userpin = "";
    //带userpin请求
    var url = settings.centerChannelUrl() + "/api/opreceive/edi/springBoard";
    var sobj = {
      "actionType": pobj.action_type,
      "actionBody": pobj
    }
    var rtn = rtn = await this.execlient.execDataPostByTokenUserPin(sobj, url, token, userpin);
    if (!rtn || !rtn.stdout) {
      return {
        "requestId": self.getUUID(),
        "success": false,
        "errorMsg": "网络错误",
        "errorCode": "ok"
      };
    }
    var result = JSON.parse(rtn.stdout);
    if (result.status == 0) {
      return {
        "requestId": result.requestId,
        "success": true,
        "errorMsg": "",
        "errorCode": "ok"
      };
    } else {
      return {
        "requestId": result.requestId,
        "success": false,
        "errorMsg": result.msg,
        "errorCode": "ok"
      };
    }
  }
}
module.exports = RegCenterOrderService;
