const system = require("../../../system");
var settings = require("../../../../config/settings");

class OpCacheUtilsSve {
  constructor() {
    this.cacheManager = system.getObject("db.common.cacheManager");
  }
  async getPlatformAppItem(token) {
    return await this.cacheManager["ApiAccessKeyCheckCache"].cache(token, { status: true }, system.exTime);
  }
  async getLongAppItem(uAppkey) {
    return await this.cacheManager["ApiAppKeyCheckCache"].cache(uAppkey, null, system.exTime);
  }
  async getUserItem(selfAppInfo, channelUserId, actionBody) {
    var userCacheKey = selfAppInfo.data.uappKey + "_" + channelUserId;
    return await this.cacheManager["ApiUserCache"].cache(userCacheKey, channelUserId,
      system.exTime, actionBody, selfAppInfo);
  }

}
module.exports = OpCacheUtilsSve;
