const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
const getRawBody = require('raw-body');
class GatewaypushlogService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(GatewaypushlogService));
    //this.appDao=system.getObject("db.appDao");
    this.opLogUrl = settings.apiconfig.opLogUrl();
    this.opLogEsIsAdd = settings.apiconfig.opLogEsIsAdd();
  }


  getUUID() {
    var uuid = uuidv4();
    var u = uuid.replace(/\-/g, "");
    return u;
  }

  getResultSuccess(requestId) {
    return {
      "requestId": requestId,
      "success": true,
      "errorMsg": "",
      "errorCode": "ok"
    }
  }


  getResultFail(errmsg) {
    var self = this;
    return {
      "requestId": self.getUUID(),
      "success": false,
      "errorMsg": errmsg,
      "errorCode": "ok"
    };
  }


  //需求提交
  async submitNeed(pobj) {
    var self = this;
    if (!pobj.intentionBizId) {
      return self.getResultFail("intentionBizId不能为空");
    }
    if (!pobj.mobile) {
      return self.getResultFail("mobile不能为空");
    }
    if (!pobj.type) {
      return self.getResultFail("type不能为空");
    }
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/api/ali/esp/intention/submit",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/queryOrderState",//调用地址
      pushActionType: "submitNeed",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);
  }

  //需求关闭
  async needClose(pobj) {
    var self = this;
    if (!pobj.intentionBizId) {
      return self.getResultFail("intentionBizId不能为空");
    }
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/api/ali/esp/intention/close",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/queryOrderState",//调用地址
      pushActionType: "needClose",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);

  }

  //需求反馈
  async receiveFeedback(pobj) {
    var self = this;
    if (!pobj.solutionBizId) {
      return self.getResultFail("solutionBizId不能为空");
    }
    if (!pobj.operateType) {
      return self.getResultFail("operateType不能为空");
    }
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/api/ali/esp/intention/solution/feedback",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/queryOrderState",//调用地址
      pushActionType: "receiveFeedback",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);

  }

  //支付回调
  async paySuccess(pobj) {
    var self = this;
    if (!pobj.orderNo) {
      return { "message": "orderNo不能为空", "data": {}, "code": -200 };
    }
    if (!pobj.orderPrice) {
      if (pobj.orderPrice != 0) {
        return { "message": "orderPrice不能为空", "data": {}, "code": -200 };
      } else {
        pobj.orderPrice = "0";
      }
    }
    if (!pobj.phone) {
      return { "message": "phone不能为空", "data": {}, "code": -200 };
    }
    if (pobj.companyName) {
      if (!pobj.city) {
        return { "message": "city不能为空", "data": {}, "code": -200 };
      }
      if (!pobj.companyCategory) {
        return { "message": "companyCategory不能为空", "data": {}, "code": -200 };
      }
      if (!pobj.orgType) {
        return { "message": "orgType不能为空", "data": {}, "code": -200 };
      }
      if (!pobj.industryType) {
        return { "message": "industryType不能为空", "data": {}, "code": -200 };
      }
      if (!pobj.scope) {
        return { "message": "scope不能为空", "data": {}, "code": -200 };
      }
    } else if (pobj.park) {
      if (!pobj.productType) {
        return { "message": "productType不能为空", "data": {}, "code": -200 };
      }
    } else {
      return { "message": "参数异常", "data": {}, "code": -200 };
    }
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/api/ali/ic/paySuccess",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/queryOrderState",//调用地址
      pushActionType: "paySuccess",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await this.create(param);
    return { "message": "true", "data": {}, "code": 200 };
  }


  //icp需求提交
  async icpSubmitNeed(pobj) {
    var self = this;
    if (!pobj.intentionBizId) {
      return self.getResultFail("intentionBizId不能为空");
    }
    if (!pobj.phone) {
      return self.getResultFail("mobile不能为空");
    }
    if (!pobj.consultType) {
      return self.getResultFail("consultType不能为空");
    }
    pobj.type = pobj.consultType;
    pobj.mobile = pobj.phone;
    pobj.action_type = "submitNeed";
    if (pobj.area) {
      switch (pobj.area) {
        case "1":
          pobj.area = "北京";
          break;
        case "2":
          pobj.area = "上海";
          break;
        case "3":
          pobj.area = "福建";
          break;
        case "4":
          pobj.area = "广西";
          break;
        case "5":
          pobj.area = "广东";
          break;
        case "6":
          pobj.area = "安徽";
          break;
        case "7":
          pobj.area = "河南";
          break;
        case "8":
          pobj.area = "湖北";
          break;
        case "9":
          pobj.area = "浙江";
          break;
        case "10":
          pobj.area = "江苏";
          break;
        case "11":
          pobj.area = "山东";
          break;
        case "12":
          pobj.area = "陕西";
          break;
        case "13":
          pobj.area = "宁夏";
          break;
        case "14":
          pobj.area = "甘肃";
          break;
        case "15":
          pobj.area = "新疆";
          break;
        case "16":
          pobj.area = "青海";
          break;
        case "17":
          pobj.area = "天津";
          break;
        case "18":
          pobj.area = "重庆";
          break;
        case "19":
          pobj.area = "河北";
          break;
        case "20":
          pobj.area = "山西";
          break;
        case "21":
          pobj.area = "辽宁";
          break;
        case "22":
          pobj.area = "吉林";
          break;
        case "23":
          pobj.area = "黑龙江";
          break;
        case "24":
          pobj.area = "江西";
          break;
        case "25":
          pobj.area = "湖南";
          break;
        case "26":
          pobj.area = "四川";
          break;
        case "27":
          pobj.area = "贵州";
          break;
        case "28":
          pobj.area = "云南";
          break;
        case "29":
          pobj.area = "内蒙古";
          break;
        case "30":
          pobj.area = "西藏";
          break;
        case "31":
          pobj.area = "含外资";
          break;
        case "32":
          pobj.area = "全外资";
          break;
        case "33":
          pobj.area = "香港";
          break;
        case "34":
          pobj.area = "海南";
          break;
        default:
          pobj.area = "";
          break;
      }
    }
    if (!pobj.area) {
      return self.getResultFail("area参数错误");
    }
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/api/ali/tm/consultation/submit",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/springBoard",//调用地址
      pushActionType: "submitNeed",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);

  }

  //icp需求反馈
  async icpFeedbackSubmit(pobj) {
    var self = this;
    if (!pobj.intentionBizId) {
      return self.getResultFail("intentionBizId不能为空");
    }
    if (!pobj.description) {
      return self.getResultFail("description不能为空");
    }
    if (!pobj.intentionStatus) {
      return self.getResultFail("intentionStatus不能为空");
    }
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/api/ali/tm/feedback/submit",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/springBoard",//调用地址
      pushActionType: "icpFeedbackSubmit",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);
  }

  //icp状态变更
  async icpNotify(pobj) {
    var self = this;
    if (!pobj.bizId) {
      return self.getResultFail("bizId不能为空");
    }
    if (!pobj.status) {
      return self.getResultFail("status不能为空");
    }
    pobj.action_type = "queryOrderState";
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/api/ali/tm/status/notify",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/springBoard",//调用地址
      pushActionType: "icpNotify",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);
  }

  // 2020 0925 lin 新增 阿里文网文 服务商侧提供接口2.1 提交用户需求给服务商
  async submitNeedAliEsp(pobj) {
    var self = this;
    if (!pobj.intentionBizId) {
      return self.getResultFail("intentionBizId is empty");
    }
    if (!pobj.mobile) {
      return self.getResultFail("mobile is empty");
    }
    if (!pobj.userId) {
      return self.getResultFail("userId is empty");
    }
    if (!pobj.type) {
      return self.getResultFail("type is empty");
    }
    pobj.action_type = "submitNeedAliEsp";
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/ali/esp/intention/submit",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/springBoard",//调用地址
      pushActionType: "submitNeedAliEsp",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);
  }

  // 2020 0926 lin 新增 阿里文网文 服务商侧提供接口2.2 关闭需求通知服务商
  async needCloseAliEsp(pobj) {
    var self = this;
    if (!pobj.intentionBizId) {
      return self.getResultFail("intentionBizId is empty");
    }
    if (!pobj.note) {
      return self.getResultFail("note is empty");
    }
    pobj.action_type = "needCloseAliEsp";
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/ali/esp/intention/close",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/springBoard",//调用地址
      pushActionType: "needCloseAliEsp",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);
  }

  // 2020 0927 lin 新增 阿里文网文 服务商侧提供接口2.3 服务单通知服务商
  async produceNoticeAliEsp(pobj) {
    var self = this;
    if (!pobj.bizId) {
      return self.getResultFail("bizId is empty");
    }
    if (!pobj.status) {
      return self.getResultFail("status is empty");
    }
    if (!pobj.intentionBizId) {
      return self.getResultFail("intentionBizId is empty");
    }
    if (!pobj.isDirectBuy) {
      return self.getResultFail("isDirectBuy is empty");
    }
    if (!pobj.operationType) {
      return self.getResultFail("operationType is empty");
    }
    pobj.action_type = "produceNoticeAliEsp";
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/ali/esp/produce/notice",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/springBoard",//调用地址
      pushActionType: "produceNoticeAliEsp",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);
  }

  // 2020 0928 lin 新增 阿里文网文 服务商侧提供接口2.4 ⽤户⽅案反馈通知服务商
  async soulutionFeebackAliEsp(pobj) {
    var self = this;
    if (!pobj.solutionBizId) {
      return self.getResultFail("solutionBizId is empty");
    }
    if (!pobj.operateType) {
      return self.getResultFail("operateType is empty");
    }
    pobj.action_type = "soulutionFeebackAliEsp";
    var param = {
      requestId: self.getUUID(),
      requestUrl: "/ali/esp/intention/submit",
      requestjson: JSON.stringify(pobj),//请求地址
      pushUrl: "/action/intentionapi/springBoard",//调用地址
      pushActionType: "soulutionFeebackAliEsp",//调用参数
      pushtimes: 0,//推送次数
      pushStatus: "wts",//推送状态
    }
    await self.create(param);
    return self.getResultSuccess(param.requestId);
  }

}
module.exports = GatewaypushlogService;