const system = require("../system");
const moment = require('moment')
const settings = require("../../config/settings");
const md5 = require("MD5");
class AppServiceBase {
  constructor() {
    this.restClient = system.getObject("util.restClient");
    this.execClient = system.getObject("util.execClient");
    this.cacheManager = system.getObject("db.common.cacheManager");
  }
  /**
   * 验证签名
   * @param {*} params 要验证的参数 
   * @param {*} app_key 应用的校验key
   */
  async verifySign(params, app_key) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!params.sign) {
      return system.getResult(null, "请求参数sign为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey] && !(params[tKey] instanceof Array)) {
        signArr.push(tKey + "=" + params[tKey]);
      }
    }
    if (signArr.length == 0) {
      return system.getResult(null, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    if (params.sign != resultTmpSign) {
      return system.getResult(null, "返回值签名验证失败");
    }
    return system.getResultSuccess();
  }
  async restPostUrl(pobj, url) {
    var rtn = await this.restClient.execPost(pobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "restPost data is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  async execPostUrl(pobj, url) {
    var rtn = await this.execClient.execPost(pobj, url);
    if (!rtn || !rtn.stdout) {
      return system.getResult(null, "execPost data is empty");
    }
    var result = JSON.parse(rtn.stdout);
    return result;
  }
  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
}
module.exports = AppServiceBase;
