const system = require("../../system");
const uuidv4 = require('uuid/v4');
const md5 = require("MD5");
var settings = require("../../../config/settings");

class OpPlatformUtils {
    constructor() {
        this.restClient = system.getObject("util.restClient");
        this.redisClient = system.getObject("util.redisClient");
        this.createUserUrl = settings.paasUrl() + "api/auth/accessAuth/register";
        this.fetchDefaultVCodeUrl = settings.paasUrl() + "api/auth/accessAuth/fetchDefaultVCode";
        this.fetchOtherVCodeUrl = settings.paasUrl() + "api/auth/accessAuth/fetchOtherVCode";
        this.loginUrl = settings.paasUrl() + "api/auth/accessAuth/login";
        this.registerUrl = settings.paasUrl() + "api/auth/accessAuth/register";
        this.loginByVCodeUrl = settings.paasUrl() + "api/auth/accessAuth/loginByVCode";
        this.modiPasswordByMobileUrl = settings.paasUrl() + "api/auth/accessAuth/modiPasswordByMobile";
    }
    getUserPinKey(userpin) {
        return settings.cacheprefix + "_userPin:" + userpin;
    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    async getReqApiAccessKey(appKey, secret) {
        var cacheManager = system.getObject("db.common.cacheManager");
        var inputkeyStr = settings.cacheprefix + "_platformToken:appKey_" + settings.appKey;;
        var secretInfo = { appkey: settings.appKey, secret: settings.secret };
        if (appKey && secret) {
            inputkeyStr = settings.cacheprefix + "_platformToken:appKey_" + appKey;
            secretInfo.appkey = appKey;
            secretInfo.secret = secret;
        }
        var reqApiAccessKey = await cacheManager["ApiAccessKeyCache"].cache(inputkeyStr, secretInfo, system.exTime);

        if (!reqApiAccessKey || !reqApiAccessKey.data) {
            return system.getResult(null, "获取请求token失败");
        }
        return reqApiAccessKey;
    }
    /**
     * 创建用户信息
     * @param {*} userName 用户名
     * @param {*} mobile 手机号
     * @param {*} password 密码，不传为使用默认密码
     * 
     * 返回值：
     * {
            "status": 0,---值为2000为已经存在此用户，注册失败
            "msg": "success",
            "data": {
                "auth_url": "http://sj.app.com:3002/auth?opencode=1e4949d1c39444a8b32f023143625b1d",---回调url，通过回调地址获取平台用户信息
                "opencode": "1e4949d1c39444a8b32f023143625b1d",---平台用户code随机生成会变，平台是30s有效期，通过其可以向获取用户信息
                "open_user_id": 12---平台用户id
            },
            "requestid": "5362bf6f941e4f92961a61068f05cd7f"
        }
     */
    async createUserInfo(userName, mobile, password, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            userName: userName,
            mobile: mobile,
            password: password || settings.defaultPassWord,

        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.createUserUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }
    /**
     * 通过自定义模板获取手机模板短信
     * @param {*} param {
                mobile: actionBody.mobile,
                tmplCode: "SMS_151685065",
                signName: "小望科技",
                accessKeyId: "LTAI4Fjk6qBh4GELjkBxfyJF",
                accessKeySecret: "Z3wUHmZ0hnQst6uaTY3GzOYVoWwxb9"
            }
     * @param {*} appKey 
     * @param {*} secret 
     */
    async fetchOtherVCode(param, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.fetchOtherVCodeUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(null, restResult.msg);
        }
        return system.getResultSuccess();
    }

    /**
     * 获取默认的手机模板短信
     * @param {*} mobile 
     * @param {*} appKey 
     * @param {*} secret 
     */
    async fetchDefaultVCode(mobile, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = { mobile: mobile }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.fetchDefaultVCodeUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(null, restResult.msg);
        }
        return system.getResultSuccess(restResult);
    }
    /**
        * 创建用户信息
        * @param {*} userName 用户名
        * @param {*} mobile 手机号
        * @param {*} password 密码，不传为使用默认密码
        * 
        * 返回值：
        * {
               "status": 0,---值为2000为已经存在此用户，注册失败
               "msg": "success",
               "data": {
                   "auth_url": "http://sj.app.com:3002/auth?opencode=1e4949d1c39444a8b32f023143625b1d",---回调url，通过回调地址获取平台用户信息
                   "opencode": "1e4949d1c39444a8b32f023143625b1d",---平台用户code随机生成会变，平台是30s有效期，通过其可以向获取用户信息
                   "open_user_id": 12---平台用户id
               },
               "requestid": "5362bf6f941e4f92961a61068f05cd7f"
           }
        */
    async loginByVCode(mobile, vcode, password, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            mobile: mobile,
            vcode: vcode,
            password: password || ""
        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.loginByVCodeUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResultFail(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }
    /**
 * 用户登录
 * @param {*} userName 用户名
 * @param {*} password 密码，不传为使用默认密码
 * 
 * 返回值：
 * {
        "status": 0,---值为2010为用户名或密码错误
        "msg": "success",
        "data": {
            "auth_url": "http://sj.app.com:3002/auth?opencode=1e4949d1c39444a8b32f023143625b1d",---回调url，通过回调地址获取平台用户信息
            "opencode": "1e4949d1c39444a8b32f023143625b1d"---平台用户code随机生成会变，平台是30s有效期，通过其可以向获取用户信息
        },
        "requestid": "5362bf6f941e4f92961a61068f05cd7f"
    }
 */
    async register(userName, password, mobile, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            userName: userName,
            password: password || settings.defaultPassWord,
            mobile: mobile
        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.registerUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResultFail(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }

    /**
     * 用户登录
     * @param {*} userName 用户名
     * @param {*} password 密码，不传为使用默认密码
     * 
     * 返回值：
     * {
            "status": 0,---值为2010为用户名或密码错误
            "msg": "success",
            "data": {
                "auth_url": "http://sj.app.com:3002/auth?opencode=1e4949d1c39444a8b32f023143625b1d",---回调url，通过回调地址获取平台用户信息
                "opencode": "1e4949d1c39444a8b32f023143625b1d"---平台用户code随机生成会变，平台是30s有效期，通过其可以向获取用户信息
            },
            "requestid": "5362bf6f941e4f92961a61068f05cd7f"
        }
     */
    async login(userName, password, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            userName: userName,
            password: password || settings.defaultPassWord,

        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.loginUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResultFail(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }
    /**
     * 通过opencode获取用户登录信息----暂时不用
     * @param {*} opencode 用户登录或注册opencode
     * 
     * 返回值：
     * {
            "status": 0,---值为2010为用户名或密码错误
            "msg": "success",
            "data": {},---平台用户信息
            "requestid": "5362bf6f941e4f92961a61068f05cd7f"
        }
    */
    async authByCode(opencode, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = {
            opencode: opencode
        }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.authByCodeUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(restResult.status, restResult.msg);
        }
        return system.getResultSuccess(restResult.data);
    }

    async modiPasswordByMobile(mobile, vcode, newPwd, appKey, secret) {
        var reqApiAccessKey = await this.getReqApiAccessKey(appKey, secret);
        if (reqApiAccessKey.status != 0) {
            return reqApiAccessKey;
        }
        var param = { mobile: mobile, vcode: vcode, newPwd: newPwd }
        //按照访问token
        var restResult = await this.restClient.execPostWithAK(
            param,
            this.modiPasswordByMobileUrl, reqApiAccessKey.data.accessKey);

        if (restResult.status != 0 || !restResult.data) {
            return system.getResult(null, restResult.msg);
        }
        return system.getResultSuccess();
    }

    //------------------------新的方式------------------------------------------------------------------------------------
    async getReqTokenByHosts(actionBody) {
        var cacheManager = system.getObject("db.common.cacheManager");
        var inputkey = actionBody.reqType == "hosts" ? actionBody.appHosts : actionBody.appkey;
        var result = await cacheManager["AppTokenByHostsCache"].cache(inputkey, actionBody, system.exTime);
        return result;
    }

    /**
         * 渠道通过账户进行登录，有则返回用户信息，没有则创建用户---actionBody.channelUserId
         * @param {*} pobj  pobj.actionBody:{channelUserId:XX}
         */
    async getLoginByUserName(pobj) {
        var inputkey = pobj.appInfo.uapp_key + "_" + pobj.actionBody.channelUserId;
        var cacheManager = system.getObject("db.common.cacheManager");
        var result = await cacheManager["AppUserPinByUserNameCache"].getCache(inputkey);
        if (result && result.status == 0) {
            if (result.data.userpin) {
                // 2020 0723 lin修改 登录并重新设置过期时间
                var inputkey = this.getUserPinKey(inputkey);
                var userpinKey = this.getUserPinKey(result.data.userpin);
                await this.redisClient.setExpire(inputkey, system.exTime);
                await this.redisClient.setExpire(userpinKey, system.exTime);
                return system.getResultFail(system.reDoLoginFail, "请勿重复处理", { userpin: result.data.userpin || "" });
            } else {
                await this.clearLoginCache(inputkey);
            }
        }
        var result = await cacheManager["AppUserPinByUserNameCache"].cache(inputkey, pobj, system.exTime);
        if (result && result.status == 0) {
            var userpinKey = this.getUserPinKey(pobj.actionBody.userpin);
            this.redisClient.setWithEx(userpinKey, JSON.stringify(result), system.exTime);
        }
        return result;
    }

    /**
     * 通过账户和密码登录
     * @param {*} pobj  pobj.actionBody:{userName:XX,password:XXX}
     */
    async getReqUserPinByLgoin(pobj) {
        var inputkey = pobj.appInfo.uapp_key + "_" + pobj.actionBody.userName;
        var cacheManager = system.getObject("db.common.cacheManager");
        // var result = await cacheManager["AppUserPinByLoginPwdCache"].getCache(inputkey);
        // if (result && result.status == 0) {
        //     return system.getResultFail(system.reDoLoginFail, "请勿重复登录", { userpin: result.data.userpin || "" });
        // }
        var result = await cacheManager["AppUserPinByLoginPwdCache"].cache(inputkey, pobj, system.exTime);
        if (result && result.status == 0) {
            var userpinKey = this.getUserPinKey(pobj.actionBody.userpin);
            this.redisClient.setWithEx(userpinKey, JSON.stringify(result), system.exTime);
        }
        return result;
    }
    /**
     * 通过短信登录或注册信息
     * @param {*} pobj  pobj.actionBody:{mobile:XXX,vcode:XXX,reqType:"reg",password:XXX-reqType为reg时有此值}
     */
    async getReqUserPinByLgoinVcode(pobj) {
        var inputkey = pobj.appInfo.uapp_key + "_" + pobj.actionBody.mobile;
        var cacheManager = system.getObject("db.common.cacheManager");
        // if (pobj.actionBody.reqType != "reg") {
        //     var result = await cacheManager["AppUserPinByLoginVcodeCache"].getCache(inputkey);
        //     if (result && result.status == 0) {
        //         return system.getResultFail(system.reDoLoginFail, "请勿重复登录", { userpin: result.data.userpin || "" });
        //     }
        // }
        // var result = await cacheManager["AppUserPinByLoginVcodeCache"].cache(inputkey, pobj, system.exTime);
        // 2020 0805 lin 修改 cache 改为buildCache。buildCache为新增的方法。与cache的区别是 不去get获取 直接走buildCacheVal
        var result = await cacheManager["AppUserPinByLoginVcodeCache"].buildCache(inputkey, pobj, system.exTime);
        if (result && result.status == 0 && pobj.actionBody.reqType != "reg") {
            var userpinKey = this.getUserPinKey(pobj.actionBody.userpin);
            this.redisClient.setWithEx(userpinKey, JSON.stringify(result), system.exTime);
        }
        return result;
    }
    /**
     * 通过手机验证码修改用户密码
     * @param {*} pobj 
     * @param {*} actionBody {mobile:XX,vcode:XXX,newPwd:XXX,userpin:XXXXX}
     */
    async putUserPwdByMobile(pobj, actionBody) {
        if (!actionBody.mobile) {
            return system.getResult(null, "pobj.mobile can not be empty ！");
        }
        if (!actionBody.vcode) {
            return system.getResult(null, "pobj.vcode can not be empty ！");
        }
        if (!actionBody.newPwd) {
            return system.getResult(null, "pobj.newPwd can not be empty ！");
        }
        if (!pobj.appInfo) {
            return system.getResult(null, "pobj.appInfo can not be empty ！");
        }
        var acckapp = await this.modiPasswordByMobile(actionBody.mobile, actionBody.vcode, actionBody.newPwd, pobj.appInfo.uapp_key, pobj.appInfo.uapp_secret);
        return acckapp;
    }
    /**
    * 获取账户信息
    * @param {*} pobj pobj.actionBody:{userpin:XXX}
    */
    async getUserLoginInfo(pobj) {
        var userpinKey = this.getUserPinKey(pobj.actionBody.userpin);
        var userInfoResult = await this.redisClient.get(userpinKey);
        if (!userInfoResult) {
            return system.getResultFail(system.noLogin, "user no login");
        }
        // 2020 0723 lin修改 获取账户信息并重新设置过期时间
        // await this.redisClient.setExpire(userpinKey, system.exTime);
        return JSON.parse(userInfoResult);
    }
    /**
     * 退出账户登录
     * @param {*} pobj pobj.actionBody:{userpin:XXX}
     */
    async logout(pobj) {
        var userpinKey = this.getUserPinKey(pobj.actionBody.userpin);
        var userInfoResult = await this.redisClient.get(userpinKey);
        if (!userInfoResult) {
            return system.getResultSuccess(null, "ok！！");
        }
        var userResult = JSON.parse(userInfoResult);
        if (userResult.status == 0) {
            var inputkey = pobj.appInfo.uapp_key + "_" + userResult.data.channel_username;
            await this.clearLoginCache(inputkey);
        }
        this.redisClient.delete(userpinKey);
        return system.getResultSuccess();;
    }
    async clearLoginCache(inputkey) {
        var cacheManager = system.getObject("db.common.cacheManager");
        await cacheManager["AppUserPinByLoginPwdCache"].invalidate(inputkey);
        await cacheManager["AppUserPinByLoginVcodeCache"].invalidate(inputkey);
        await cacheManager["AppUserPinByUserNameCache"].invalidate(inputkey);
    }
}

module.exports = OpPlatformUtils;
