var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const querystring = require('querystring');
const md5 = require("MD5");
class utilsTlBankSve extends AppServiceBase {
  constructor() {
    super();
    this.logCtl = system.getObject("service.common.oplogSve");
    this.wxMethod = "W01";//微信订单支付
    this.aliMethod = "A01";//阿里订单支付
    this.notifyUrl = "https://igirl.gongsibao.com/api/tl/zxNotify";//通联后台配置，H5则不需要配置，H5可自定义传递通知Url
    this.restClient = system.getObject("util.restClient");
    this.appDao = system.getObject("db.dbapp.appDao");
    this.apppayparamDao = system.getObject("db.dbapp.apppayparamDao");

  }

  async getPayParamItem(uappId) {//获取通联支付信息配置
    var item = await this.apppayparamDao.getItemByUAppId(uappId);
    if (!item) {
      return system.getResult(null, "应用支付参数为空");
    }
    return system.getResultSuccess(item);
  }

  async getAppItem(uappId) {//获取应用信息
    var item = await this.appDao.getItemByUAppId(uappId);
    if (!item) {
      return system.getResult(null, "应用数据为空");
    }
    return system.getResultSuccess(item);
  }

  async getAppItemByAppkey(uappId) {//根据appKey获取应用信息
    var item = await this.appDao.getItemByAppKey(uappId);
    if (!item) {
      return system.getResult(null, "应用数据为空");
    }
    return system.getResultSuccess(item);
  }
  //-------------------------------------------h5支付-----------------开始

  /**
   * 唤起H5支付---只供简单应用
   * @param {*} pobj 
   * @param {*} actionBody {total_fee:总额，单位为分，order_num:订单号，body_desc:标题描述}
   */
  async getH5PayUrl(pobj, actionBody) {
    // pobj.actionBody.body_desc, pobj.actionBody.total_fee, pobj.actionBody.order_num, pobj.actionBody.returl
    var payParam = await this.apppayparamDao.getItemByUAppId(pobj.appInfo.uapp_id);
    if (!payParam) {
      return { status: -210, msg: "应用没有对应的支付凭证" }
    }
    var timestamp = Date.now();
    var jsonObj = {
      appid: payParam.pay_appid,
      cusid: payParam.mch_id,
      version: 12,
      trxamt: pobj.actionBody.total_fee,//单位为分
      reqsn: "qft" + pobj.actionBody.order_num + "_" + pobj.appInfo.uapp_id,
      charset: "UTF-8",
      returl: pobj.actionBody.returl,
      notify_url: actionBody.notify_url || this.notifyUrl,
      body: pobj.actionBody.body_desc,
      remark: "h5paypagesywdy",
      randomstr: timestamp.toString()//随机字符串，不长于32位    
    }
    var param_result = await this.getReqBeforeParam(jsonObj, payParam.pay_key);
    if (param_result.status != 0) {
      return param_result;
    }
    var paramStr = Object.keys(jsonObj).sort().map(key => {
      return `${encodeURIComponent(key)}=${encodeURIComponent(jsonObj[key])}`
    }).join('&');

    return { status: 0, payUrl: "https://syb.allinpay.com/apiweb/h5unionpay/unionorder?" + paramStr };
  }



  //-------------------------------------------h5支付-----------------结束

  //----------------------------------------------------------------------------------------请求银行接口开始---------------------------------------------------

  /*
    company_id:公司id、
    order_num：订单号、
    total_fee：订单金额单位为分、
    product_id：产品id、
    body_desc：内容描述（可以是产品名称）、
    create_ip：创建ip、
    opType：操作类型，1微信、2支付宝    
    返回错误码：成功为1
  返回错误码：成功为1
  -210：应用没有对应的支付凭证
  -230：请求参数信息为空
  -250：请求组装签名参数信息为空
  -280：请求结算接口返回失败
  
  -310：返回值信息data为空
  -230：返回值参数信息为空
  -250：返回值组装签名参数信息为空
  -280：返回值签名验证失败
  
  -400：请求接口请求返回值错误
  -410：请求结算接口返回空           
  */
  async getQrCode(app_id, order_num, total_fee, body_desc, op_type) {//获取微信支付二维码
    // var payParam = await this.companypayparamDao.getOneByCompanyId(company_id, 1);
    var payParam = await this.apppayparamDao.getItemByUAppId(app_id);
    if (!payParam) {
      var rtn = await this.restClient.execPost2(req_param, reqUrl);
      return { status: -210, msg: "应用没有对应的支付凭证" }
    }
    var reqMethod = this.wxMethod;
    if (op_type == "alipay") {
      reqMethod = this.aliMethod;
    }
    var timestamp = Date.now();
    var jsonObj = {
      appid: payParam.pay_appid,
      cusid: payParam.mch_id,
      trxamt: total_fee,//单位为分
      reqsn: "qft" + order_num + "_" + app_id.toString(),
      paytype: reqMethod,
      randomstr: timestamp.toString(),//随机字符串，不长于32位
      body: body_desc,
      notify_url: payParam.notifyUrl,
    }
    var param_result = await this.getReqBeforeParam(jsonObj, payParam.pay_key);
    if (param_result.status != 0) {
      return param_result;
    }
    var reqUrl = payParam.pay_url + "/pay";
    var result = await this.execReqInfo("getQrCode", reqUrl, jsonObj);
    if (result.status != 0) {
      return result;
    }
    var signResult = await this.resultSign(result.data, payParam.pay_key);
    if (signResult.status != 0) {
      return signResult;
    }
    result.data = {
      payinfo: result.data.payinfo,
      reqsn: result.data.reqsn,//商户订单号
      chnltrxid: result.data.chnltrxid,// 支付渠道交易单号,如支付宝,微信平台的交易单号
      trxid: result.data.trxid,// 交易单号,平台的交易流水号
      // 交易状态，0000：交易成功、1001：交易不存在、
      //2008或者2000 : 交易处理中,请查询交易,如果是实时交易(例如刷卡支付,交易撤销,退货),建议每隔一段时间(10秒)查询交易、
      //3888-流水号重复、其他3开头的错误码代表交易失败
      trxstatus: result.data.trxstatus,
      fintime: result.data.fintime,// 交易完成时间 yyyyMMddHHmmss
      errmsg: result.data.errmsg,// 错误原因
      notify_url: this.notifyUrl
    };
    return result;
  }

  async execReqInfo(self_method_name, reqUrl, param) {
    try {
      var req_param = querystring.stringify(param);
      var rtn = await this.restClient.execPost2(req_param, reqUrl);
      var rtnResult = { status: 0, msg: "success", data: {} };
      if (rtn && rtn.stdout) {
        var tmpResult = JSON.parse(rtn.stdout);
        if (tmpResult.retcode == "FAIL") {
          rtnResult.status = -400;
          rtnResult.msg = tmpResult.retmsg;
        } else {
          rtnResult.data = tmpResult;
        }
      } else {
        rtnResult.status = -410;
        rtnResult.msg = '请求结算接口返回空';
      }
      return rtnResult;
    } catch (e) {
      throw new Error(e.stack);
    }
  }


  /*
  company_id:公司id、
  order_num：订单号、
  opType：操作类型，1微信、2支付宝   
  返回错误码：成功为1
  -210：应用没有对应的支付凭证
  -230：请求参数信息为空
  -250：请求组装签名参数信息为空
  -280：请求结算接口返回失败
  
  -310：返回值信息data为空
  -230：返回值参数信息为空
  -250：返回值组装签名参数信息为空
  -280：返回值签名验证失败
   
  -400：请求接口请求返回值错误
  -410：请求结算接口返回空    
  */
  async queryOrder(uapp_id, trxid) {//查询通联订单支付状态
    var payParam = await this.apppayparamDao.getItemByUAppId(uapp_id);
    if (!payParam) {
      return { status: -210, msg: "应用没有对应的支付凭证" }
    }
    var timestamp = Date.now();
    var jsonObj = {
      appid: payParam.pay_appid,
      cusid: payParam.mch_id,
      // reqsn: order_num + "_" + uapp_id.toString(),//reqsn和trxid必填其一
      trxid: trxid,//平台交易流水
      randomstr: timestamp.toString(),//随机字符串，不长于32位
    }
    var param_result = await this.getReqBeforeParam(jsonObj, payParam.pay_key);
    if (param_result.status != 0) {
      return param_result;
    }
    var reqUrl = payParam.pay_url + "/query";
    // console.log(param_result.req_param, "data............");

    var result = await this.execReqInfo("queryOrder", reqUrl, jsonObj);
    if (result.status != 0) {
      return result;
    }

    var signResult = await this.resultSign(result.data, payParam.pay_key);
    if (signResult.status != 0) {
      return signResult;
    }
    result.data = {
      trxcode: result.data.trxcode,//交易类型，VSP501	微信支付、VSP511	支付宝支付
      trxamt: result.data.trxamt,//交易金额 单位为分
      reqsn: result.data.reqsn.substr(3),//商户订单号
      chnltrxid: result.data.chnltrxid,// 支付渠道交易单号,如支付宝,微信平台的交易单号
      trxid: result.data.trxid,// 交易单号,平台的交易流水号
      // 交易状态，0000：交易成功、1001：交易不存在、
      //2008或者2000 : 交易处理中,请查询交易,如果是实时交易(例如刷卡支付,交易撤销,退货),建议每隔一段时间(10秒)查询交易、
      //3888-流水号重复、其他3开头的错误码代表交易失败
      trxstatus: result.data.trxstatus,
      fintime: result.data.fintime,// 交易完成时间 yyyyMMddHHmmss
      errmsg: result.data.errmsg,// 错误原因
    };
    return result;
  }

  async receiveCallBackNotify(parmas, client_ip) {//收到通联回调通知---post请求
    try {
      if (!parmas) {
        return system.getResult(null, "回调parmas中参数信息为空");
      }
      //日志记录
      this.logCtl.info({
        optitle: (new Date()).Format("yyyy-MM-dd hh:mm:ss") + "：，method=" + parmas.trxcode,
        op: "center-app/app/base/service/impl/utilsSve/utilstlbankSve.js/receiveCallBackNotify",
        content: JSON.stringify(parmas),
        clientIp: client_ip || ""
      });
      var isVerify = await this.verifyCallBackParams(parmas);
      if (isVerify) {
        return system.getResult(null, isVerify);
      }
      let attachList = [];
      if (parmas.cusorderid.indexOf("_") >= 0) {
        attachList = parmas.cusorderid.split("_");
      }
      else {
        attachList.push(parmas.cusorderid);
      }
      if (attachList.length < 2) {
        return system.getResult(null, "回调cusorderid参数错误，没有_标识");
      }
      var uappid = attachList.length == 2 ? attachList[1] : attachList[2];

      var payParam = await this.apppayparamDao.getItemByUAppId(uappid);
      if (!payParam) {
        return system.getResult(null, "app_pay_param回调应用没有对应的支付凭证");
      }
      if (!payParam.notify_url) {
        return system.getResult(null, "app_pay_param回调应用没有对应的支付成功通知url配置");
      }
      var appinfo = await this.appDao.getItemByUAppId(uappid);
      if (!appinfo) {
        return system.getResult(null, "app回调应用没有对应的支付凭证");
      }
      var signResult = await this.resultSign(parmas, payParam.pay_key);
      if (signResult.status != 0) {
        return signResult;
      }
      //解析支付参数
      parmas.out_trade_no = attachList[0].substr(3);
      parmas.uappid = attachList.length == 2 ? attachList[1] : attachList[2];
      //重写新签名
      var signResult = await this.createSign(parmas, appinfo.uapp_secret);
      if (signResult.status != 0) {
        return signResult;
      }
      parmas.sign = signResult.data;
      var backResult = await this.restPostUrl(parmas, payParam.notify_url);
      return backResult;
    } catch (e) {
      this.logCtl.error({
        optitle: "回调业务处理---error异常",
        op: "center-app/app/base/service/impl/utilsSve/utilstlbankSve.js/receiveCallBackNotify",
        content: "参数=" + JSON.stringify(parmas) + "，error异常：" + e.stack,
        clientIp: client_ip || ""
      });
      return system.getResult(null, "回调业务处理---error异常");
    }
  }

  async verifyCallBackParams(getParams) {//验证通联回调参数
    if (!getParams.trxcode) {
      return "回调trxcode参数为空";
    }
    if (getParams.trxcode != "VSP501" && getParams.trxcode != "VSP511") {
      return "回调trxcode值错误";
    }
    if (!getParams.trxstatus || getParams.trxstatus != "0000") {
      return "回调trxstatus信息为空或不等于0000";
    }
    if (!getParams.cusorderid) {
      return "回调商户订单号cusorderid参数为空";
    }
    return "";
  }
}
module.exports = utilsTlBankSve;
