var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const crypto = require("crypto");
//商标查询操作
class UtilsAppSve extends AppServiceBase {
  constructor() {
    super();
    this.appDao = system.getObject("db.dbapp.appDao");
  }
  async getAppOssInfo(pobj) {
    var uapp_id = Number(pobj.appInfo.uapp_id || 0);
    var sql = "SELECT uapp_id,access_key_id,access_key_secret,file_url FROM `p_app_oss` WHERE is_enabled=1 and uapp_id in(:uapp_id)";
    var paramWhere = { uapp_id: [uapp_id, 22] };
    var list = await this.appDao.customQuery(sql, paramWhere);
    if (!list) {
      return system.getResult(null, "oss info to data is empty ！");
    }
    var ossIndex = list.findIndex(f => f.uapp_id == uapp_id);
    if (ossIndex < 0) {
      ossIndex = list.findIndex(f => f.uapp_id == 22);
    }
    if (ossIndex < 0) {
      return system.getResult(null, "oss info to data is empty ！ ！ ！");
    }
    var ossItem = list[ossIndex];

    var bucket = pobj.actionBody.bucket || "gsb-zc";//oss 桶(即文件目录)
    var end = new Date().getTime() + 36000000;//10小时－毫秒
    var expiration = new Date(end).toISOString()
    var policyText = {
      "expiration": expiration,
      "conditions": [
        ["content-length-range", 0, 1048576000],
        ["starts-with", "$key", "zc"]
      ]
    };
    var b = new Buffer(JSON.stringify(policyText));
    var policyBase64 = b.toString('base64');
    var signature = crypto.createHmac('sha1', ossItem.access_key_secret).update(policyBase64).digest().toString('base64'); //base64

    var data = {
      OSSAccessKeyId: ossItem.access_key_id,
      policy: policyBase64,
      Signature: signature,
      Bucket: bucket,
      success_action_status: 201,
      url: ossItem.file_url
    };
    return system.getResultSuccess(data);
  }

  async getAppInfo(pobj) {
    var uapp_id = pobj.uappId || "";
    var app = await this.appDao.findOne({app_code:uapp_id});
    if(app) {
        return system.getResultSuccess(app);
    }
    if(!app) {
        return system.getResult(null, "渠道码错误")
    }
  }
}
module.exports = UtilsAppSve;
