var system = require("../../../system");
const AppServiceBase = require("../../app.base");
const NodeRSA = require('node-rsa');

class utilsTlBankSve extends AppServiceBase {
  constructor() {
    super();
    this.logCtl = system.getObject("service.common.oplogSve");
    this.apppaliparamDao = system.getObject("db.dbapp.apppaliparamDao");

  }
  //-------------------------------------------钉钉h5支付-----------------开始

  /**
   * 唤起钉钉h5支付信息---只供简单应用
   * @param {*} pobj 
   * @param {*} actionBody {total_fee:总额，单位为分，order_num:订单号，body_desc:标题描述}
   */
  async getH5AliDingPayInfo(pobj, actionBody) {
    var payParam = await this.apppaliparamDao.getItemByUAppId(pobj.appInfo.uapp_id);
    if (!payParam) {
      return { status: -310, msg: "应用没有对应的支付凭证" };
    }
    var parameters = {
      service: "mobile.securitypay.pay",
      partner: payParam.partner,
      _input_charset: "UTF-8",
      notify_url: payParam.notify_url,
      app_id: pobj.appInfo.uapp_id.toString(),//可为空
      out_trade_no: actionBody.order_num + "-" + pobj.appInfo.uapp_id.toString() + "-" + actionBody.product_id.toString(),
      subject: actionBody.body_desc,
      body: actionBody.body_desc,
      payment_type: "1",
      seller_id: payParam.seller_id,
      total_fee: actionBody.total_fee.toString(),
      it_b_pay: "2d",
      sign_type: "RSA"
    };
    // let signParam = "a=123";
    let signParam = await this.getVerifyParams(parameters);
    var signStr = await this.getCreateAliSignStr(pobj, signParam, payParam.privatekey, "sha1");
    // var signStr = await this.getSign(pobj,payParam.privatekey, parameters);
    signParam = signParam + "&sign=\"" + encodeURIComponent(signStr) + "\"&sign_type=\"" + parameters.sign_type + "\"";
    return system.getResultSuccess(signParam);
  }


  async getCreateAliSignStr(pobj, signParam, privateKey, algorith) {
    privateKey = "-----BEGIN PRIVATE KEY-----" + privateKey + "-----END PRIVATE KEY-----";
    const key = new NodeRSA();
    key.setOptions({ b: 1024, signingScheme: algorith });
    key.importKey(privateKey, 'pkcs8-private');//导入密钥并设定格式
    // const publicDer = key.exportKey('pkcs8-public');
    let buffer = Buffer.from(signParam);
    let signature = key.sign(buffer).toString('base64');
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
      op: "center-app/app/base/service/impl/utilsSve/utilsAlibankSve.js/getCreateAliSignStr",
      content: "参数：" + signParam + "返回结果signStr：" + signature,
      optitle: "获取钉钉支付签名信息返回",
    });
    return signature;
  }
  async getVerifyParams(params) {
    var sPara = [];
    if (!params) return null;
    for (var key in params) {
      if ((!params[key]) || key == "sign" || key == "sign_type") {
        continue;
      };
      sPara.push([key, "\"" + params[key] + "\""]);
      // if (key === "subject" || key === "body") {
      //   sPara.push([key, "\"" + encodeURIComponent(params[key]) + "\""]);
      // } else {
      //   sPara.push([key, "\"" + params[key] + "\""]);
      // }
    }
    sPara = sPara.sort();
    var prestr = '';
    for (var i2 = 0; i2 < sPara.length; i2++) {
      var obj = sPara[i2];
      if (i2 == sPara.length - 1) {
        prestr = prestr + obj[0] + '=' + obj[1] + '';
      } else {
        prestr = prestr + obj[0] + '=' + obj[1] + '&';
      }
    }
    return prestr;
  }

  async verifyAliPayReturnSign(actionBody) {
    if (!actionBody.out_trade_no) {
      return { status: -305, msg: "out_trade_no param can not be empty" };
    }
    var outTradeInfo = actionBody.out_trade_no.split('-');
    if (outTradeInfo.length < 2) {
      return { status: -307, msg: "out_trade_no into is error" };
    }
    var pobj = { appInfo: { uapp_id: outTradeInfo[1] } };
    var getSignStrResult = await this.getSortSignStr(actionBody);
    if (getSignStrResult.status != 0) {
      return getSignStrResult;
    }
    var payParam = await this.apppaliparamDao.getItemByUAppId(outTradeInfo[1]);
    if (!payParam) {
      return { status: -310, msg: "应用没有对应的支付凭证,verifyPayReturnSign" };
    }
    var verifyResult = await this.getVerifyPaySignStr(pobj, getSignStrResult.data, actionBody.sign, payParam.ali_publickey, "buffer", "base64", "sha1")
    if (verifyResult) {
      return system.getResultSuccess({
        orderNo: outTradeInfo[0],
        uappId: Number(outTradeInfo[1]),
        productId: outTradeInfo.length == 3 ? Number(outTradeInfo[2]) : 0
      });
    }
    return system.getResult(null, "验签失败，verifyPayReturnSign");
  }

  async getVerifyPaySignStr(pobj, signParamStr, verifySignStr, publicKey, sourceEncoding, signatureEncoding, algorith) {
    publicKey = "-----BEGIN PUBLIC KEY-----" + publicKey + "-----END PUBLIC KEY-----";
    const key = new NodeRSA();
    key.setOptions({ b: 1024, signingScheme: algorith });
    key.importKey(publicKey, 'pkcs8-public-pem');//导入密钥并设定格式
    // const publicDer = key.exportKey('pkcs8-private');
    let signature = key.verify(Buffer.from(signParamStr), verifySignStr, sourceEncoding, signatureEncoding);
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
      op: "center-app/app/base/service/impl/utilsSve/utilsAlibankSve.js/getVerifyPaySignStr",
      content: "参数：" + signParamStr + "验证签名结果signStr：" + signature,
      optitle: "获取钉钉支付返回签名验证",
    });
    return signature;

  }

  //-------------------------------------------钉钉h5支付-----------------结束

}
module.exports = utilsTlBankSve;
