const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class ProductService extends ServiceBase {
  constructor() {
    super("dbproduct", ServiceBase.getDaoName(ProductService));
    this.productpriceDao = system.getObject("db.dbproduct.productpriceDao");
  }
  /**
   * 通过产品类别编码路径获取产品列表
   * @param {*} actionBody pathCode 为类别编码路径，一级类下产品列表 sbfu，二级类下产品列表sbfu/sbzc
   * @param {*} appInfo 应用信息
   */
  async getProductList(actionBody, appInfo) {
    var sql = "select * from v_product where uapp_id=" + appInfo.uapp_id + " and path_code like '" + actionBody.pathCode + "%'";
    if(actionBody.productName){
      sql = "select * from v_product where uapp_id=" + appInfo.uapp_id + " and item_name like '" + actionBody.productName + "%'";
    }
    var list = await this.customQuery(sql);
    return system.getResultSuccess(list);
  }
  /**
   * 通过渠道产品编码获取产品详情
   * @param {*} actionBody channelItemCode 渠道产品编码
   * @param {*} appInfo 应用信息
   */
  async getProductDetail(actionBody, appInfo) {
    var item = await this.dao.getItemByChannelItemCode(actionBody.channelItemCode, appInfo.uapp_id);
    if (!item) {
      return system.getResult(null, "product item is data empty ！");
    }
    if (item.is_enabled != 1) {
      return system.getResult(null, "product to item is Disable ！");
    }
    var pList = await this.productpriceDao.model.findAll({
      where: { product_id: item.id },
      attributes: ["id", "pay_code", "price", "supply_price", "service_charge", "public_expense", "is_default", "is_show", "price_type", "price_type_name",
        "channel_profit_rate", "sort", "price_desc", "min_qty", "max_qty", "service_code"
      ],
      order: [ [ "price", 'ASC' ] ],
      raw: true
    });
    if (!pList || pList.length == 0) {
      return system.getResult(null, "product to price is data empty ！");
    }
    item.price_list = pList;
    return system.getResultSuccess(item);
  }
  /**
   * 获取产品接口信息
   * @param {*} actionBody productId产品id
   */
  async getProductInterface(pobj, actionBody) {
    var sql = "select * from v_op_interface where is_enabled=1 and uapp_id=" + pobj.appInfo.uapp_id + " and product_id=" + actionBody.product_id;
    var list = await this.customQuery(sql);
    return system.getResultSuccess(list);
  }
  /**
   * 获取应用接口信息
   * @param {*} actionBody 
   */
  async getAppInterface(pobj, actionBody) {
    var sql = "select * from v_op_interface where is_enabled=1 and product_id is null and uapp_id=" + pobj.appInfo.uapp_id;
    var list = await this.customQuery(sql);
    return system.getResultSuccess(list);
  }

  async getaliicProduce(actionBody) {
    var producesql = "";
    if (actionBody.regType == "ali.companyreg") {
      var area = actionBody.area || "";
      producesql = "SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_name LIKE '%" + actionBody.city
        + "%' AND pc.price_desc LIKE '%" + area
        + "%' and pc.additions_desc LIKE '%" + actionBody.companyCategory + "%' ;"
    } else {
      producesql = "SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_name LIKE '%" + actionBody.park
        + "%' AND pc.price_desc LIKE '%" + actionBody.productType + "%' ;"
    }
    var produceinfo = await this.customQuery(producesql);
    if (produceinfo) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
    }
    return system.getResultSuccess(actionBody);
  }

  async getaliicpProduce(actionBody) {
    var producesql = "SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.price price FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_code LIKE '%" + actionBody.typeCode
      + "%' AND pc.price_desc='"+actionBody.province+"' ";
    var produceinfo = await this.customQuery(producesql);
    if (produceinfo) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.price = produceinfo[0].price;
    }
    return system.getResultSuccess(actionBody);
  }

  /**
   * 工商H5 产品询价
   * @param actionBody
   * @returns {Promise<{msg: *, data, status: number}>}
   */
  async getProductPrice(actionBody){
    let pathCode = actionBody.pathCode;
    let channelItemCode = actionBody.channelItemCode;
    const code1 = pathCode.split('/')[1];//一级产品码
    const code2 = pathCode.split('/')[2];//二级产品码
    let channel_item_code = code2;
    var producesql = `SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.price price FROM p_product pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE is_show = 1 AND pt.channel_item_code = '${channelItemCode}'`;
    switch (code1) {
      case 'sbfu':
        channel_item_code = channelItemCode;
        break;
      case 'zzxk':
        if(actionBody.province ){
          producesql += ` AND pc.price_desc LIKE '%${actionBody.province}%'`;
        }else{
          return system.getResultFail(null,'actionBody.province can not be empty!')
        }
        if(actionBody.time!= ''){
          const index = actionBody.time.indexOf('个');
          const time = actionBody.time.substring(0,index);
          producesql += ` AND pc.additions_desc  = '${time}'`;
        }else{
          return system.getResultFail(null,'actionBody.time can not be empty!')
        }
        break;
      case 'bqfu':
        if(actionBody.serviceType ){
          producesql += ` AND pc.price_desc LIKE '%${actionBody.serviceType}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        if(actionBody.time!= ''){
          const index = actionBody.time.indexOf('个');
          const time = actionBody.time.substring(0,index)
          producesql += ` AND pc.additions_desc = '${time}'`;
        }else{
          return system.getResultFail(null,'actionBody.time can not be empty!')
        }
        break;
      case 'gsfu':
        if(code2 != 'ysgszc'){
          if(actionBody.city && actionBody.serviceType ){
            let str = actionBody.city + actionBody.serviceType;
            producesql += ` AND pc.price_desc LIKE '%${str}%'`;
          }else{
            return system.getResultFail(null,'actionBody.serviceType can not be empty!')
          }
        }else{
          let str = actionBody.city;
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }
        if(actionBody.companyType != ''){
          producesql += ` AND pc.additions_desc LIKE '%${actionBody.companyType}%'`;
        }else{
          return system.getResultFail(null,'actionBody.companyType and actionBody.companyType can not be empty!')
        }
        break;
      case 'csfw':
        if(actionBody.city){
          let str = actionBody.city;
          if(code2 == 'gsdz' || code2 == 'sksq'){
            str += actionBody.serviceType;
          }
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        if(code2 == 'sksq'){
          producesql += ` AND pc.additions_desc = '${actionBody.companyType}'`
        }
        break;
      default:
        producesql +=  ` AND pt.channel_item_code = '${code2}'`;
        break;
    }
    var produceinfo = await this.customQuery(producesql);
    if (produceinfo) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.price = produceinfo[0].price;
    }
    return system.getResultSuccess(actionBody);
  }

  /**
   * 获取最低价
   * @returns {Promise<void>}
   */
  async getMinPrice(pobj){
    let data ={};
    if(!pobj.actionBody.product_id){
      return system.getResultFail(-1,'product_id is empty');
    }
    let sql = `select min(price) price from p_product_price where product_id = ${pobj.actionBody.product_id}`;
    let result = await this.customQuery(sql);
    if(result){
      data = result[0];
    }
    return system.getResultSuccess(data);
  }

  /**
   * 获取推荐产品列表
   * @param pobj
   * @returns {Promise<void>}
   */
  async getProductRecommend(actionBody,appInfo){
    const type = actionBody.type;
    let sql=``;
    let paramsWhere ={};
    if(type ==1 ){
      sql = `select DISTINCT(recommend_code) from p_company_recommend where company_name = :companyName`;
      paramsWhere['companyName'] = actionBody.companyName;
    }
    if(type ==2 ){
      sql = `select DISTINCT(recommend_code) from p_company_recommend where company_name = :companyName and product_code = :productCode`;
      paramsWhere['companyName'] = actionBody.companyName;
      paramsWhere['productCode'] = actionBody.productCode;
    }
    if(type ==3 ){
      sql = `select DISTINCT(recommend_code) from p_product_recommend where product_code = :productCode`;
      paramsWhere['productCode'] = actionBody.productCode;
    }
    let result = await this.customQuery(sql,paramsWhere);
    if(result.length==0){
      return system.getResultFail(-1,'暂无配置数据')
    }
    let codes = [];
    result.forEach(item =>{
      if(item.recommend_code){
        codes.push(item.recommend_code)
      }
    })
    paramsWhere ={};
    let productSql = `select * from v_product where channel_item_code in (:codes) and uapp_id = :uapp_id`
    paramsWhere['uapp_id'] = appInfo.uapp_id;
    let rtn={};
    if(codes.length>0){
      paramsWhere['codes'] = codes;
      rtn = await this.customQuery(productSql,paramsWhere);
    }
    return system.getResult(rtn);
  }
}
module.exports = ProductService;
