const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("producttype", {
    uapp_id: DataTypes.INTEGER, //应用id
    p_id: DataTypes.INTEGER, //父id
    type_code: DataTypes.STRING(64),
    type_name: DataTypes.STRING(64),
    channel_type_code: DataTypes.STRING(64),
    channel_type_name: DataTypes.STRING(64),
    type_pic: DataTypes.STRING(512),
    type_desc: DataTypes.STRING(1024), //描述
    type_icon: DataTypes.STRING(512),
    is_enabled: { //状态 0禁用 1启用
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_product_type',
      validate: {

      },
      indexes: [

      ]
    });
}
