const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("productprice", {
    product_id: DataTypes.INTEGER, //产品id
    pay_code: DataTypes.STRING(50), //支付编码
    price: DataTypes.DOUBLE, //产品价格   
    supply_price: DataTypes.DOUBLE, //供货价格 
    service_charge: DataTypes.DOUBLE, //服务费
    public_expense: DataTypes.DOUBLE, //官费
    channel_profit_rate: DataTypes.INTEGER, //渠道利润分成比例（百分比，主要分：产品价格-供货价格）
    is_default: {//是否默认
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    is_show: { //是否显示
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    price_type: { //类型mj:每件,mc:每次,mt:每天,my:每月,mn:每年,qj:区间
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.price_type),
      set: function (val) {
        this.setDataValue("price_type", val);
        this.setDataValue("price_type_name", uiconfig.config.pdict.price_type[val]);
      },
    },
    price_type_name: DataTypes.STRING(10), //定价类型名称
    sort: DataTypes.INTEGER,
    price_desc: DataTypes.STRING(255), //价格描述
    service_code: DataTypes.STRING(255),
    min_qty: DataTypes.INTEGER, //最小数量
    max_qty: DataTypes.INTEGER, //最大数量

  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_product_price',
      validate: {

      },
      indexes: [

      ]
    });
}
