const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("product", {
    uapp_id: DataTypes.INTEGER, //应用id
    path_code: DataTypes.STRING(512), //产品类型编码路径，如：1/2
    path_name: DataTypes.STRING(512), //产品类型名称路径，如：商标服务/商标注册
    item_code: DataTypes.STRING(100), //产品编码
    item_name: DataTypes.STRING(100), //产品名称
    pic_url: DataTypes.STRING(500), //产品图片地址
    icon_url: DataTypes.STRING(500), //产品icon图片地址
    desc_url: DataTypes.STRING(500), //产品详情图片地址
    product_short_desc: DataTypes.STRING(200), //简介
    product_desc: DataTypes.STRING(1024), //产品描述列表
    channel_item_code: DataTypes.STRING(100), 
    channel_item_name: DataTypes.STRING(100), 
    service_business_code: DataTypes.STRING(100),
    service_business_name: DataTypes.STRING(100),
    pay_after_jump_h5url: DataTypes.STRING(500),
    pay_after_jump_pcurl: DataTypes.STRING(500),
    is_enabled: { //状态 0禁用 1启用
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    sort: DataTypes.INTEGER, //排序
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_product',
      validate: {

      },
      indexes: [

      ]
    });
}
