const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("interfaceinfo", {
    interface_url: DataTypes.STRING(255),
    method_name: DataTypes.STRING(100),
    params: DataTypes.STRING(1024),
    interface_type_name: DataTypes.STRING(255),
    interface_type: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.interface_type),
      set: function (val) {
        this.setDataValue("interface_type", val);
        this.setDataValue("interface_type_name", uiconfig.config.pdict.interface_type[val]);
      },
    },
    op_type_name: DataTypes.STRING(255),
    op_type: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.op_type),
      set: function (val) {
        this.setDataValue("op_type", val);
        this.setDataValue("op_type_name", uiconfig.config.pdict.op_type[val]);
      },
    },
    desc: DataTypes.STRING(1024), //描述
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_interface_info',
      validate: {

      },
      indexes: [

      ]
    });
}
