const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("apppaliparam", {
    uapp_id: DataTypes.STRING(50),
    corp_id: DataTypes.STRING(64),
    agent_id: DataTypes.STRING(64),
    appkey: DataTypes.STRING(64),
    appsecret: DataTypes.STRING(255),
    seller_id: DataTypes.STRING(64),
    partner: DataTypes.STRING(64),
    partner_md5: DataTypes.STRING(64),
    publickey: DataTypes.STRING(1024),
    ali_publickey: DataTypes.STRING(1024),
    privatekey: DataTypes.STRING(2048),
    pay_url: DataTypes.STRING(500), //支付地址  
    notify_url: DataTypes.STRING(500),
    is_enabled: { //状态 0禁用 1启用
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    notes: DataTypes.STRING(255),
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_app_aliparam',
      validate: {

      },
      indexes: [

      ]
    });
}
