const system = require("../../../system");
const Dao = require("../../dao.base");
class AppDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppDao));
  }
  async getItemByHosts(app_hosts) {
    return this.model.findOne({
      where: {
        app_hosts: app_hosts
      },
      raw: true
    });
  }
  async getItemByAppKey(uapp_key, uapp_secret) {
    return this.model.findOne({
      where: {
        uapp_key: uapp_key,
        uapp_secret: uapp_secret
      },
      raw: true
    });
  }
  async getItemByUAppId(uapp_id) {
    return this.model.findOne({
      where: {
        uapp_id: uapp_id
      },
      raw: true
    });
  }
  async getItemByAppKey(appKey) {
    return this.model.findOne({
      where: {
        uapp_key: appKey
      },
      raw: true
    });
  }
}
module.exports = AppDao;
