const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByUserNameCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = val.actionBody;
    var appInfo = val.appInfo;
    var channelUserId = actionBody.channelUserId ? actionBody.channelUserId : actionBody.userName;
    var uUserName = actionBody.userName ? actionBody.userName : actionBody.channelUserId;
    var uPassword = actionBody.userName ? actionBody.userName : actionBody.channelUserId;//uPassword    
    var mobile = actionBody.mobile ? actionBody.mobile : actionBody.channelUserId;

    var userInfo = await this.appuserDao.getItemByChannelUserId(channelUserId, appInfo.uapp_id);
    if (userInfo) {
      if (userInfo.is_enabled != 1) {
        return system.getResult(null, "user to item is Disable ！");
      }
      userInfo.userpin = actionBody.userpin;
      return system.getResultSuccess(userInfo);
    }
    var uUserInfo = await this.opPlatformUtils.register(uUserName, uPassword, mobile,
      appInfo.uapp_key, appInfo.uapp_secret);
    if (uUserInfo.status != 0 && uUserInfo.status != 2000) {
      return uUserInfo;
    }//值为2000为已经存在此用户，注册失败
    var params = {
      uapp_id: appInfo.uapp_id,
      channel_userid: actionBody.channelUserId || "",
      channel_username: uUserName || "",
      channel_nickname: actionBody.nickName || "",
      mobile: mobile || "",
      org_name: actionBody.orgName || "",
      org_path: actionBody.orgPath || "",
      open_id: actionBody.openId || "",
      head_url: actionBody.headUrl || "",
      is_enabled: 1,
      email: actionBody.email || "",
      is_admin: actionBody.isAdmin || 0,
      is_super: actionBody.isSuper || 0,
      last_login_time: new Date()
    };
    userInfo = await this.appuserDao.create(params);
    userInfo.userpin = actionBody.userpin;
    return system.getResultSuccess(userInfo);
  }
}
module.exports = AppUserPinByUserNameCache;
