const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByLoginVcodeCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = val.actionBody;
    var appInfo = val.appInfo;
    var uUserInfo = await this.opPlatformUtils.loginByVCode(actionBody.mobile, actionBody.vcode, actionBody.password,
      appInfo.uapp_key, appInfo.uapp_secret);
    if (uUserInfo.status != 0) {
      return uUserInfo;
    }//2030验证码校验不成功 或 注册失败

    var userInfo = await this.appuserDao.getItemByChannelUserId(actionBody.mobile, appInfo.uapp_id);
    if (userInfo) {
      if (userInfo.is_enabled != 1) {
        return system.getResult(null, "user to item is Disable ！");
      }
      if (actionBody.reqType == "reg") {
        return system.getResultFail(system.existUserRegFail, "已经存在此用户，注册失败");
      }
      userInfo.userpin = actionBody.userpin;
      return system.getResultSuccess(userInfo);
    }
    var params = {
      uapp_id: appInfo.uapp_id,
      channel_userid: actionBody.mobile || "",
      channel_username: actionBody.mobile || "",
      channel_nickname: actionBody.nickName || "",
      mobile: actionBody.mobile || "",
      org_name: actionBody.orgName || "",
      org_path: actionBody.orgPath || "",
      is_enabled: 1,
      email: actionBody.email || "",
      last_login_time: new Date()
    };
    userInfo = await this.appuserDao.create(params);
    userInfo.userpin = actionBody.userpin;
    return system.getResultSuccess(userInfo);
  }
}
module.exports = AppUserPinByLoginVcodeCache;
