const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByLoginPwdCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = val.actionBody;
    var appInfo = val.appInfo;
    var uUserName = actionBody.userName;//uUserName
    var uPassword = actionBody.password;//uPassword    
    var uUserInfo = await this.opPlatformUtils.login(uUserName, uPassword,
      appInfo.uapp_key, appInfo.uapp_secret);
    if (uUserInfo.status != 0) {
      return uUserInfo;
    }//值为2010为用户名或密码错误
    var userInfo = await this.appuserDao.getItemByChannelUserId(actionBody.userName, appInfo.uapp_id);
    if (!userInfo) {
      return system.getResult(null, "user to item is empty ！");
    }
    if (userInfo.is_enabled != 1) {
      return system.getResult(null, "user to item is Disable ！");
    }
    userInfo.userpin = actionBody.userpin;
    return system.getResultSuccess(userInfo);
  }
}
module.exports = AppUserPinByLoginPwdCache;
