var APIBase = require("../../api.base");
var system = require("../../../system");
class PaymentAPI extends APIBase {
    constructor() {
        super();
        this.utilstlbankSve = system.getObject("service.utilsSve.utilstlbankSve");
    }
    /**
         * 接口跳转-POST请求
         * action_process  执行的流程
         * action_type     执行的类型
         * action_body     执行的参数
         */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getH5PayUrl":
                opResult = await this.utilstlbankSve.getH5PayUrl(pobj, pobj.actionBody);
                break;
            case "getQrCode":
            case "getOrderQrCode":
                opResult = await this.utilstlbankSve.getQrCode(pobj.appInfo.uapp_id, pobj.actionBody.order_num, pobj.actionBody.total_fee, pobj.actionBody.body_desc, pobj.actionBody.op_type);
                break;
            case "queryOrder":
            case "queryOrderStatus": this.logCtl = system.getObject("service.common.oplogSve");
                opResult = await this.utilstlbankSve.queryOrder(pobj.appInfo.uapp_id, pobj.actionBody.trxid);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
    //支付成功后通知
    async receiveCallBackNotify(pobj, query, req) {
        var rtn = await this.utilstlbankSve.receiveCallBackNotify(pobj.actionBody.parmas, pobj.client_ip);
        return rtn;
    }
    async getPayParamInfo(pobj, qobj, req) {
        return await this.utilstlbankSve.getPayParamItem(pobj.uappId);
    }

    async getAppInfo(pobj, qobj, req) {
        return await this.utilstlbankSve.getAppItem(pobj.uappId);
    }

    async getAppInfoByAppKey(pobj,qobj,req){
        return await this.utilstlbankSve.getAppItemByAppkey(pobj.appKey)
    }
}
module.exports = PaymentAPI;