var APIBase = require("../../api.base");
var system = require("../../../system");
class AccessAuthAPI extends APIBase {
    constructor() {
        super();
        this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
        this.appmobilemsgSve = system.getObject("service.dbapp.appmobilemsgSve");
        this.utilsappSve = system.getObject("service.utilsSve.utilsappSve");
    }

    async getOssInfo(pobj, qobj, req) {//获取oss信息
        var result = await this.utilsappSve.getAppOssInfo(pobj);
        return result;
    }

    async getTokenByHosts(pobj, qobj, req) {
        var result = await this.opPlatformUtils.getReqTokenByHosts(pobj);
        return result;
    }

    async getVerifyCodeByMoblie(pobj, qobj, req) {//获取默认模板的手机验证码
        if (!pobj.actionBody.mobile) {
            return system.getResult(null, "actionBody.mobile can not be empty ！");
        }
        var itemResult = await this.appmobilemsgSve.getItemByUappId(pobj);
        var result = system.getResult(null, "get msg error");
        if (itemResult.status != 0) {
            result = await this.opPlatformUtils.fetchDefaultVCode(pobj.actionBody.mobile, pobj.appInfo.uapp_key, pobj.appInfo.uapp_secret);
            console.log("--------------fetchDefaultVCode result start")
            console.log(result);
            console.log("--------------fetchDefaultVCode result end")
            return result;
        }
        var param = {
            mobile: pobj.actionBody.mobile,
            tmplCode: itemResult.data.tmpl_code,
            signName: itemResult.data.sign_name,
            accessKeyId: itemResult.data.access_key_id,
            accessKeySecret: itemResult.data.access_key_secret
        }
        result = await this.opPlatformUtils.fetchOtherVCode(param, pobj.appInfo.uapp_key, pobj.appInfo.uapp_secret);
        return result;
    }

    async login(pobj, qobj, req) {//通过账户和密码登录
        if (!pobj.actionBody.userName) {
            return system.getResult(null, "actionBody.userName can not be empty ！");
        }
        if (!pobj.actionBody.password) {
            return system.getResult(null, "actionBody.password can not be empty ！");
        }
        var result = await this.opPlatformUtils.getReqUserPinByLgoin(pobj);
        return result;
    }
    async getLoginByUserName(pobj, qobj, req) {//通过账户获取用户信息----------------------------actionBody.channelUserId
        if (!pobj.actionBody.channelUserId) {
            return system.getResult(null, "actionBody.channelUserId can not be empty ！");
        }
        var result = await this.opPlatformUtils.getLoginByUserName(pobj);
        return result;
    }

    async loginByVerifyCode(pobj, qobj, req) {//通过短信登录或注册信息
        if (!pobj.actionBody.mobile) {
            return system.getResult(null, "actionBody.mobile can not be empty ！");
        }
        if (!pobj.actionBody.vcode) {
            return system.getResult(null, "actionBody.vcode can not be empty ！");
        }
        var result = await this.opPlatformUtils.getReqUserPinByLgoinVcode(pobj);
        return result;
    }
    async modiPasswordByMobile(pobj, qobj, req) {//通过手机验证码修改用户密码
        var actionBody = pobj.actionBody;
        if (!actionBody.mobile) {
            return system.getResult(null, "actionBody.mobile can not be empty ！");
        }
        if (!actionBody.vcode) {
            return system.getResult(null, "actionBody.vcode can not be empty ！");
        }
        if (!actionBody.newPwd) {
            return system.getResult(null, "actionBody.newPwd can not be empty ！");
        }
        var result = await this.opPlatformUtils.putUserPwdByMobile(pobj, actionBody);
        return result;
    }
    async getLoginInfo(pobj, qobj, req) {//通过userpin获取用户信息
        var actionBody = pobj.actionBody;
        if (!actionBody.userpin) {
            return system.getResult(null, "actionBody.userpin can not be empty ！");
        }
        var result = await this.opPlatformUtils.getUserLoginInfo(pobj, actionBody);
        return result;
    }
    async logout(pobj, qobj, req) {
        var result = await this.opPlatformUtils.logout(pobj);
        return result;
    }
    async getAppInfo(pobj, qobj, req) {
        var result = await this.utilsappSve.getAppInfo(pobj);
        return result;
    }


}
module.exports = AccessAuthAPI;