const crypto = require('crypto');
const sha256 = require('sha256');
const system = require("../system");
var settings = require("../../config/settings");
const AppServiceBase = require("../service/app.base");

class baiduClient extends AppServiceBase {
    constructor() {
        super();
        this.pushlogSve = system.getObject("service.common.pushlogSve");
        this.execClient = system.getObject("util.execClient");
        this.baiduClientParams = settings.baiduClientParams();
    }

    //2020 1027 laolan 调用百度网关
    async baiduPost(path, actionBody) {
        console.log('baiduPost-actionBody++', actionBody)
        let domain = this.baiduClientParams.domain;
        let url = domain + path;
        let version = "bce-auth-v1";
        let accessKey = this.baiduClientParams.accessKey;
        let secretKey = this.baiduClientParams.secretKey;
        let timestamp = new Date().toISOString()
        let site = timestamp.lastIndexOf(".");
        timestamp = timestamp.substring(0, site) + "Z"
        let signedHeaders = "host";
        let extime = 1800;
        let canonicalHeaders = "host:" + this.baiduClientParams.host;
        //中间结果1：规范化请求和前缀字符串
        let canonicalRequest = null
        let pathParams = path.split("?");
        if (pathParams && pathParams.length > 1) {
            canonicalRequest = "POST" + "\n" + pathParams[0] + "\n" + pathParams[1] + "\n" + canonicalHeaders;
        } else {
            canonicalRequest = "POST" + "\n" + path + "\n" + "\n" + canonicalHeaders;
        }
        // let canonicalRequest = "POST" + "\n" + path + "\n" + "\n" + canonicalHeaders;
        console.log('canonicalRequest+++++++', canonicalRequest)
        //authStringPrefix(前缀字符串，由除sk字段外的签名信息生成)
        let authStringPrefix = version + "/" + accessKey + "/" + timestamp + "/" + extime;
        //中间结果2：派生签名密钥 signingKey
        let signingKey = crypto.createHmac('sha256', secretKey)
            .update(authStringPrefix)
            .digest('hex');
        //中间结果3：签名摘要 signature
        let signature = crypto.createHmac('sha256', signingKey)
            .update(canonicalRequest)
            .digest('hex');
        //最终结果：认证字符串 authorization
        let authorization = authStringPrefix + "/" + signedHeaders + "/" + signature;
        let baiduObj = {
            authorization: authorization,
            data: actionBody
        }
        let rtn = await this.execClient.execBaiduPost(baiduObj, url);
        this.execClientNew.execLogs(`baiduClient-baiduPost-result:url=${url}`, baiduObj, "center-channel-opBaiduClientPost", rtn, null);
        if (!rtn || !rtn.stdout) {
            this.execClientNew.execLogs(`baiduClient-opBaiduClientPost-result:url=${url}`, actionBody, "center-channel-opBaiduClientPost", null, rtn);
            return system.getResult(null, rtn);
        }
        let result = JSON.parse(rtn.stdout);
        return result;
    }

    //百度接口 2020-10-27 laolan
    async baiduReqbyget(obj, cbk) {
        var path = obj.path;
        var reqbody = obj.reqbody;
        try {
            var res = await this.baiduPost(path, reqbody, {
                timeout: 10000, // default 3000 ms 修改3000为10000，原因ConfirmIcpIntention BizIds 超过5条会超时
                formatAction: true, // default true, format the action to Action
                formatParams: true, // default true, format the parameter name to first letter upper case
                method: 'POST', // set the http method, default is GET
                headers: {
                    host: this.baiduClientParams.host
                }, // set the http request headers
            });
            return system.getResultSuccess(res);
        } catch (e) {
            await this.disposePushResultFail(obj, e, "badiu->baiduReqbyget->catchError", this.pushlogFailType.FAILLOG);
            return system.getResultFail(-200, "出现异常，error：" + e.stack);
        }
    }
}

module.exports = baiduClient;
// var task = new baiduClient();
// console.log(task.baiduClientParams,"11111111111111111");