var WEBBase = require("../../web.base");
var system = require("../../../system");
class FgbusinesschanceAPI extends WEBBase {
    constructor() {
        super();
        this.utilsFgbusinesschancSve = system.getObject("service.utilsSve.utilsFgbusinesschanceSve");
        this.toolSve = system.getObject("service.trademark.toolSve");
    }
    /**
      * 复购商机 相关接口 跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "create"://创建复购商机
                opResult = await this.utilsFgbusinesschancSve.create(pobj, pobj.actionBody);
                break;
            case "createOrderRefundFq":
                opResult = await this.utilsFgbusinesschancSve.createOrderRefundFq(pobj, pobj.actionBody);
                break;
            case "createOnlineProductClassificiationFq":
                opResult = await this.utilsFgbusinesschancSve.createOnlineProductClassificiationFq(pobj, pobj.actionBody);
                break;
            case "createOrderInfoAndPayFq":
                opResult = await this.utilsFgbusinesschancSve.createOrderInfoAndPayFq(pobj, pobj.actionBody);
                break;
            // ------ 对蜂擎页面  -------
            case "getCompanyInfo": // 获取工商信息
                opResult = await this.toolSve.getEntregistryByCompanyName(pobj.actionBody, req);
                break;
            case "getCompanyLabel":// 三十秒认知客户
                opResult = await this.utilsFgbusinesschancSve.getCompanyLabel(pobj, pobj.actionBody);
                break
            case "getRecommendProducts": // 获取推荐产品列表
                opResult = await this.utilsFgbusinesschancSve.getRecommendProducts(pobj, pobj.actionBody);
                break;
            case "getTalkContent": // 获取营销话术
                opResult = await this.utilsFgbusinesschancSve.getTalkContent(pobj, pobj.actionBody);
                break;
            case "getOldOrder": // 获取已购产品
                opResult = await this.utilsFgbusinesschancSve.getOldOrder(pobj, pobj.actionBody);
                break;
            case "updateStatus"://更新商机跟进状态
                opResult = await this.utilsFgbusinesschancSve.updateStatus(pobj, pobj.actionBody);
                break;
            case "getMoreInfoUrl":// 更多客户信息链接地址
                opResult = await this.utilsFgbusinesschancSve.getMoreInfoUrl(pobj, pobj.actionBody);
                break
            case "getConsultingRecord":// 根据咨询公司名称获取咨询记录
                opResult = await this.utilsFgbusinesschancSve.getConsultingRecord(pobj, pobj.actionBody);
                break
            case "addStatusRemarks": // 产品跟进状态备注
                opResult = await this.utilsFgbusinesschancSve.addStatusRemarks(pobj, pobj.actionBody);
                break
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = FgbusinesschanceAPI;
