let APIBase = require("../../api.base");
let system = require("../../../system");
let settings = require("../../../../config/settings");

/**
 * 增值服务订单服务
 */
class Order extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    //icp状态变更
    async notify(pobj, obj, req) {
        if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
            return system.getResultFailByErrMsg("未知应用或应用未启用");
        }
        if (!pobj.orderNo) {
            return system.getResultFailByErrMsg("orderNo不能为空");
        }
        pobj.isDirectBuy = pobj.isDirectBuy || 0;//1是直购并付款，0是下单未付款
        pobj.status = 1;
        if (pobj.isDirectBuy == 1 && !pobj.phone) {
            return system.getResultFailByErrMsg("直接下单phone不能为空");
        }
        if (pobj.isDirectBuy == 1 && !pobj.consultType) {
            return system.getResultFailByErrMsg("直接下单consultType不能为空");
        } else {
            if (pobj.consultType == "ICP") {
                pobj.consultType = "5";
            }
            if (pobj.consultType == "EDI") {
                pobj.consultType = "7";
            }
        }
        pobj.area = settings.areaConfig[pobj.area];
        // pobj.action_type = "icpOrderStatus";
        if (!pobj.area) {
            return system.getResultFailByErrMsg("area参数错误");
        }
        if (pobj.isDirectBuy == 0) {//下单未付款订单直接创建需求信息
            pobj.type = pobj.consultType;
            pobj.mobile = pobj.phone;
            pobj.intentionBizId = pobj.orderNo;//⽤户咨询编号
            pobj.description = "未付款的订单过去的需求，咨询编号为未付款订单号";//⽤户需求信息
        }
        let param = {
            requestId: req.requestId || "",
            // requestUrl: "/icp/order/notify",
            requestjson: JSON.stringify(pobj),//请求地址
            // pushUrl: "/action/intentionapi/springBoard",//调用地址
            // pushActionType: "icpOrderStatus",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
            version: 1,
            interface_path: pobj.isDirectBuy == 1 ? "service.receiveSve.icpOrderSve" : "service.receiveSve.icpNeedSve",//接口路径
            interface_method: pobj.isDirectBuy == 1 ? "submitOrder" : "submitNeed",//接口方法
        }
        await this.gatewaypushlogSve.create(param);
        return system.getResultSuccess(null);
    }

    async close(pobj, obj, req) {
        if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
            return system.getResultFailByErrMsg("未知应用或应用未启用");
        }
        if (!pobj.orderNo) {
            return system.getResultFailByErrMsg("orderNo不能为空");
        }
        pobj.channelOrderNo = pobj.orderNo;
        // pobj.action_type = "icpOrderClose";
        let param = {
            requestId: req.requestId || "",
            // requestUrl: "/icp/order/close",
            requestjson: JSON.stringify(pobj),//请求地址
            // pushUrl: "/action/intentionapi/springBoard",//调用地址
            // pushActionType: "icpOrderClose",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
            version: 1,
            interface_path: "service.receiveSve.icpOrderSve",//接口路径
            interface_method: "closeOrder",//接口方法
        }
        await this.gatewaypushlogSve.create(param);
        return system.getResultSuccess(null);
    }

}

module.exports = Order;