var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ProductAPI extends WEBBase {
    constructor() {
        super();
        this.utilsUcommuneSve = system.getObject("service.utilsSve.utilsUcommuneSve");
    }
    /**
      * 优客工厂 
      * 接口跳转-POST请求
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getUserInfo":// 根据优客token获取用户信息，生成userPin返回前端 actionBody
                opResult = await this.utilsUcommuneSve.getUserInfo(req, pobj, pobj.actionBody);
                break;
            case "orderTotalSum":// addOrder后进入支付页面获取支付金额 
                opResult = await this.utilsUcommuneSve.orderTotalSum(pobj, pobj.actionBody);
                break;
            case "orderConfirm":// 点击确认支付后返回拼接字符串
                opResult = await this.utilsUcommuneSve.orderConfirm(pobj, pobj.actionBody);
                break;
            case "orderCheck":// 调起支付框后获取支付结果
                opResult = await this.utilsUcommuneSve.orderCheck(pobj, pobj.actionBody);
                break;
            case "ucommuneGetOrderList":// 优客调取订单列表用
                opResult = await this.utilsUcommuneSve.ucommuneGetOrderList(pobj, pobj.actionBody);
                break;
            case "ucommuneGetOrderDetail":// 优客调取订单详情 目前未使用
                opResult = await this.utilsUcommuneSve.ucommuneGetOrderDetail(pobj, pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = ProductAPI;