var APIBase = require("../../api.base");
var system = require("../../../system");
class AliyunApi extends APIBase {
    constructor() {
        super();
        this.aliclient = system.getObject("util.aliyunClient");
    }

    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionProcess, pobj.actionType, pobj.actionBody, req);
        return result;
    }
    async opActionProcess(pobj, action_process, action_type, action_body, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "queryAvailabelNumbers":// 获取可用外呼号码列表
                opResult = await this.aliclient.queryAvailabelNumbers(pobj.actionBody.bizType);
                break;
            case "startBackToBackCall":// 发起双呼接口
                opResult = await this.aliclient.startBackToBackCall(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = AliyunApi;