#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time     : 2020/5/26 17:57
# @Author   : hj
# @File     :assigned_opportunity.py
# @software :PyCharm
"""已分配商机"""
from flask import request
from service.select_es_result import hx
import json
from dao.business_job_dao import hxDao
from service.company_basic import CompanyBase
business_job_info = hxDao()
company_base = CompanyBase()

def selectAssigned(pagesize,currentpage):
    assigned_opportunity = business_job_info.jobSelect(pagesize,currentpage)
    assigned_opportunity_total = business_job_info.jobTotal()
    total_nu = 0
    for row in assigned_opportunity_total:
        total_nu = row['total']
    company_name_list = []
    company_dict_list = []
    for row in assigned_opportunity:
        company_name = row['company_name']
        company_name_list.append(company_name)
    for company_name in company_name_list:
        company_dict = company_base.companyinfo(company_name)
        company_dict['logo'] = hx.select_url(company_name)
        company_dict_list.append(company_dict)
    return company_dict_list,total_nu

def assigned_opportunity(server):
    @server.route('/gsb/api/assignedOpportunity', methods=['POST'])
    def assigned_opportunity_main():
        if request.method == 'POST':
            assigned_oportunity = request.json
            pagesize = assigned_oportunity.get('pagesize')
            currentpage = assigned_oportunity.get('currentpage')
            # try:
            company_dict_list,total_nu = selectAssigned(pagesize,currentpage)
            return {"status": 200, "msg": "成功", "data": company_dict_list,"total":total_nu}
            # except:
            #     return {"status": 404, "msg": "失败", "data": []}