#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020/3/27 9:10
# @Author  : huangjing
# @File    : Image_status.py
# @Software: PyCharm

from dao.Image_status_dao import Image_status_Dao
from db.mod_db import DataBase
from flask import request,jsonify
from common import re_companyName

"""任务表"""

# 根据传入公司名称获取专利报告链接及状态
def GetReportInfoFromSql(companyName):
    # 检索企业画像信息
    print(companyName, "===========获取公司名称查询专利信息")
    # 查询数据库
    report_dict = {"report_status": "生成中", "report_url": ""}
    try:
        # 执行SQL语句
        Image_status = Image_status_Dao()
        Allreport_rules = Image_status.select_sql_1(companyName)
        print(Allreport_rules,"===Allreport_rules")
        for row in Allreport_rules:
            # 获取所有数据
            url_result = row["report_url"]
            if url_result:
                report_dict["report_status"] = "已完成"
                report_dict["report_url"] = url_result
            print(report_dict)
    except Exception as error:
        print('Image_status:error',error)
    # finally:
    #     DataInfo = DataBase()
    #     DataInfo.close()
    return report_dict

# 根据传入公司名称获取画像状态
def GetImageInfoFromSql(companyName):
    # 检索企业画像信息
    print(companyName, "===========获取公司名称查询画像信息")
    # 查询数据库
    status = "生成中"
    try:
        # 执行SQL语句
        Image_status = Image_status_Dao()
        Allproduct_rules = Image_status.select_sql_2(companyName)
        print(Allproduct_rules)
        for row in Allproduct_rules:
            # 获取所有数据
            image_result = row['company_lable']
            if image_result:
                status = "已完成"
            print(status)
    except:
        # return ("没有查询到该公司画像信息")
        return status
    # finally:
    #     DataInfo = DataBase()
    #     DataInfo.close()
    return status

# 将获取的信息写入数据库
def WritePRtoSql(companyName, currdate, hx_status, report_dict):  # 把推荐结果写进数据库
    print(report_dict, "将公司信息写入数据库")
    report_status = report_dict["report_status"]
    report_url = report_dict["report_url"]
    # json写入数据库
    try:
        Image_status = Image_status_Dao()
        Image_status.insertData(companyName, currdate, hx_status, report_status, report_url)
    except Exception as e:
        print(e)
        DataInfo = DataBase()
        DataInfo.roll_back()
    # 关闭数据库连接
    # DataInfo = DataBase()
    # DataInfo.close()
    return "查询信息已写入数据库"

# 根据传入公司名称查询画像状态表,返回任务信息
def GetImageStatusFromSql(companyName, pageSize, pageNum):
    # 检索企业画像状态表
    print(companyName, "===========获取公司名称查询画像状态信息")
    # 查询数据库
    search_list = []
    num_start = (pageNum - 1) * pageSize
    print(num_start, "================num_start")

    try:
        Image_status = Image_status_Dao()
        Allsearch_result = Image_status.select_sql_3(companyName, num_start, pageSize)
        print(Allsearch_result,"=====Allsearch_result")
        r = 0
        for row in Allsearch_result:
            # 获取所有数据
            image_status = row['image_status']
            report_status = row['report_status']
            if image_status == "已完成" and report_status == "已完成":
                status = "已完成"
            else:
                status = "生成中"
            r += 1
            search_dict = {
                "companyName": row['companyName'],
                "submit_time": row['submit_time'],
                "status": status,
                "patent_link": row['report_url']}
            search_list.append(search_dict)
    except Exception as error:
        print('Image_status_error',error)
    # finally:
    #     DataInfo = DataBase()
    #     DataInfo.close()
    return search_list

def work_total(companyName):
    # 检索企业画像状态表
    print(companyName, "===========获取公司名称查询总数量")
    # 查询数据库
    total = ""
    # 执行SQL语句
    # print(sql,"===================sql查询")
    # 获取所有配置列表
    Image_status = Image_status_Dao()
    Allsearch_result = Image_status.select_sql_4(companyName)
    # print(Allsearch_result,"===Allsearch_result")
    for row in Allsearch_result:
        total = row['COUNT(*)']
        print(total, "=======")
    # DataInfo = DataBase()
    # DataInfo.close()
    return total

def imageInfo(server):
    @server.route('/gsb/api/ImageStatusSearch', methods=['POST'])
    def ImageStatusSearch():
        print("接口调用--------查询画像状态")
        result = {}
        try:
            if request.method == 'POST':
                requestdata = request.json
                print(requestdata)
                # 当前页数
                pageNum = requestdata.get('pageNum')
                # 是否插入表
                insert_status = requestdata.get('insert_status')
                print(insert_status, type(insert_status), "==========================insert")
                # 每页展示的条数
                pageSize = requestdata.get('pageSize')
                # 公司名称
                companyName = requestdata.get('companyName')
                companyName = re_companyName.strQ2B(companyName)
                # 提交日期
                currdate = requestdata.get('currdate')
                # 根据公司名称查询画像标签库、画像状态
                hx_status = GetImageInfoFromSql(companyName)
                report_dict = GetReportInfoFromSql(companyName)
                if insert_status == 1:
                    WritePRtoSql(companyName, currdate, hx_status, report_dict)
                    result["status"] = 200
                    result["msg"] = "操作成功"
                    result["result_data"] = GetImageStatusFromSql(companyName, pageSize, pageNum)
                    result["total"] = work_total(companyName)
                else:
                    result["status"] = 200
                    result["msg"] = "操作成功"
                    result["result_data"] = GetImageStatusFromSql(companyName, pageSize, pageNum)
                    result["total"] = work_total(companyName)
        except:
            result["status"] = 404
            result["msg"] = "操作失败"
            result["result_data"] = "-"
            result["total"] = "-"
        return jsonify(result)

# server.run(host='127.0.0.1', port=8100, debug=True)
