const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("orderinfofq", {
    sourceName          :DataTypes.STRING(128),//  来源名称（source_name）
    serviceOrderNo      :DataTypes.STRING(128),//  服务商订单号（页面中列表中显示该单号）-云服(no)
    channelServiceNo    :DataTypes.STRING(128),//  渠道服务单号
    channelOrderNo      :DataTypes.STRING(128),//  渠道订单号（页面中列表中显示该单号）（idempotent_no）
    channelNeedNo       :DataTypes.STRING(128), // 渠道需求号（页面中列表中显示该需求号）
    needNo              :DataTypes.STRING(128), //需求号（need_no）
    payTime             :DataTypes.DATE,//  支付时间(first_pay_time)
    quantity            :DataTypes.INTEGER,//  项目订单数量（即服务项目的倍数，默认值为1）
    orderStatusName     :DataTypes.STRING(50),//订单状态名称
    orderStatus         :DataTypes.INTEGER,// 订单状态: 1: 待付款, 2: 已付款, 4: 服务中, 8: 已完成, 16: 已退款, 32: 已作废
    totalSum            :DataTypes.DECIMAL(12, 2),//  订单总额(产品价格×优惠费率×订单件数)                                                                                                                                    
    payTotalSum         :DataTypes.DECIMAL(12, 2),//  订单付款总额
    refundSum           :DataTypes.DECIMAL(12, 2),//  退款金额
    refundTime          :DataTypes.DATE, //2020/6/17 lin新增 退款时间 
    notes               :DataTypes.STRING,//  备注
    isSolution          :DataTypes.INTEGER,// 是否有方案，0无，1有
    handleStatus        :DataTypes.INTEGER, // 处理状态，0否，1是
    source_code         :DataTypes.STRING
  }, {
      paranoid: true,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updated_at: true,// 2020 0618 lin修改 
      //freezeTableName: true,
      // define the table's name
      tableName: 'c_order_info_fq',
      validate: {

      },
      indexes: [      
      ]
    });
}
