const system = require("../../../system");
const Dao = require("../../dao.base");
const {Op} = require("sequelize");

class NeedinfoDao extends Dao {
    constructor() {
        super(Dao.getModelName(NeedinfoDao));
    }

    async getItemByNeedNo(needNo) {
        return await this.model.findOne({
            where: {
                needNo: needNo
            },
            attributes: [
                "id",
                "uapp_id",
                "needNo",
                "channelNeedNo",
                "channelUserId",
                "followManUserId",
                "followManMobile",
                "city",
                "province",
                "publishContent",
                "publishName",
                "publishMobile",
                "notes",
                "followContent",
                "disposeNotes",
                "status",
                "statusName",
                "typeCode",
                "typeName",
                "channelTypeCode",
                "channelTypeName",
                "publisherOnlyCode",
                "followManName",
                "followManOnlyCode",
                "created_at",
                "appName",
                "serviceProductId"],
            raw: true
        });
    }

    async getItemByChannelNeedNo(channelNeedNo) {
        return await this.model.findOne({
            where: {
                channelNeedNo: channelNeedNo
            },
            attributes: [
                "id",
                "uapp_id",
                "needNo",
                "channelNeedNo",
                "channelUserId",
                "followManUserId",
                "followManMobile",
                "city",
                "province",
                "publishContent",
                "publishName",
                "publishMobile",
                "notes",
                "followContent",
                "disposeNotes",
                "status",
                "typeCode",
                "typeName",
                "channelTypeCode",
                "channelTypeName",
                "publisherOnlyCode",
                "followManName",
                "followManOnlyCode",
                "created_at",
                "appName",
                "serviceProductId"],
            raw: true
        });
    }

    /**
     * 根据ids 获取需求
     * @param ids
     * @returns {Promise<void>}
     */
    async getNeedsByIds(ids) {
        let needs = await this.findAll({
            where: {
                channelNeedNo: {
                    [Op.in]: ids
                }
            }
        })
        return needs;
    }

    /**
     * 批量更新
     * @param needs
     * @returns {Promise<Array<Model>|*>}
     */
    async bulkUpdate(needs) {
        let result = await this.bulkCreate(needs, {
            fields: ["id", "status", "statusName"],
            updateOnDuplicate: ["status", "statusName"]
        });
        return result;
    }

    /**
     * 批量更新
     * @param needs
     * @returns {Promise<Array<Model>|*>}
     */
    async bulkUpdateStatus(status, statusName, ids) {
        let result = await this.updateByWhere({status: status, statusName: statusName}, {
            where: {
                channelNeedNo: {
                    [Op.in]: ids
                }
            }
        });
        return result;
    }
}

module.exports = NeedinfoDao;
