const system = require("../../../system");
const Dao = require("../../dao.base");
class OrderContactsDao extends Dao {
  constructor() {
    super(Dao.getModelName(OrderContactsDao));
  }
  async getItemByOrderNo(orderNo, uapp_id) {
    return await this.model.findOne({
      where: {
        sourceOrderNo: orderNo
      },
      attributes: [
        "id",
        "contactName",
        "mobile",
        "tel",
        "email",
        "fax"],
      raw: true
    });
  }
}
module.exports = OrderContactsDao;
