//工商注册
var APIBase = require("../../api.base");
var system = require("../../../system");
class RegAPI extends APIBase {
    constructor() {
        super();
        this.regCenterOrderSve = system.getObject("service.qcutils.regCenterOrderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        console.log("pobj",pobj)
        var opResult = null;
        switch (action_type) {
            case "regReceiveSolutionPayInfo"://接收reg方案状态及支付信息(方案支付后创建订单时调用)
                opResult = await this.regCenterOrderSve.regReceiveSolutionPayInfo(pobj);
                break;
            case "selectNeedInfo"://查询需求信息
                opResult = await this.regCenterOrderSve.selectNeedInfo(pobj);
                break;
            case "regOrderClose"://关闭订单
                opResult = await this.regCenterOrderSve.regOrderClose(pobj);
                break;

            case "regFeedbackSubmit"://接收需求反馈 百度reg 2.2
                opResult = await this.regCenterOrderSve.regFeedbackSubmit(pobj);
                break;
            case "getItemByChannelSolutionNo"://渠道方案号获取需求详情
                opResult = await this.regCenterOrderSve.getItemByChannelSolutionNo(pobj, pobj.actionBody, req);
                break;
            case "regOrderStatus"://接收订单状态推送 百度reg 2.3
                opResult = await this.regCenterOrderSve.regOrderStatus(pobj);
                break;
            case "addRegSalesmanInfo"://添加业务员信息，用于直接下单的reg订单
                opResult = await this.regCenterOrderSve.addRegSalesmanInfo(pobj);
                break;
            case "submitRegNeed"://提交需求 2.1
                opResult = await this.regCenterOrderSve.submitRegNeed(pobj, pobj.actionBody, req);
                break;
            case "getSolutionByChannelOrderNo"://根据渠道订单获取方案信息
                opResult = await this.regCenterOrderSve.getSolutionByChannelOrderNo(pobj, pobj.actionBody, req);
                break;
            case "regSubmitSolution"://方案提交
                opResult = await this.regCenterOrderSve.regSubmitSolution(pobj);
                break;
            case "updateSolution"://方案更新
                opResult = await this.regCenterOrderSve.updateSolution(pobj);
                break;

            case "regWriteCommunicationLog"://新增沟通记录
                opResult = await this.regCenterOrderSve.regWriteCommunicationLog(pobj);
                break;
            case "regQueryExpertCommunicationLogs"://获取沟通记录
                opResult = await this.regCenterOrderSve.regQueryExpertCommunicationLogs(pobj);
                break;
            case "regUpdateOrderStatus"://提交交付信息/修改订单状态
                opResult = await this.regCenterOrderSve.regUpdateOrderStatus(pobj);
                break;
            case "regNeedClose"://前端关闭reg需求及方案
                opResult = await this.regCenterOrderSve.regNeedClose(pobj);
                break;
            case "saveReginfo"://保存渠道方案及url
                opResult = await this.regCenterOrderSve.saveReginfo(pobj);
                break;

            case "getRegInfoByChannelNeedNo"://获取需求方案列表
                opResult = await this.regCenterOrderSve.reqCenterOrderApi(pobj);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = RegAPI;

// let tmptest=new RegAPI()
// tmptest.springBoard({"actionType":"regUpdateOrderStatus","actionBody":{"orderNo":"OT44202105311300t5eQ","consultType":"GSREG","status":703,"deliverContent":{"applicationFormUrl":"https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_452164696435020820221110550208.pdf","baseInfo":{},"companyInfo":{"companyName":"北京半山半水文化咨询有限公司","spareName":[],"serviceArea":""}}},"appInfo":{"id":21,"app_hosts":"alitm.qifu.gongsibao.com","app_code":"alitm","app_name":"阿里云商标服务","uapp_id":"36","uapp_key":"202003231118","uapp_secret":"7cbb846246874167b5c7e01cd0016c99","contact_name":"宋毅","contact_mobile":"15010929366","contact_email":null,"desc":"阿里云商标服务","is_enabled":1,"is_sign":0,"pay_type":"00","delivery_type":"10","created_at":"2020-03-23T11:24:10.000Z","updated_at":"2020-03-23T11:24:11.000Z","version":0},"actionProcess":"alitm","userInfo":{"id":15890,"uapp_id":36,"channel_userid":"jytest6","channel_username":"jytest6","channel_nickname":"","open_id":"","head_url":"","mobile":"jytest6","org_name":"","org_path":"","email":"","is_admin":0,"is_super":0,"is_enabled":1,"userpin":"1466e1f9cdf1463f908ddeb53b035768"}})