const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
class InvoiceService extends ServiceBase {
  constructor() {
    super();
  }
  async processDics(params) {
    var rs = await this.callms("invoice", "processDics", params);
    return rs;
  }

  async invoiceApply(params) {
    var rs = await this.callms("invoice", "invoiceApply", params);
    return rs;
  }

  async invoicePage(params) {
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);
    var rs = await this.callms("invoice", "deliverInvoicePage", params);
    if (rs.data && rs.data.rows) {
      for (let item of rs.data.rows) {
        item.invoice_amount = system.f2y(item.invoice_amount);
      }
    }
    return rs;
  }

  async handleStatus(params) {
    var rs = await this.callms("invoice", "handleStatus", params);
    return rs;
  }

  async invoice(params) {
    var rs = await this.callms("invoice", "invoice", params);
    return rs;
  }
}
module.exports = InvoiceService;
