const system = require("../../../system");
const ServiceBase = require("../../svems.base");
var settings = require("../../../../config/settings");

class DeliverService extends ServiceBase {
  constructor() {
    super();
  }

  async login(params) {
    var rs = await this.callms("common", "deliverLogin", params);
    return rs;
  }

  async all(params) {
    var rs = await this.callms("common", "deliverAll", {});
    await this.doPercent(rs.data);
    return rs;
  }

  async page(params) {
    var rs = await this.callms("common", "deliverPage", params);
    await this.doPercent(rs.data.rows);
    return rs;
  }

  async info(params) {
    var rs = await this.callms("common", "deliverInfo", params);
    await this.doPercent([rs.data]);
    return rs;
  }

  async mayByIds(ids) {
    var rs = await this.callms("common", "deliverUserMap", {ids: ids});
    await this.doPercent([rs.data]);
    return rs;
  }

  async save(params) {
    params.invoiceDivide = system.y2f(params.invoiceDivide);
    params.businessmenDivide = system.y2f(params.businessmenDivide);
    var rs = await this.callms("common", "deliverSave", params);
    await this.doPercent([rs.data]);
    return rs;
  }

  async del(params) {
    return await this.callms("common", "deliverDelete", params);
  }

  async deliverUserPage(params) {
    return await this.callms("common", "deliverUserPage", params);
  }
  async deliverUserById(params) {
    return await this.callms("common", "deliverUserById", params);
  }
  async deliverUserSave(params) {
    let rs = await this.callms("common", "deliverUserSave", params);
    if(!params.id && rs.status === 0) {
      this.synSave(rs.data.id, params.password);
    }
    return rs;
  } 

  async synSave(id, password) {
  }

  async allOrg(params) {
    return await this.callms("common", "allOrg", params);
  }
  async orgTree(params) {
    return await this.callms("common", "orgTree", params);
  }
  async orgById(params) {
    return await this.callms("common", "orgById", params);
  }
  async orgSave(params) {
    return await this.callms("common", "orgSave", params);
  }

  async doPercent(rows) {
    if(!rows) {
      return;
    }
    for(var row of rows) {
      if(!row) {
        continue;
      }
      row.invoiceDivide = system.f2y(row.invoiceDivide);
      row.businessmenDivide = system.f2y(row.businessmenDivide);
    }
  }
}
module.exports = DeliverService;