var system = require("../../../system")
const CtlBase = require("../../ctlms.base");

class ChannelCtl extends CtlBase {
  constructor() {
    super();
    this.orderSve = system.getObject("service.saas.orderSve");
  }

  // async microAdd(params, pobj2, req) {
  //   try {
  //     return await this.orderSve.microAdd(params);
  //   } catch (error) {
  //     return system.getResult(null, `系统错误 错误信息 ${error}`);
  //   }
  // }

  async platformInfo(params, pobj2, req) {
    try {
      return await this.orderSve.platformInfo(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params, pobj2, req) {
    try {
      return await this.orderSve.info(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params, pobj2, req) {
    try {
      return await this.orderSve.page(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async audit(params, pobj2, req) {
    if (params.audit_status != "20" && params.audit_status != "30") {
      return system.getResult(null, "审核状态错误");
    }
    try {
      return await this.orderSve.audit(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async deliver(params, pobj2, req) {
    try {
      return await this.orderSve.deliver(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = ChannelCtl;