var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class MerchantCtl extends CtlBase {
  constructor() {
    super();
    this.merchantSve = system.getObject("service.saas.merchantSve");
    this.merchantuserSve = system.getObject("service.uc.merchantuserSve");
  }

  async dics(params, pobj2, req) {
    try {
      return await this.merchantSve.dics(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async info(params, pobj2, req) {
    try {
      return await this.merchantSve.info(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async page(params, pobj2, req) {
    try {
      this.doTimeCondition(params, ["createBegin", "createEnd"]);
      return await this.merchantSve.page(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async signPage(params, pobj2, req) {
    try {
      params.is_sign = 1;
      this.doTimeCondition(params, ["createBegin", "createEnd"]);
      return await this.merchantSve.page(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async save(params, pobj2, req) {
    try {
      return await this.merchantSve.save(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  
  async sign(params, pobj2, req) {
    try {
      params.bm_reg_price = system.y2f(params.bm_reg_price || 0);
      params.invoice_service_rate = system.y2f(params.invoice_service_rate || 0);
      params.trans_service_rate = system.y2f(params.trans_service_rate || 0);
      return await this.merchantSve.sign(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async signInfo(params, pobj2, req) {
    try {
      return await this.merchantSve.signInfo(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async userInfo(params, pobj2, req) {
    try {
      let rs = await this.merchantuserSve.info(params);
      await this.merchantSve.setMerchant([rs.data]);
      return system.getResultSuccess(rs);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async userSave(params, pobj2, req) {
    try {
      return await this.merchantuserSve.save(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async userPage(params, pobj2, req) {
    try {
      let rs = await this.merchantuserSve.page(params);
      await this.merchantSve.setMerchant(rs.data.rows);
      return rs;
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 商户抬头信息列表
   * @param {*} pobj2 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async merchantTitleAddrPage (pobj1, pobj2, req){
    try {
      return this.merchantSve.merchantTitleAddrPage(pobj1);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误`);
    }
  }

  /**
   * query invoice title&addr information
   * @param {*} pobj1 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async queryInvoiceTitleAndAddr(pobj1, pobj2, req){
    try {
      return this.merchantSve.queryInvoiceTitleAndAddr(pobj1);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误`);
    }
  }

  /**
   * query invoice title&addr information
   * @param {*} pobj1 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async updateOrSaveTitleAndAddr(pobj1, pobj2, req){
    try {
      return this.merchantSve.updateOrSaveTitleAndAddr(pobj1);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误`);
    }
  }

}
module.exports = MerchantCtl;