<a name="menu" href="">返回主目录</a>

1. [获取token](#getToken)
1. [企业工商二要素验证](#twoElementsCheck)
1. [企业工商三要素验证](#threeElementsCheck)
1. [企业工商四要素验证](#fourElementsCheck)
1. [企业工商信息查询（简项）](#enterpriseSimple)
1. [企业工商信息查询（深度）](#enterpriseDeep)
1. [企业工商信息查询（SAAS）](#enterpriseSAAS)
1. [企业工商信息变更监控](#monitorGroupAdd)
1. [企业大中小微划型服务](#companyLevel)
1. [企业工商反洗钱查询](#getLaunderInfo)
1. [企业工商反洗钱变更监控](#monitorSaasInvAdd)
1. [企业多点关联查询](#multipleRelation)
1. [企业多维智能评分查询](#getIndexScoreOpe)
1. [企业深度画像-经营分析](#invoiceGetIndex)
1. [企业深度画像-交易分析](#enterpriseEcoPort_A)
1. [司法数据查询（模糊）](#enterpriseFuzzyQuery)
1. [司法数据查询（精准）](#enterpriseKeyword)
1. [地址标准化查询](#addressSearch)
1. [个人工商信息查询](#personSearch)
1. [手机号码在网时长](#mobileOnline)
1. [羊毛反欺诈查询](#antiFraudWool)
1. [金融服务](#financialOverdue)
1. [企业标签](#entLabel)
1. [企业开票信息查询](#invoiceInfo)
1. [企业开票信息核验](#invoiceCheck)
1. [通用响应代码](#GeneralCode)

## **<a name=""> 域名</a>**
##### URL
https://oapidev.gongsibao.com  测试

https://oapi.gongsibao.com     线上

## **<a name="getToken"> 获取token</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/platform/getToken]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
``` javascript
    {
        "accessKey":"111",
        "accessSecret":"222"
    }

```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhcHBJZCI6MSwiZXhwIjoxNjA3OTk4MTkwLCJpYXQiOjE2MDc5OTYzOTAsImNoYW5uZWxJZCI6MX0.GtlGqOriQb6vEOkBio_8sIjvjN3W-ajQV6woG7JJ8jY",
        "msg": "success"
    }

```

## **<a name=""> 获取token2</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/platform/getTokenByApp]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
``` javascript
    {
        "channelId":1,
        "appId":1,
        "accessKey": "111"
    }
```

#### 返回结果
```javascript
    {
        "status": 1,
        "data": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhcHBJZCI6MSwiZXhwIjoxNjA3OTk4MTkwLCJpYXQiOjE2MDc5OTYzOTAsImNoYW5uZWxJZCI6MX0.GtlGqOriQb6vEOkBio_8sIjvjN3W-ajQV6woG7JJ8jY",
        "msg": "success"
    }

```

## **<a name="twoElementsCheck"> 企业工商二要素验证</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/twoElementsCheck", // Y 请求地址
        "regNo":"91110531MA071J9L27",// Y 注册号/社会统一信用代码
        "entName":"清河县xx制品有限公司"// Y 企业名称
    }

```

#### 返回结果
```javascript
    {
        "msg":"查询成功",
        "code":"000",
         "data":{
             "entNameMatch":1, //1 匹配，0不匹配
             "regNoMatch":1 //1 匹配，0不匹配
         }
    }

```

## **<a name="threeElementsCheck"> 企业工商三要素验证</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/threeElementsCheck", // Y 请求地址
        "creditCode":"91110531MA071J9L27", // N 注册号/社会统一信用代码
        "entName":"清河县xx制品有限公司", // N 企业名称
        "realname":"赵x" // Y 法人姓名
    }

```

#### 返回结果
```javascript
    {
        "msg":"查询成功",
        "code":"000",
         "data":{
             "entNameMatch":1, // 1 匹配，0不匹配 -1 无法验证
             "regNoMatch":1, // 1 匹配，0不匹配 -1 无法验证
             "realnameMatch":1 // 1 匹配，0不匹配 -1 无法验证
         }
    }

```

## **<a name="fourElementsCheck"> 企业工商四要素验证</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/fourElementsCheck", // Y 请求地址
        "regNo":"91110531MA071J9L27", // Y 注册号/社会统一信用代码
        "entName":"清河县xx制品有限公司", // N 企业名称
        "idNo":"361502198111016871", // Y 企业法人身份证号码
        "realname":"赵x" // Y 法人姓名
    }

```

#### 返回结果
```javascript
    {
        "msg":"查询成功",
        "code":"000",
         "data":{
             "entNameMatch":1, // 1 匹配，0不匹配 -1 无法验证
             "idNoMatch":1, // 1 匹配，0不匹配 -1 无法验证
             "regNoMatch":1, // 1 匹配，0不匹配 -1 无法验证
             "realnameMatch":1 // 1 匹配，0不匹配 -1 无法验证
         }
    }

```

## **<a name="enterpriseSimple"> 企业工商信息查询（简项）</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/enterprise/simple", // Y 请求地址
        "regNo":"91110531MA071J9L27", // N 注册号/社会统一信用代码
        "entName":"清河县xx制品有限公司", // N 企业名称
        "creditCode":"361502198111016871", // N 统一信用代码
        "orgCode":"" // N 组织机构代码
    }

```

#### 返回结果
```javascript
    {
      "msg": "查询成功",
      "code": "000",
      "data": {
        "yearReportForInvs": [],
        "filiations": [
          {
            "brnregorg": "四川省成都市高新工商行政管理局",
            "brregno": "511101000237689",
            "brncreditcode": "911101005102146068",
            "brname": "xx科技有限责任公司成都分公司"
          }
        ],
        "yearReportAlterStocks": [],
        "yearReportSocSecs": [
          {
            "unpaidsocialinsso110": "",
            "unpaidsocialinsso210": "",
            "unpaidsocialinsso310": "",
            "unpaidsocialinsso410": "",
            "unpaidsocialinsso510": "",
            "totalwagesso110": "",
            "totalwagesso310": "",
            "totalwagesso210": "",
            "so410": "676",
            "so310": "676",
            "so210": "676",
            "so110": "676",
            "totalwagesso510": "",
            "totalwagesso410": "",
            "totalpaymentso210": "",
            "totalpaymentso310": "",
            "totalpaymentso110": "",
            "totalpaymentso410": "",
            "totalpaymentso510": "",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add",
            "so510": "676"
          }
        ],
        "yearReportWebSiteInfos": [
          {
            "websitname": "xx商城",
            "webtype": "网店",
            "domain": "www.mi.com",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add"
          }
        ],
        "yearReportSubCapitals": [
          {
            "inv": "xx",
            "lisubconam": "18623.099",
            "conform": "",
            "currency": "",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add",
            "condate": "2015-10-30"
          }
        ],
        "mortgagebasics": [],
        "mortgagepers": [],
        "yearReportAlters": [],
        "liquidations": [],
        "stockpawns": [
          {
            "stkpawnregno": "91110108551385082Q_0",
            "stkpawnczamt": "18623.099",
            "stkpawnczcerno": "",
            "stkpawnzqcerno": "91110108558521630L",
            "stkpawndate": "",
            "stkpawnstatus": "有效",
            "stkpawnczper": "xx",
            "stkpawnregdate": "2018-06-20",
            "stkpawnzqper": "xx通讯技术有限公司",
            "url": "b4a874046b4e85042ca17f9701371097"
          }
        ],
        "mortgagedebts": [],
        "mortgagepawns": [],
        "stockpawnrevs": [
          {
            "stkpawnres": "3",
            "stkpawndate": "",
            "url": "f98def1cdab226d31006e5d17762a530"
          }
        ],
        "yearReportForGuarantees": [],
        "stockpawnalts": [],
        "mortgageregs": [],
        "mortgagealts": [],
        "yearReportPaidUpCapitals": [
          {
            "inv": "xx",
            "liacconam": "18623.099",
            "conform": "",
            "currency": "",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add",
            "condate": "2015-10-30"
          }
        ],
        "shareholders": [
          {
            "country": "中国",
            "invtype": "自然人股东",
            "conform": "货币",
            "shaname": "xx",
            "fundedratio": "77.80%",
            "subconam": "143934.047800",
            "condate": "",
            "regcapcur": "人民币元"
          }
        ],
        "mortgagecans": [],
        "sharesfrosts": [],
        "exceptions": [],
        "yearReportBasics": [
          {
            "regno": "110108012660422",
            "entname": "xx科技有限责任公司",
            "postalcode": "100085",
            "ancheyear": "2017",
            "busst": "开业",
            "tel": "60606666-1000",
            "ancheid": "4b7e3eb18533b52faddb659ff364779f",
            "addr": "北京市海淀区清河中街68号华润五彩城购物中心二期13层",
            "creditno": "91110108551385082Q",
            "email": "chenchongwei@xiaomi.com",
            "anchedate": "2018-06-13"
          }
        ],
        "persons": [
          {
            "personamount": "6",
            "pername": "xx",
            "entname": "xx科技有限责任公司",
            "isFr": 1,
            "position": "董事长"
          }
        ],
        "alters": [
          {
            "altbe": "手机技术开发；手机生产、手机服务（限海淀区永捷北路2号二层经营）；从事互联网文化活动；出版物零售；出版物批发；销售第三类医疗器械；销售食品；零售药品。...",
            "altaf": "手机技术开发；手机生产、手机服务（限海淀区永捷北路2号二层经营）；从事互联网文化活动；出版物零售；出版物批发；销售第三类医疗器械；销售食品；...",
            "altitem": "经营范围",
            "altdate": "2018-05-09"
          },
        ],
        "basic": {
          "esdate": "2010-03-03",
          "creditcode": "91110108551385082Q",
          "dom": "北京市xx二期13层",
          "zsopscope": "技术开发；货物进出口、技术进出口、代理进出口；销售通讯设备、厨房用品、卫生用品（含个人护理用品）、日用杂货、化妆品、医疗器械I类、II类、避孕器具、玩具、体育用品、文化用品、服装鞋帽、钟表眼镜、针纺织品、家用电器、家具（不从事实体店铺经营）、花、草及观赏植物、不再分装的包装种子、照相器材、工艺品、礼品、计算机、软件及辅助设备、珠宝首饰、食用农产品、宠物食品、电子产品、摩托车、电动车、自行车及零部件、智能卡、五金交电（不从事实体店铺经营）、建筑材料（不从事实体店铺经营）；维修仪器仪表；维修办公设备；承办展览展示活动；会议服务；筹备、策划、组织大型庆典；设计、制作、代理、发布广告；摄影扩印服务；文艺演出票务代理、体育赛事票务代理、展览会票务代理、博览会票务代理；手机技术开发；手机生产、手机服务（限海淀区永捷北路2号二层经营）；从事互联网文化活动；出版物零售；出版物批发；销售第三类医疗器械；销售食品；零售药品；广播电视节目制作。（企业依法自主选择经营项目，开展经营活动；从事互联网文化活动、出版物批发、出版物零售、销售食品、广播电视节目制作、零售药品、销售第三类医疗器械以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）",
          "reccap": "5000.000000",
          "enttype": "有限责任公司...",
          "industryphyall": "m科学研究",
          "industryphyname": "科学研究",
          "opfrom": "2010-03-03",
          "industryphycode": "m",
          "enttypecode": "1130",
          "regorgdistrict": "北京市海淀区",
          "industryconame": "其他科技推广服务业",
          "entname": "xx科技...",
          "regorg": "北京市工商行政管理局海淀分局",
          "domdistrict": "110108",
          "tel": "01069630728",
          "revdate": "",
          "abuitem": "手机技术开发；手机生产、手机服务；（限海淀区永捷北路2号二层经营）从事互联网文化活动。",
          "email": "",
          "frname": "xx",
          "regno": "110108012660422",
          "entnameeng": "xx科技...",
          "oriregno": "",
          "ancheyear": "2015",
          "opto": "2030-03-02",
          "regcapcur": "人民币元",
          "empnum": "6",
          "industrycoall": "759其他科技推广服务业",
          "candate": "",
          "industrycocode": "759",
          "regcap": "185000.000000",
          "regorgcity": "北京市",
          "regorgprovince": "北京市",
          "entstatus": "在营（开业）",
          "entnameold": "北京xx...",
          "regorgcode": "110108",
          "apprdate": "2018-06-20"
        }
      }
    }
```

### 响应数据参数说明
``` javascript
    code string 6 响应代码
    msg string 50 响应代码说明
    data object 响应数据
     basic object 企业基本信息
     entname string 600 企业名称
     entnameold string 600 曾用名
     frname string 300 法定代表人/负责人/执行事务合伙人
     entnameeng string 600 企业英文名称
     creditcode string 300 统一信用代码
     regno string 100 注册号
     oriregno string 300 原注册号
     esdate string 100 成立日期
     opfrom string 100 经营期限自
     opto string 100 经营期限至
     regcap string 100 注册资本企业:万元 个体：不确定
     reccap string 100 实收资本
     regorg string 300 登记机关
     enttype string 300 企业类型
     entstatus string 100 经营状态
     regorgprovince string 100 所在省份
     regorgcity string 100 所在城市
     abuitem string 4000 许可经营项目
     ancheyear string 100 最后年检年度
     regorgdistrict string 100 所在区/县
     regcapcur string 100 注册资本币种
     email string 300 邮箱
     dom string 2000 住址
     tel string 100 联系人电话
     empnum string 100 员工人数
     revdate string 100 吊销日期
     candate string 100 注销日期
     apprdate string 100 核准日期
     domdistrict string 100 住所所在行政区划
     regorgcode string 100 注册地址行政编号
     enttypecode string 100 企业(机构)类型编码
     industryphycode string 100 行业门类代码
     industryphyname string 100 行业门类名称
     industryphyall string 100 行业门类代码及名称
     industrycocode string 100 国民经济行业代码
     industrycoall string 100 国民经济行业代码及名称
     industryconame string 100 国民经济代码名称
     zsopscope string 4000 经营业务范围
     persons array[object] 主要管理人员
     entname string 600 企业名称
     pername string 300 人员姓名
     position string 100 职位
     isFr string 2 是否法人 1.是
    0.否
     personamount string 100 人员总数量
     shareholders array[object] 股东及出资信息
     shaname string 600 股东名称
     invtype string 100 股东类型
     conform string 300 出资方式
     condate string 100 出资日期
     subconam string 100 认缴出资额（万元）
     regcapcur string 100 认缴出资币种
     fundedratio string 300 出资比例
     country string 300 国别
     alters array[object] 变更信息
     altitem string 300 变更事项
     altbe string 4000 变更前内容
     altaf string 4000 变更后内容
     altdate string 100 变更日期
     filiations array[object] 分支机构
     brname string 600 分支机构名称
     brncreditcode string 300 分支机构统一社会信用代码
     brregno string 300 分支机构企业注册号
     brnregorg string 300 分支机构登记机关
     exceptions array[object] 企业异常名录
     entname string 100 企业名称
     shxydm string 100 统一社会信用代码
     regno string 100 注册号
     indate string 100 列入日期
     inreason string 500 列入原因
     outdate string 100 移出日期
     outreason string 500 退出异常名录原因
     yrregorg string 100 列入机关名称
     ycregorg string 100 移出机关名称
     liquidations array[object] 清算信息
     debttranee string 1000 债务承接人
     claimtranee string 600 债权承接人
     ligprincipal string 600 清算负责人
     liqmen string 600 清算组成员
     addr string 2000 地址
     tel string 100 联系电话
     ligst string 300 清算完结情况
     ligenddate string 100 清算完结日期
     mortgagealts array[object] 动产抵押-变更信息
     mabregno string 300 登记编号
     mabaltdate string 100 变更日期
     mabaltdetails string 4000 变更内容
     mortgagebasics array[object] 动产抵押-基本信息
     mabregno string 300 登记编号
     mabregdate string 100 登记日期
     mabregorg string 300 登记机关
     mabguaramt string 2000 被担保债权数额
     mabstatus string 100 状态
     mabgsdate string 100 公示日期
     mortgagecans array[object] 动产抵押-注销信息
     mabregno string 300 登记编号
     mabcandate string 100 注销日期
     mabcanres string 4000 注销原因
     mortgagedebts array[object] 动产抵押-被担保主债权信
    息
     mabregno string 300 登记编号
     mabdebttype string 300 种类
     mabdebtrange string 4000 担保范围
     mabdebtrmk string 2000 备注
     mabdebtamt string 300 数额
     debtsdate string 100 履行债务开始日期
     debtedate string 100 履行债务结束日期
     mortgagepawns array[object] 动产抵押-抵押物信息
     mabregno string 300 登记编号
     mabpawnname string 600 名称
     mabpawnowner string 2000 所有权或使用权归属
     mabpawndetails string 4000 数量、质量、状况、所在地
    等情况
     mabpawnrmk string 2000 备注
     mortgagepers array[object] 动产抵押-抵押人信息
     mabregno string 300 登记编号
     mabpername string 600 抵押权人名称
     mabpercertype string 600 抵押权人证照/证件类型
     mabpercerno string 300 抵押权人证照/证件号码
     mabperdom string 600 所在地
     mortgageregs array[object] 动产抵押-登记信息
     mabregno string 300 登记编号
     mabregdate string 100 登记日期
     mabregorg string 300 登记机关
     mabguaramt string 2000 被担保债权数额
     nodenum string 100 省份代码
     mabguarrange string 4000 担保范围
     mabguartype string 2000 被担保债券种类
     debtsdate string 100 履行债务开始日期
     debtedate string 100 履行债务结束日期
     status string 100 状态
     sharesfrosts array[object] 股权冻结信息
     froam string 100 冻结金额（万元）
     froauth string 300 冻结机关
     frofrom string 100 冻结起始日期
     frodocno string 4000 冻结文号
     thawauth string 300 解冻机关
     thawdocno string 100 解冻文号
     thawdate string 100 解冻日期
     thawcomment string 4000 解冻说明
     froto string 100 冻结截至日期
     stockpawns array[object] 股权出质信息（新）
     stkpawnregno string 300 登记编号
     stkpawnczper string 300 出质人
     stkpawnczcerno string 600 出质人证件/证件号
     stkpawnczamt string 600 出质股权数额
     stkpawnzqper string 300 质权人姓名
     stkpawnzqcerno string 600 质权人证件/证件号
     stkpawnregdate string 100 质权出质设立登记日期
     stkpawnstatus string 600 状态
     stkpawndate string 100 公示日期
     url string 4000 关联内容
     stockpawnalts array[object] 股权出质信息（新）-变更
    信息
     stkpawnbgnr string 4000 变更内容
     stkpawnbgrq string 100 变更日期
     url string 4000 关联内容
     stockpawnrevs array[object] 股权出质信息（新）-注销
    信息
     url string 4000 关联内容
     stkpawndate string 100 注销日期
     stkpawnres string 4000 注销原因
     yearReportAlters array[object] 年报-修改信息
     ancheid string 300 年报ID
     altitem string 200 修改事项
     altaf string 200 修改后
     altbe string 200 修改前
     altdate string 100 修改日期
     yearReportAlterStock
     s
    array[object] 年报-股权变更信息
     altdate string 100 股权变更日期
     ancheid string 100 年报ID
     inv string 100 股东名称
     transamaft string 100 转让后股权比例
     transampr string 100 转让前股权比例
     yearReportBasics array[object] 年报-企业年报基本信息
     ancheid string 300 年报ID
     addr string 300 地址
     anchedate string 100 年报日期
     ancheyear string 100 年报年份
     busst string 100 经营状态
     creditno string 100 统一信用代码
     email string 100 电子邮箱
     entname string 100 企业名称
     postalcode string 100 邮政编码
     regno string 100 注册号
     tel string 100 电话
     yearReportForGuarant
     ees
    array[object] 年报-企业对外提供保证担
    保信息
     ancheid string 300 年报ID
     gatype string 100 保证的方式
     guarapperiod string 100 保证的期间
     more string 100 债权人
     mortgagor string 100 债务人
     pefperform string 100 履行债务的期限自
     pefperto string 100 履行债务的期限至
     priclasecam string 100 主债权数额
     priclaseckind string 100 主债权种类
     rage string 200 保证担保的范围
     yearReportForInvs array[object] 年报-企业对外投资信息
     ancheid string 300 年报ID
     creditno string 100 统一信用代码
     entname string 100 企业名称
     regno string 100 注册号
     yearReportPaidUpCapi
     tals array[object] 年报-企业实缴出资信息
     ancheid string 300 年报ID
     condate string 100 实缴出资日期
     conform string 100 出资方式
     currency string 100 币种
     inv string 100 股东/发起人
     liacconam string 100 累计实缴额（万元）
     yearReportSocSecs array[object] 年报-社会保险信息
     ancheid string 300 年报ID
     so110 string 100 城镇职工基本养老保险参保
    人数
     so210 string 100 失业保险参保人数
     so310 string 100 职工基本医疗保险参保人数
     so410 string 100 工伤保险参保人数
     so510 string 100 生育保险参保人数
     totalpaymentso110 string 100 参加城镇职工基本养老保险
    本期实际缴费金额
     totalpaymentso210 string 100 参加失业保险本期实际缴费
    金额
     totalpaymentso310 string 100 参加职工基本医疗保险本期
    实际缴费金额
     totalpaymentso410 string 100 参加工伤保险本期实际缴费
    金额
     totalpaymentso510 string 100 参加生育保险本期实际缴费
    金额
     totalwagesso110 string 200 单位参加城镇职工基本养老
    保险缴费基数
     totalwagesso210 string 200 单位参加失业保险缴费基数
     totalwagesso310 string 200 单位参加职工基本医疗保险
    缴费基数
     totalwagesso410 string 200 单位参加工伤保险缴费基数
     totalwagesso510 string 200 单位参加生育保险缴费基数
     unpaidsocialinsso1
     10 string 100 单位参加城镇职工基本养老
    保险累计欠缴金额
     unpaidsocialinsso2
     10 string 100 单位参加失业保险累计欠缴
    金额
     unpaidsocialinsso3
     10 string 100 单位参加职工基本医疗保险
    累计欠缴金额
     unpaidsocialinsso4
     10 string 100 参加工伤保险累计欠缴金额
     unpaidsocialinsso5
     10 string 100 单位参加生育保险累计欠缴
    金额
     yearReportSubCapital
     s
    array[object] 年报-认缴出资信息
     ancheid string 300 年报ID
     condate string 100 认缴出资日期
     conform string 200 出资方式
     currency string 100 出资币种
     inv string 100 投资人/发起人
     lisubconam string 100 累计认缴额
     yearReportWebSiteInf
     os
    array[object] 年报-网站信息
     ancheid string 300 年报ID
     domain string 200 网站（网店）地址
     websitname string 200 网站（网店）名称
     webtype string 100 网站（网店）类型
     breakLaws array[object] 严重违法
     inReason string 列入原因
     inDate string 列入时间
     inRegOrg string 列入作出决定机关
     outDate string 列出时间
     outReason string 列出原因
     outRegOrg string 列出作出决定机关
```

## **<a name="enterpriseDeep"> 企业工商信息查询（深度）</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/enterprise/deep", // Y 请求地址
        "regNo":"91110531MA071J9L27", // N 注册号/社会统一信用代码
        "entName":"清河县xx制品有限公司", // N 企业名称
        "creditCode":"361502198111016871", // N 统一信用代码
        "orgCode":"" // N 组织机构代码
    }

```

#### 返回结果
```javascript
   {
     "msg": "查询成功",
     "code": "000",
     "data": {
       "yearReportForInvs": [],
       "filiations": [
         {
           "brnregorg": "四川省成都市高新工商行政管理局",
           "brregno": "510109000237689",
           "brncreditcode": "915101005902146068",
           "brname": "xx科技有限责任公司成都分公司"
         }
       ],
       "yearReportAlterStocks": [],
       "yearReportSocSecs": [
         {
           "unpaidsocialinsso110": "",
           "unpaidsocialinsso210": "",
           "unpaidsocialinsso310": "",
           "unpaidsocialinsso410": "",
           "unpaidsocialinsso510": "",
           "totalwagesso110": "",
           "totalwagesso310": "",
           "totalwagesso210": "",
           "so410": "676",
           "so310": "676",
           "so210": "676",
           "so110": "676",
           "totalwagesso510": "",
           "totalwagesso410": "",
           "totalpaymentso210": "",
           "totalpaymentso310": "",
           "totalpaymentso110": "",
           "totalpaymentso410": "",
           "totalpaymentso510": "",
           "ancheid": "d879d2f7136bd312ace9ea4097c01add",
           "so510": "676"
         }
       ],
       "punisheds": [
         {
           "regdateclean": "2016-09-01",
           "courtname": "北京市海淀区人民法院",
           "ysfzd": "",
           "execmoney": "21300",
           "inameclean": "xx科技有限责任公司",
           "type": "法人或其他组织",
           "casecode": "(2016)京0108执9146号",
           "sexyclean": "",
           "casestate": "已结案且全国法院被执行人查询平台已不披露",
           "ageclean": "",
           "cardnumclean": "551385082",
           "focusnumber": "0",
           "areanameclean": ""
         }
       ],
       "yearReportWebSiteInfos": [
         {
           "websitname": "xx商城",
           "webtype": "网店",
           "domain": "www.mi.com",
           "ancheid": "d879d2f7136bd312ace9ea4097c01add"
         }
       ],
       "yearReportSubCapitals": [
         {
           "inv": "洪锋",
           "lisubconam": "18623.099",
           "conform": "",
           "currency": "",
           "ancheid": "d879d2f7136bd312ace9ea4097c01add",
           "condate": "2015-10-30"
         }
       ],
       "frpositions": [
         {
           "esdate": "2014-03-14",
           "regno": "120116000221794",
           "ppvamount": "100",
           "enttype": "有限责任公司",
           "regcapcur": "人民币元",
           "candate": "2015-08-05",
           "lerepsign": "否",
           "entname": "天津未来新视界传媒有限公司",
           "regcap": "50.000000",
           "name": "高森",
           "regorg": "市自贸区市场监管局",
           "position": "董事",
           "entstatus": "注销",
           "revdate": "",
           "regorgcode": "120118"
         }
       ],
       "mortgagebasics": [],
       "mortgagepers": [],
       "yearReportAlters": [],
       "liquidations": [],
       "stockpawns": [
         {
           "stkpawnregno": "91110101511385012Q_0",
           "stkpawnczamt": "18623.099",
           "stkpawnczcerno": "",
           "stkpawnzqcerno": "91110108558521630L",
           "stkpawndate": "",
           "stkpawnstatus": "有效",
           "stkpawnczper": "洪锋",
           "stkpawnregdate": "2018-06-20",
           "stkpawnzqper": "xx通讯技术有限公司",
           "url": "b4a874046b4e85042ca17f9701371097"
         }
       ],
       "mortgagedebts": [],
       "mortgagepawns": [],
       "entcasebaseinfos": [
         {
           "illegacttype": "",
           "pendecno": "京工商朝处字〔2018〕第1322号",
           "pencontent": "责令当事人停止销售被依法判定为不合格商品的行为，并决定处罚如下：1、罚款278862元；2、没收违法所得7914元。",
           "pentypecn": "",
           "pentype": "",
           "publicdate": "",
           "penauthcn": "北京市工商行政管理局朝阳分局",
           "penauth": "",
           "pendecissdate": "2018-06-21"
         }
       ],
       "entinvs": [
         {
           "esdate": "2012-02-23",
           "regno": "320281000347219",
           "creditcode": "91320281591124880T",
           "enttype": "有限责任公司(自然人投资或控股)",
           "entjgname": "江苏紫米电子技术有限公司",
           "binvvamount": "12",
           "subconam": "136.370000",
           "regcapcur": "人民币元",
           "candate": "",
           "conform": "货币",
           "regcap": "705.880000",
           "name": "张峰",
           "regorg": "江阴市市场监督管理局",
           "congrocur": "",
           "entstatus": "在营（开业）",
           "fundedratio": "19.32%",
           "revdate": "",
           "regorgcode": "320281"
         }
       ],
       "punishbreaks": [],
       "stockpawnrevs": [
         {
           "stkpawnres": "3",
           "stkpawndate": "",
           "url": "f98def1cdab226d31006e5d17762a530"
         }
       ],
       "yearReportForGuarantees": [],
       "stockpawnalts": [],
       "mortgageregs": [],
       "mortgagealts": [],
       "yearReportPaidUpCapitals": [
         {
           "inv": "洪锋",
           "liacconam": "18623.099",
           "conform": "",
           "currency": "",
           "ancheid": "d879d2f7136bd312ace9ea4097c01add",
           "condate": "2015-10-30"
         }
       ],
       "relatedpunishbreaks": [
         {
           "businessentity": "王秀娟",
           "regdateclean": "2018-01-03",
           "courtname": "北京市第三中级人民法院",
           "ysfzd": "",
           "inameclean": "北京大杰致远信息技术有限公司",
           "exitdate": "2018-07-27",
           "type": "法人或其他组织",
           "disrupttypename": "违反财产报告制度",
           "casecode": "(2018)京03执37号",
           "cardnum": "68196972-1",
           "performance": "失信记录已退出",
           "sexyclean": "",
           "casestate": "中国执行信息公开网已不披露",
           "ageclean": "",
           "duty": "一、向北京合声易铭信息技术有限公司支付款项人民币七十二万三千零二十三元七角七分",
           "gistunit": "北京仲裁委员会",
           "publishdateclean": "2018-05-29",
           "unperformpart": "暂无",
           "focusnumber": "",
           "areanameclean": "北京",
           "gistid": "2017京仲裁字第2009号",
           "performedpart": "暂无"
         }
       ],
       "shareholders": [
         {
           "country": "中国",
           "invtype": "自然人股东",
           "conform": "货币",
           "shaname": "刘德",
           "fundedratio": "2.01%",
           "subconam": "3718.496300",
           "condate": "",
           "regcapcur": "人民币元"
         }
       ],
       "mortgagecans": [],
       "frinvs": [
         {
           "esdate": "2008-07-23",
           "regno": "110108011212261",
           "creditcode": "91110108678798255W",
           "enttype": "其他有限责任公司",
           "subconam": "20.000000",
           "regcapcur": "",
           "candate": "",
           "pinvamount": "50",
           "conform": "",
           "entname": "北京中关村竞合投资管理有限公司",
           "regcap": "1980.820000",
           "name": "王玮",
           "regorg": "北京市工商行政管理局海淀分局",
           "currency": "",
           "entstatus": "在营（开业）",
           "fundedratio": "1.01%",
           "revdate": "",
           "regorgcode": "110108"
         }
       ],
       "relatedpunisheds": [
         {
           "regdateclean": "2018-07-19",
           "courtname": "北京市朝阳区人民法院",
           "ysfzd": "",
           "execmoney": "53000",
           "inameclean": "北京尚品百姿电子商务有限公司",
           "type": "法人或其他组织",
           "casecode": "(2018)京0105执18234号",
           "sexyclean": "",
           "casestate": "执行中",
           "ageclean": "",
           "cardnumclean": "66911773-7",
           "focusnumber": "0",
           "areanameclean": ""
         }
       ],
       "sharesfrosts": [],
       "exceptions": [],
       "yearReportBasics": [
         {
           "regno": "110108012660422",
           "entname": "xx科技有限责任公司",
           "postalcode": "100085",
           "ancheyear": "2013",
           "busst": "开业",
           "tel": "13501279672",
           "ancheid": "QkNGNkE5NzUxQjFBOEVGRDQ3NERGQTEzMzVFMDlBMzdERTE2MzE5NjNFNTczMkM4NTgzQUZEMzU4NkE0RTNCQkVCNUYyQUE4NEQzM0I4M0EwQUIyNjY1QTc3MzBCNjAx",
           "addr": "北京市海淀区清河中街68号华润五彩城购物中心二期13",
           "creditno": "",
           "email": "chenchongwei@xiaomi.com",
           "anchedate": "2015-05-19"
         }
       ],
       "persons": [
         {
           "personamount": "6",
           "pername": "xx",
           "entname": "xx科技有限责任公司",
           "isFr": 1,
           "position": "董事长"
         }
       ],
       "alters": [
         {
           "altbe": "手机技术开发；手机生产、手机服务（限海淀区永捷北路2号二层经营）；从事互联网文化活动；出版物零售；出版物批发；销售第三类医疗器械；销售食品；零售药品。技术开发；货物进出口、技术进出口、代理进出口；销售通讯设备、厨房用品、卫生用品（含个人护理用品）、日用杂货、化妆品、医疗器械I类、II类、避孕器具、玩具、体育用品、文化用品、服装鞋帽、钟表眼镜、针纺织品、家用电器、家具（不从事实体店铺经营）、花、草及观赏植物、不再分装的包装种子、照相器材、工艺品、礼品、计算机、软件及辅助设备、珠宝首饰、食用农产品、宠物食品、电子产品、摩托车、电动车、自行车及零部件、智能卡、五金交电（不从事实体店铺经营）、建筑材料（不从事实体店铺经营）；维修仪器仪表；维修办公设备；承办展览展示活动；会议服务；筹备、策划、组织大型庆典；设计、制作、代理、发布广告；摄影扩印服务；文艺演出票务代理、体育赛事票务代理、展览会票务代理、博览会票务代理。企业依法自主选择经营项目，开展经营活动；从事互联网文化活动、出版物批发、出版物零售、销售食品、零售药品、销售第三类医疗器械以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。",
           "altaf": "手机技术开发；手机生产、手机服务（限海淀区永捷北路2号二层经营）；从事互联网文化活动；出版物零售；出版物批发；销售第三类医疗器械；销售食品；零售药品；广播电视节目制作。技术开发；货物进出口、技术进出口、代理进出口；销售通讯设备、厨房用品、卫生用品（含个人护理用品）、日用杂货、化妆品、医疗器械I类、II类、避孕器具、玩具、体育用品、文化用品、服装鞋帽、钟表眼镜、针纺织品、家用电器、家具（不从事实体店铺经营）、花、草及观赏植物、不再分装的包装种子、照相器材、工艺品、礼品、计算机、软件及辅助设备、珠宝首饰、食用农产品、宠物食品、电子产品、摩托车、电动车、自行车及零部件、智能卡、五金交电（不从事实体店铺经营）、建筑材料（不从事实体店铺经营）；维修仪器仪表；维修办公设备；承办展览展示活动；会议服务；筹备、策划、组织大型庆典；设计、制作、代理、发布广告；摄影扩印服务；文艺演出票务代理、体育赛事票务代理、展览会票务代理、博览会票务代理。企业依法自主选择经营项目，开展经营活动；从事互联网文化活动、出版物批发、出版物零售、销售食品、广播电视节目制作、零售药品、销售第三类医疗器械以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。",
           "altitem": "经营范围",
           "altdate": "2018-05-09"
         },
       ],
       "basic": {
         "esdate": "2010-03-03",
         "creditcode": "91110101511385012Q",
         "dom": "北京市海淀区清河中街68号华润五彩城购物中心二期13层",
         "zsopscope": "技术开发；货物进出口、技术进出口、代理进出口；销售通讯设备、厨房用品、卫生用品（含个人护理用品）、日用杂货、化妆品、医疗器械I类、II类、避孕器具、玩具、体育用品、文化用品、服装鞋帽、钟表眼镜、针纺织品、家用电器、家具（不从事实体店铺经营）、花、草及观赏植物、不再分装的包装种子、照相器材、工艺品、礼品、计算机、软件及辅助设备、珠宝首饰、食用农产品、宠物食品、电子产品、摩托车、电动车、自行车及零部件、智能卡、五金交电（不从事实体店铺经营）、建筑材料（不从事实体店铺经营）；维修仪器仪表；维修办公设备；承办展览展示活动；会议服务；筹备、策划、组织大型庆典；设计、制作、代理、发布广告；摄影扩印服务；文艺演出票务代理、体育赛事票务代理、展览会票务代理、博览会票务代理；手机技术开发；手机生产、手机服务（限海淀区永捷北路2号二层经营）；从事互联网文化活动；出版物零售；出版物批发；销售第三类医疗器械；销售食品；零售药品；广播电视节目制作。（企业依法自主选择经营项目，开展经营活动；从事互联网文化活动、出版物批发、出版物零售、销售食品、广播电视节目制作、零售药品、销售第三类医疗器械以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）",
         "reccap": "5000.000000",
         "enttype": "有限责任公司(自然人投资或控股)",
         "industryphyall": "m科学研究",
         "industryphyname": "科学研究",
         "industryphycode": "m",
         "opfrom": "2010-03-03",
         "enttypecode": "1130",
         "regorgdistrict": "北京市海淀区",
         "industryconame": "其他科技推广服务业",
         "entname": "xx科技有限责任公司",
         "regorg": "北京市工商行政管理局海淀分局",
         "domdistrict": "110108",
         "tel": "01069630728",
         "revdate": "",
         "abuitem": "手机技术开发；手机生产、手机服务；（限海淀区永捷北路2号二层经营）从事互联网文化活动。",
         "email": "",
         "frname": "xx",
         "regno": "110108012660422",
         "entnameeng": "xx科技有限责任公司",
         "oriregno": "",
         "ancheyear": "2015",
         "opto": "2030-03-02",
         "regcapcur": "人民币元",
         "empnum": "6",
         "industrycoall": "759其他科技推广服务业",
         "candate": "",
         "industrycocode": "759",
         "regcap": "185000.000000",
         "regorgcity": "北京市",
         "regorgprovince": "北京市",
         "entstatus": "在营（开业）",
         "entnameold": "北京xx科技有限责任公司",
         "regorgcode": "110108",
         "apprdate": "2018-06-20"
       }
     }
   }
```

### 响应数据参数说明
``` javascript
    code string 6 响应代码
    msg string 50 响应代码说明
    data object 响应数据
     basic object 企业基本信息
     entname string 600 企业名称
     entnameold string 600 曾用名
     entnameeng string 600 企业英文名称
     creditcode string 300 统一信用代码
     regno string 100 注册号
     oriregno string 300 原注册号
     frname string 300 法定代表人/负责人/执行事
    务合伙人
     esdate string 100 成立日期
     industrycocode string 100 国民经济行业代码
     industryconame string 100 国民经济代码名称
     regcap string 100 注册资本
    企业:万
    元 个体
    ：不确定
     regcapcur string 100 注册资本币种
     reccap string 100 实收资本(万元)
     regorg string 300 登记机关
     entstatus string 100 经营状态
     enttype string 300 企业类型
     opfrom string 100 经营期限自
     opto string 100 经营期限至
     regorgprovince string 100 所在省份
     regorgcity string 100 所在城市
     regorgdistrict string 100 所在区/县
     email string 300 邮箱
     dom string 2000 住址
     abuitem string 4000 许可经营项目
     zsopscope string 4000 经营业务范围
     ancheyear string 100 最后年检年度
     tel string 100 联系人电话
     empnum string 100 员工人数
     revdate string 100 吊销日期
     candate string 100 注销日期
     apprdate string 100 核准日期
     domdistrict string 100 住所所在行政区划
     regorgcode string 100 注册地址行政编号
     enttypecode string 100 企业(机构)类型编码
     industryphycode string 100 行业门类代码
     industryphyname string 100 行业门类名称
     industrycoall string 100 国民经济行业代码及名称
     industryphyall string 100 行业门类代码及名称
     persons array[object] 主要管理人员
     entname string 600 企业名称
     pername string 300 人员姓名
     position string 100 职位
     isFr string 2 是否法人 1.是
    0.否
     personamount string 100 人员总数量
     frpositions array[object] 法定代表人其他公司任职
     entname string 600 企业机构名称
     regno string 100 注册号
     regcap string 100 注册资本
    企业:万
    元 个体
    ：不确定
     esdate string 100 成立日期
     revdate string 100 吊销日期
     candate string 100 注销日期
     regorg string 300 登记机关
     entstatus string 100 企业状态
     regorgcode string 100 注册地址行政区编号
     regcapcur string 100 注册资本币种
     enttype string 300 企业（机构）类型
     name string 300 法定代表人姓名
     position string 100 职务
     lerepsign string 300 是否法定代表人
     ppvamount string 300 企业总数量
     frinvs array[object] 企业法定代表人对外投资信
    息
     entname string 600 企业(机构)名称
     creditcode string 300 统一社会信用代码
     regno string 100 注册号
     regcap string 100 注册资本
    企业:万
    元 个体
    ：不确定
     regcapcur string 100 注册资本币种
     subconam string 100 认缴出资额（万元）
     currency string 300 认缴出资币种
     entstatus string 100 企业状态
     regorg string 300 登记机关
     enttype string 300 企业（机构）类型
     regorgcode string 100 注册地址行政区编号
     conform string 300 出资方式
     esdate string 100 开业日期
     revdate string 100 吊销日期
     candate string 100 注销日期
     name string 300 法定代表人姓名
     fundedratio string 300 出资比例
     pinvamount string 100 企业总数量
     shareholders array[object] 股东及出资信息
     shaname string 600 股东名称
     invtype string 100 股东类型
     country string 300 国别
     conform string 300 出资方式
     subconam string 100 认缴出资额（万元）
     regcapcur string 100 认缴出资币种
     fundedratio string 300 出资比例
     condate string 100 出资日期
     filiations array[object] 分支机构
     brname string 600 分支机构名称
     brncreditcode string 300 分支机构统一社会信用代码
     brregno string 300 分支机构企业注册号
     brnregorg string 300 分支机构登记机关
     alters array[object] 变更信息
     altitem string 300 变更事项
     altbe string 4000 变更前内容
     altaf string 4000 变更后内容
     altdate string 100 变更日期
     exceptions array[object] 企业异常名录
     entname string 100 企业名称
     indate string 100 列入日期
     inreason string 500 列入原因
     outdate string 100 移出日期
     outreason string 500 退出异常名录原因
     regno string 100 注册号
     shxydm string 100 统一社会信用代码
     ycregorg string 100 移出机关名称
     yrregorg string 100 列入机关名称
     entcasebaseinfos array[object] 行政处罚基本信息
     pendecno string 600 处罚决定文书
     illegacttype string 4000 主要违法事实
     pentype string 4000 处罚种类
     pentypecn string 4000 处罚种类中文
     pencontent string 4000 行政处罚内容
     penauth string 300 处罚机关
     penauthcn string 600 处罚机关名称
     pendecissdate string 100 处罚决定书签发日期
     publicdate string 100 公示日期
     entinvs array[object] 企业对外投资信息
     regno string 100 注册号
     entjgname string 600 企业机构名称
     regcap string 100 注册资本
    企业:万
    元 个体
    ：不确定
     subconam string 100 认缴出资额（万元）
     esdate string 100 开业日期
     name string 300 法定代表人姓名
     binvvamount string 300 企业总数量
     revdate string 100 吊销日期
     candate string 100 注销日期
     fundedratio string 300 投资比例
     conform string 300 出资方式
     regorg string 300 登记机关
     entstatus string 100 企业状态
     enttype string 300 企业（机构）类型
     congrocur string 300 认缴出资币种
     regcapcur string 100 注册资本币种
     regorgcode string 100 注册地址行政区编号
     creditcode string 300 统一社会信用代码
     punisheds array[object] 被执行人信息
     inameclean string 600 被执行人姓名/名称
     casestate string 1000 案件状态
     execmoney string 600 执行标的（元）
     regdateclean string 100 立案时间
     courtname string 2000 执行法院
     casecode string 1000 案号
     type string 1000 被执行人类型
     cardnumclean string 600 身份证号码/企业注册号
     areanameclean string 300 省份
     ysfzd string 300 身份证原始发证地
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     sexyclean string 100 性别
     liquidations array[object] 清算信息
     debttranee string 1000 债务承接人
     claimtranee string 600 债权承接人
     ligprincipal string 600 清算负责人
     liqmen string 600 清算组成员
     addr string 2000 地址
     tel string 100 联系电话
     ligst string 300 清算完结情况
     ligenddate string 100 清算完结日期
     mortgagealts array[object] 动产抵押-变更信息
     mabregno string 300 登记编号
     mabaltdate string 100 变更日期
     mabaltdetails string 4000 变更内容
     mortgagebasics array[object] 动产抵押-基本信息
     mabregno string 300 登记编号
     mabregdate string 100 登记日期
     mabregorg string 300 登记机关
     mabguaramt string 2000 被担保债权数额
     mabstatus string 100 状态
     mabgsdate string 100 公示日期
     mortgagecans array[object] 动产抵押-注销信息
     mabregno string 300 登记编号
     mabcandate string 100 注销日期
     mabcanres string 4000 注销原因
     mortgagedebts array[object] 动产抵押-被担保主债权信
    息
     mabregno string 300 登记编号
     mabdebttype string 300 种类
     mabdebtrange string 4000 担保范围
     mabdebtrmk string 2000 备注
     mabdebtamt string 300 数额
     debtsdate string 100 履行债务开始日期
     debtedate string 100 履行债务结束日期
     mortgagepawns array[object] 动产抵押-抵押物信息
     mabregno string 300 登记编号
     mabpawnname string 600 名称
     mabpawnowner string 2000 所有权或使用权归属
     mabpawndetails string 4000 数量、质量、状况、所在地
    等情况
     mabpawnrmk string 2000 备注
     mortgagepers array[object] 动产抵押-抵押人信息
     mabregno string 300 登记编号
     mabpername string 600 抵押权人名称
     mabpercertype string 600 抵押权人证照/证件类型
     mabpercerno string 300 抵押权人证照/证件号码
     mabperdom string 600 所在地
     mortgageregs array[object] 动产抵押-登记信息
     mabregno string 300 登记编号
     mabregdate string 100 登记日期
     mabregorg string 300 登记机关
     mabguaramt string 2000 被担保债权数额
     nodenum string 100 省份代码
     mabguarrange string 4000 担保范围
     mabguartype string 2000 被担保债券种类
     debtsdate string 100 履行债务开始日期
     debtedate string 100 履行债务结束日期
     status string 100 状态
     punishbreaks array[object] 失信被执行人信息
     type string 1000 失信人类型
     inameclean string 600 被执行人姓名/名称
     publishdateclean string 100 发布时间
     regdateclean string 100 立案时间
     cardnum string 600 身份证号码/工商注册号
     courtname string 2000 执行法院
     gistid string 1000 执行依据文号
     casecode string 1000 案号
     gistunit string 1000 做出执行依据单位
     duty string CLOB 生效法律文书确定的义务
     performance string 1000 被执行人履行情况
     performedpart string 2000 已履行（元）
     unperformpart string 2000 未履行（元）
     disrupttypename string 4000 失信被执行人行为具体情形
     businessentity string 300 法定代表人或者负责人姓名
     areanameclean string 300 省份
     sexyclean string 100 性别
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     ysfzd string 300 身份证原始发证地
     exitdate string 100 退出日期
     casestate string 1000 案件状态
     relatedpunishbreaks array[object] 关联失信被执行人信息
     gistunit string 1000 做出执行依据单位
     duty string CLOB 生效法律文书确定的义务
     performance string 1000 被执行人履行情况
     performedpart string 2000 已履行（元）
     unperformpart string 2000 未履行（元）
     disrupttypename string 4000 失信被执行人行为具体情形
     businessentity string 300 法定代表人或者负责人姓名
     areanameclean string 300 省份
     sexyclean string 100 性别
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     ysfzd string 300 身份证原始发证地
     exitdate string 100 退出日期
     casestate string 1000 案件状态
     type string 1000 失信人类型
     inameclean string 600 被执行人姓名/名称
     publishdateclean string 100 发布时间
     regdateclean string 100 立案时间
     cardnum string 600 身份证号码/工商注册号
     courtname string 2000 执行法院
     gistid string 1000 执行依据文号
     casecode string 1000 案号
     relatedpunisheds array[object] 关联被执行人信息
     courtname string 2000 执行法院
     casecode string 1000 案号
     type string 1000 被执行人类型
     cardnumclean string 600 身份证号码/企业注册号
     areanameclean string 300 省份
     ysfzd string 300 身份证原始发证地
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     sexyclean string 100 性别
     inameclean string 600 被执行人姓名/名称
     casestate string 1000 案件状态
     execmoney string 600 执行标的（元）
     regdateclean string 100 立案时间
     sharesfrosts array[object] 股权冻结信息
     froam string 100 冻结金额（万元）
     froauth string 300 冻结机关
     frofrom string 100 冻结起始日期
     frodocno string 4000 冻结文号
     thawauth string 300 解冻机关
     thawdocno string 100 解冻文号
     thawdate string 100 解冻日期
     thawcomment string 4000 解冻说明
     froto string 100 冻结截至日期
     stockpawns array[object] 股权出质信息（新）
     stkpawnregno string 300 登记编号
     stkpawnczper string 300 出质人
     stkpawnczcerno string 600 出质人证件/证件号
     stkpawnczamt string 600 出质股权数额
     stkpawnzqper string 300 质权人姓名
     stkpawnzqcerno string 600 质权人证件/证件号
     stkpawnregdate string 100 质权出质设立登记日期
     stkpawnstatus string 600 状态
     stkpawndate string 100 公示日期
     url string 4000 关联内容
     stockpawnalts array[object] 股权出质信息（新）-变更
    信息
     stkpawnbgnr string 4000 变更内容
     stkpawnbgrq string 100 变更日期
     url string 4000 关联内容
     stockpawnrevs array[object] 股权出质信息（新）-注销
    信息
     url string 4000 关联内容
     stkpawndate string 100 注销日期
     stkpawnres string 4000 注销原因
     yearReportAlters array[object] 年报-修改信息
     ancheid string 300 年报ID
     altitem string 600 修改事项
     altaf string 4000 修改后
     altbe string 4000 修改前
     altdate string 50 修改日期
     yearReportAlterStock
     s
    array[object] 年报-股权变更信息
     altdate string 50 股权变更日期
     ancheid string 300 年报ID
     inv string 600 股东名称
     transamaft string 100 转让后股权比例
     transampr string 100 转让前股权比例
     yearReportBasics array[object] 年报-企业年报基本信息
     ancheid string 300 年报ID
     addr string 1000 地址
     anchedate string 50 年报日期
     ancheyear string 50 年报年份
     busst string 50 经营状态
     creditno string 100 统一信用代码
     email string 200 电子邮箱
     entname string 300 企业名称
     postalcode string 50 邮政编码
     regno string 100 注册号
     tel string 100 电话
     yearReportForGuarant
     ees
    array[object] 年报-企业对外提供保证担
    保信息
     ancheid string 300 年报ID
     gatype string 100 保证的方式
     guarapperiod string 200 保证的期间
     more string 100 债权人
     mortgagor string 600 债务人
     pefperform string 50 履行债务的期限自
     pefperto string 50 履行债务的期限至
     priclasecam string 100 主债权数额
     priclaseckind string 100 主债权种类
     rage string 2000 保证担保的范围
     yearReportForInvs array[object] 年报-企业对外投资信息
     ancheid string 300 年报ID
     creditno string 100 统一信用代码
     entname string 300 企业名称
     regno string 100 注册号
     yearReportPaidUpCapi
     tals array[object] 年报-企业实缴出资信息
     ancheid string 300 年报ID
     condate string 50 实缴出资日期
     conform string 300 出资方式
     currency string 100 币种
     inv string 600 股东/发起人
     liacconam string 100 累计实缴额（万元）
     yearReportSocSecs array[object] 年报-社会保险信息
     ancheid string 300 年报ID
     so110 string 100 城镇职工基本养老保险参保
    人数
     so210 string 100 失业保险参保人数
     so310 string 100 职工基本医疗保险参保人数
     so410 string 100 工伤保险参保人数
     so510 string 100 生育保险参保人数
     totalpaymentso110 string 100 参加城镇职工基本养老保险
    本期实际缴费金额
     totalpaymentso210 string 100 参加失业保险本期实际缴费
    金额
     totalpaymentso310 string 100 参加职工基本医疗保险本期
    实际缴费金额
     totalpaymentso410 string 100 参加工伤保险本期实际缴费
    金额
     totalpaymentso510 string 100 参加生育保险本期实际缴费
    金额
     totalwagesso110 string 100 单位参加城镇职工基本养老
    保险缴费基数
     totalwagesso210 string 100 单位参加失业保险缴费基数
     totalwagesso310 string 100 单位参加职工基本医疗保险
    缴费基数
     totalwagesso410 string 100 单位参加工伤保险缴费基数
     totalwagesso510 string 100 单位参加生育保险缴费基数
     unpaidsocialinsso1
     10 string 100 单位参加城镇职工基本养老
    保险累计欠缴金额
     unpaidsocialinsso2
     10 string 100 单位参加失业保险累计欠缴
    金额
     unpaidsocialinsso3
     10 string 100 单位参加职工基本医疗保险
    累计欠缴金额
     unpaidsocialinsso4
     10 string 100 参加工伤保险累计欠缴金额
     unpaidsocialinsso5
     10 string 100 单位参加生育保险累计欠缴
    金额
     yearReportSubCapital
     s
    array[object] 年报-认缴出资信息
     ancheid string 300 年报ID
     condate string 50 认缴出资日期
     conform string 100 出资方式
     currency string 100 出资币种
     inv string 600 投资人/发起人
     lisubconam string 100 累计认缴额
     yearReportWebSiteInf
     os
    array[object] 年报-网站信息
     ancheid string 300 年报ID
     domain string 4000 网站（网店）地址
     websitname string 2000 网站（网店）名称
     webtype string 100 网站（网店）类型
     judicialAids array[object] 司法协助基本信息
     courtName string 1000 执行法院
     courtNo string 100 协助公示通知书文号
     cur string 100 币种
     iName string 300 被执行人
     modifyId string 100 股权变更ID
     parentId string 100 被执行人ID
     shareAm string 100 股权数额
     status string 100 股权冻结状态
     judicialAidAlters array[object] 司法协助变更信息
     aeDate string 50 协助执行日期
     assignee string 300 受让人
     assigneeIType string 100 受让人证件类型
     assigneeLicence string 100 受让人证照号码
     assigneeLType string 100 受让人证照类型
     assigneeType string 100 受让人类型
     courtName string 1000 执行法院
     cur string 100 币种
     execution string 300 执行事项
     exNoticeNo string 300 协助执行通知书文号
     iName string 300 被执行人
     iNameIType string 100 被执行人证件类型
     iNameLicence string 100 被执行人证照号码
     iNameLType string 100 被执行人证照类型
     iNameType string 100 被执行人类型
     judgmentNo string 300 执行裁定书文号
     modifyId string 100 股权变更ID
     shareAm string 100 股权数额
     judicialAidDetails array[object] 司法协助详情
     cfPeriod string 100 续行冻结期限
     cfRoFrom string 50 续行冻结期限自
     cfRoTo string 50 续行冻结期限至
     courtName string 1000 执行法院
     cur string 100 币种
     execution string 300 执行事项
     expirationDate string 50 失效日期
     expirationReason string 100 失效原因
     exNoticeNo string 300 协助执行通知书文号
     fPeriod string 100 冻结期限
     freezeDate string 50 解冻日期
     freezeFlag string 100 股权冻结状态
     froFrom string 50 冻结期限自
     froTo string 50 冻结期限至
     idType string 100 证件类型
     iName string 300 被执行人
     iNameType string 100 被执行人类型
     judgementNo string 300 执行裁定书文号
     licenceNo string 100 证照编号
     licenceType string 100 证照类型
     marketCreditCode string 100 被冻结股权所在市场统一社
    会信用代码
     marketName string 100 被冻结股权所在市场主体名
    称
     parentId string 100 被执行人ID
     publicDate string 50 公示日期
     registNo string 100 被冻结股权所在市场主体注
    册号
    3.1.7 响应示例
    {
     "msg":"查询成功",
     "code":"000",
     "data":{
     "yearReportForInvs":[],
     "filiations":[
     {
     "brnregorg":"四川省成都市高新工商行政管理局",
     "brregno":"510109000237689",
     "brncreditcode":"915101005902146068",
     "brname":"xx科技有限责任公司成都分公司"
     }
     ],
     "yearReportAlterStocks":[],
     "yearReportSocSecs":[
     {
     "unpaidsocialinsso110":"",
     "unpaidsocialinsso210":"",
     "unpaidsocialinsso310":"",
     "unpaidsocialinsso410":"",
     "unpaidsocialinsso510":"",
     "totalwagesso110":"",
     "totalwagesso310":"",
     "totalwagesso210":"",
     "so410":"676",
     "so310":"676",
     "so210":"676",
     shareAm string 100 股权数额
     shareAmUnit string 100 股权数额单位
     breakLaws array[object] 严重违法
     inReason string 列入原因
     inDate string 列入时间
     inRegOrg string 列入作出决定机关
     outDate string 列出时间
     outReason string 列出原因
     outRegOrg string 列出作出决定机关
```

## **<a name="enterpriseSAAS"> 企业工商信息查询（SAAS）</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/enterprise/saas", // Y 请求地址
        "regNo":"91110531MA071J9L27", // N 注册号/社会统一信用代码
        "entName":"清河县xx制品有限公司", // N 企业名称
        "creditCode":"361502198111016871", // N 统一信用代码
        "orgCode":"" // N 组织机构代码
    }

```

#### 返回结果
```javascript
    {
      "msg": "查询成功",
      "code": "000",
      "data": {
        "yearReportForInvs": [],
        "filiations": [
          {
            "brnregorg": "四川省成都市高新工商行政管理局",
            "brregno": "510109000237689",
            "brncreditcode": "915101005902146068",
            "brname": "xx科技有限责任公司成都分公司"
          }
        ],
        "yearReportAlterStocks": [],
        "yearReportSocSecs": [
          {
            "unpaidsocialinsso110": "",
            "unpaidsocialinsso210": "",
            "unpaidsocialinsso310": "",
            "unpaidsocialinsso410": "",
            "unpaidsocialinsso510": "",
            "totalwagesso110": "",
            "totalwagesso310": "",
            "totalwagesso210": "",
            "so410": "676",
            "so310": "676",
            "so210": "676",
            "so110": "676",
            "totalwagesso510": "",
            "totalwagesso410": "",
            "totalpaymentso210": "",
            "totalpaymentso310": "",
            "totalpaymentso110": "",
            "totalpaymentso410": "",
            "totalpaymentso510": "",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add",
            "so510": "676"
          }
        ],
        "punisheds": [
          {
            "regdateclean": "2016-09-01",
            "courtname": "北京市海淀区人民法院",
            "ysfzd": "",
            "execmoney": "21300",
            "inameclean": "xx科技有限责任公司",
            "type": "法人或其他组织",
            "casecode": "(2016)京0108执9146号",
            "sexyclean": "",
            "casestate": "已结案且全国法院被执行人查询平台已不披露",
            "ageclean": "",
            "cardnumclean": "551385082",
            "focusnumber": "0",
            "areanameclean": ""
          }
        ],
        "yearReportWebSiteInfos": [
          {
            "websitname": "xx商城",
            "webtype": "网店",
            "domain": "www.mi.com",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add"
          }
        ],
        "yearReportSubCapitals": [
          {
            "inv": "洪锋",
            "lisubconam": "18623.099",
            "conform": "",
            "currency": "",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add",
            "condate": "2015-10-30"
          }
        ],
        "frpositions": [
          {
            "esdate": "2014-03-14",
            "regno": "120116000221794",
            "ppvamount": "100",
            "enttype": "有限责任公司",
            "regcapcur": "人民币元",
            "candate": "2015-08-05",
            "lerepsign": "否",
            "entname": "天津未来新视界传媒有限公司",
            "regcap": "50.000000",
            "name": "高森",
            "regorg": "市自贸区市场监管局",
            "position": "董事",
            "entstatus": "注销",
            "revdate": "",
            "regorgcode": "120118"
          }
        ],
        "mortgagebasics": [],
        "mortgagepers": [],
        "yearReportAlters": [],
        "liquidations": [],
        "stockpawns": [
          {
            "stkpawnregno": "91110101511385012Q_0",
            "stkpawnczamt": "18623.099",
            "stkpawnczcerno": "",
            "stkpawnzqcerno": "91110108558521630L",
            "stkpawndate": "",
            "stkpawnstatus": "有效",
            "stkpawnczper": "洪锋",
            "stkpawnregdate": "2018-06-20",
            "stkpawnzqper": "xx通讯技术有限公司",
            "url": "b4a874046b4e85042ca17f9701371097"
          }
        ],
        "mortgagedebts": [],
        "mortgagepawns": [],
        "invpersoninvs": [
          {
            "conprop": "90.0",
            "country": "中国",
            "conform": "货币",
            "entnameInv": "",
            "name": "雷军",
            "currency": "156",
            "subconam": "270.0",
            "acconam": "0.0",
            "condate": "2016-06-01"
          }
        ],
        "entcasebaseinfos": [
          {
            "illegacttype": "",
            "pendecno": "京工商朝处字〔2018〕第1322号",
            "pencontent": "责令当事人停止销售被依法判定为不合格商品的行为，并决定处罚如下：1、罚款278862元；2、没收违法所得7914元。",
            "pentypecn": "",
            "pentype": "",
            "publicdate": "",
            "penauthcn": "北京市工商行政管理局朝阳分局",
            "penauth": "",
            "pendecissdate": "2018-06-21"
          }
        ],
        "entinvs": [
          {
            "esdate": "2012-02-23",
            "regno": "320281000347219",
            "creditcode": "91320281591124880T",
            "enttype": "有限责任公司(自然人投资或控股)",
            "entjgname": "江苏紫米电子技术有限公司",
            "binvvamount": "12",
            "subconam": "136.370000",
            "regcapcur": "人民币元",
            "candate": "",
            "conform": "货币",
            "regcap": "705.880000",
            "name": "张峰",
            "regorg": "江阴市市场监督管理局",
            "congrocur": "",
            "entstatus": "在营（开业）",
            "fundedratio": "19.32%",
            "revdate": "",
            "regorgcode": "320281"
          }
        ],
        "punishbreaks": [],
        "stockpawnrevs": [
          {
            "stkpawnres": "3",
            "stkpawndate": "",
            "url": "f98def1cdab226d31006e5d17762a530"
          }
        ],
        "yearReportForGuarantees": [],
        "stockpawnalts": [],
        "managerPersoninvs": [
          {
            "conprop": "90.0",
            "country": "中国",
            "conform": "货币",
            "entnameInv": "",
            "name": "雷军",
            "currency": "156",
            "subconam": "270.0",
            "acconam": "0.0",
            "condate": "2016-06-01"
          }
        ],
        "mortgageregs": [],
        "mortgagealts": [],
        "yearReportPaidUpCapitals": [
          {
            "inv": "洪锋",
            "liacconam": "18623.099",
            "conform": "",
            "currency": "",
            "ancheid": "d879d2f7136bd312ace9ea4097c01add",
            "condate": "2015-10-30"
          }
        ],
        "relatedpunishbreaks": [
          {
            "businessentity": "王秀娟",
            "regdateclean": "2018-01-03",
            "courtname": "北京市第三中级人民法院",
            "ysfzd": "",
            "inameclean": "北京大杰致远信息技术有限公司",
            "exitdate": "2018-07-27",
            "type": "法人或其他组织",
            "disrupttypename": "违反财产报告制度",
            "casecode": "(2018)京03执37号",
            "cardnum": "68196972-1",
            "performance": "失信记录已退出",
            "sexyclean": "",
            "casestate": "中国执行信息公开网已不披露",
            "ageclean": "",
            "duty": "一、向北京合声易铭信息技术有限公司支付款项人民币七十二万三千零二十三元七角七分。\n二、向北京合声易铭信息技术有限公司支付赔偿金（按照中国人民银行同期贷款利率标准计算，以人民币七十四万八千一百三十二元四角为基数，自2017年11月9日起至2017年12月17日止；以人民币六十四万八千一百三十二元四角为基数，自2017年12月23日起至实际返还赔偿金之日止）。\n三、向北京合声易铭信息技术有限公司支付迟延履行期间的迟延履行利息。\n四、负担案件执行费人民币九千六百七十元以及执行中实际支出的费用。",
            "gistunit": "北京仲裁委员会",
            "publishdateclean": "2018-05-29",
            "unperformpart": "暂无",
            "focusnumber": "",
            "areanameclean": "北京",
            "gistid": "2017京仲裁字第2009号",
            "performedpart": "暂无"
          }
        ],
        "shareholders": [
          {
            "country": "中国",
            "invtype": "自然人股东",
            "conform": "货币",
            "shaname": "xx",
            "fundedratio": "77.80%",
            "subconam": "143934.047800",
            "condate": "",
            "regcapcur": "人民币元"
          }
        ],
        "mortgagecans": [],
        "invpositions": [
          {
            "lerepsign": false,
            "entname": "瓦力信息技术（北京）有限公司",
            "name": "雷军",
            "position": "执行董事"
          }
        ],
        "frinvs": [
          {
            "esdate": "2008-07-23",
            "regno": "110108011212261",
            "creditcode": "91110108678798255W",
            "enttype": "其他有限责任公司",
            "subconam": "20.000000",
            "regcapcur": "",
            "candate": "",
            "pinvamount": "50",
            "conform": "",
            "entname": "北京中关村竞合投资管理有限公司",
            "regcap": "1980.820000",
            "name": "王玮",
            "regorg": "北京市工商行政管理局海淀分局",
            "currency": "",
            "entstatus": "在营（开业）",
            "fundedratio": "1.01%",
            "revdate": "",
            "regorgcode": "110108"
          }
        ],
        "relatedpunisheds": [
          {
            "regdateclean": "2018-07-19",
            "courtname": "北京市朝阳区人民法院",
            "ysfzd": "",
            "execmoney": "53000",
            "inameclean": "北京尚品百姿电子商务有限公司",
            "type": "法人或其他组织",
            "casecode": "(2018)京0105执18234号",
            "sexyclean": "",
            "casestate": "执行中",
            "ageclean": "",
            "cardnumclean": "66911773-7",
            "focusnumber": "0",
            "areanameclean": ""
          }
        ],
        "sharesfrosts": [],
        "exceptions": [],
        "yearReportBasics": [
          {
            "regno": "110108012660422",
            "entname": "xx科技有限责任公司",
            "postalcode": "100085",
            "ancheyear": "2017",
            "busst": "开业",
            "tel": "60606666-1000",
            "ancheid": "4b7e3eb18533b52faddb659ff364779f",
            "addr": "北京市海淀区清河中街68号华润五彩城购物中心二期13层",
            "creditno": "91110101511385012Q",
            "email": "chenchongwei@xiaomi.com",
            "anchedate": "2018-06-13"
          }
        ],
        "persons": [
          {
            "personamount": "6",
            "pername": "xx",
            "entname": "xx科技有限责任公司",
            "isFr": 1,
            "position": "董事长"
          }
        ],
        "alters": [
          {
            "altbe": "5000万元",
            "altaf": "185000万元",
            "altitem": "注册资本",
            "altdate": "2016-03-24"
          },
          {
            "altbe": "xx,董事长;xx,董事;xx,董事;林斌,董事;xx,董事;xx,经理;xx,监事;",
            "altaf": "xx,董事长;xx,董事;xx,董事;林斌,董事;xx,经理;xx,监事;",
            "altitem": "董事（理事）、经理、监事",
            "altdate": "2014-03-12"
          },
          {
            "altbe": "北京xx科技有限责任公司",
            "altaf": "xx科技有限责任公司",
            "altitem": "企业名称",
            "altdate": "2013-07-30"
          },
        ],
        "managerPositions": [
          {
            "lerepsign": false,
            "entname": "瓦力信息技术（北京）有限公司",
            "name": "雷军",
            "position": "执行董事"
          },
        ],
        "basic": {
          "esdate": "2010-03-03",
          "creditcode": "91110101511385012Q",
          "dom": "北京市海淀区清河中街68号华润五彩城购物中心二期13层",
          "zsopscope": "技术开发；货物进出口、技术进出口、代理进出口；销售通讯设备、厨房用品、卫生用品（含个人护理用品）、日用杂货、化妆品、医疗器械I类、II类、避孕器具、玩具、体育用品、文化用品、服装鞋帽、钟表眼镜、针纺织品、家用电器、家具（不从事实体店铺经营）、花、草及观赏植物、不再分装的包装种子、照相器材、工艺品、礼品、计算机、软件及辅助设备、珠宝首饰、食用农产品、宠物食品、电子产品、摩托车、电动车、自行车及零部件、智能卡、五金交电（不从事实体店铺经营）、建筑材料（不从事实体店铺经营）；维修仪器仪表；维修办公设备；承办展览展示活动；会议服务；筹备、策划、组织大型庆典；设计、制作、代理、发布广告；摄影扩印服务；文艺演出票务代理、体育赛事票务代理、展览会票务代理、博览会票务代理；手机技术开发；手机生产、手机服务（限海淀区永捷北路2号二层经营）；从事互联网文化活动；出版物零售；出版物批发；销售第三类医疗器械；销售食品；零售药品；广播电视节目制作。（企业依法自主选择经营项目，开展经营活动；从事互联网文化活动、出版物批发、出版物零售、销售食品、广播电视节目制作、零售药品、销售第三类医疗器械以及依法须经批准的项目，经相关部门批准后依批准的内容开展经营活动；不得从事本市产业政策禁止和限制类项目的经营活动。）",
          "reccap": "5000.000000",
          "enttype": "有限责任公司(自然人投资或控股)",
          "opfrom": "2010-03-03",
          "enttypecode": "1130",
          "regorgdistrict": "北京市海淀区",
          "industryconame": "其他科技推广服务业",
          "entname": "xx科技有限责任公司",
          "regorg": "北京市工商行政管理局海淀分局",
          "domdistrict": "110108",
          "tel": "01069630728",
          "revdate": "",
          "abuitem": "手机技术开发；手机生产、手机服务；（限海淀区永捷北路2号二层经营）从事互联网文化活动。",
          "email": "",
          "frname": "xx",
          "regno": "110108012660422",
          "entnameeng": "xx科技有限责任公司",
          "oriregno": "",
          "ancheyear": "2015",
          "opto": "2030-03-02",
          "regcapcur": "人民币元",
          "empnum": "6",
          "candate": "",
          "industrycocode": "759",
          "regcap": "185000.000000",
          "regorgcity": "北京市",
          "regorgprovince": "北京市",
          "entstatus": "在营（开业）",
          "entnameold": "北京xx科技有限责任公司",
          "regorgcode": "110108",
          "apprdate": "2018-06-20"
        }
      }
    }

```

### 响应数据参数说明
``` javascript
     alters array[object] 变更信息
     altbe string 4000 变更前内容
     altaf string 4000 变更后内容
     altdate string 100 变更日期
     altitem string 300 变更事项
     basic object 企业基本信息
     abuitem string 4000 许可经营项目
     industrycocode string 100 国民经济行业代码
     industryconame string 100 国民经济代码名称
     entnameeng string 600 企业英文名称
     oriregno string 300 原注册号
     regno string 100 注册号
     reccap string 100 实收资本(万元)
     creditcode string 300 统一信用代码
     opto string 100 经营期限至
     opfrom string 100 经营期限自
     entname string 600 企业名称
     regcap string 100 注册资本（企业:万元）
     esdate string 100 成立日期
     frname string 300 法定代表人/负责人/执行事
    务合伙人
     regorg string 300 登记机关
     entstatus string 100 经营状态
     enttype string 300 企业类型
     regorgprovince string 100 所在省份
     regorgcity string 100 所在城市
     regorgdistrict string 100 所在区/县
     regcapcur string 100 注册资本币种
     ancheyear string 100 最后年检年度
     email string 300 邮箱
     dom string 2000 住址
     tel string 100 联系人电话
     empnum string 100 员工人数
     revdate string 100 吊销日期
     candate string 100 注销日期
     domdistrict string 100 住所所在行政区划
     regorgcode string 100 注册地址行政编号
     zsopscope string 4000 经营业务范围
     entnameold string 600 曾用名
     apprdate string 100 核准日期
     enttypecode string 100 企业(机构)类型编码
     exceptions array[object] 企业异常名录
     entname string 100 企业名称
     indate string 100 列入日期
     inreason string 500 列入原因
     outdate string 100 移出日期
     outreason string 500 退出异常名录原因
     regno string 100 注册号
     shxydm string 100 统一社会信用代码
     ycregorg string 100 移出机关名称
     yrregorg string 100 列入机关名称
     entcasebaseinfos array[object] 行政处罚基本信息
     pendecno string 600 处罚决定文书
     illegacttype string 4000 主要违法事实
     pentype string 4000 处罚种类
     pentypecn string 4000 处罚种类中文
     pencontent string 4000 行政处罚内容
     penauth string 300 处罚机关
     penauthcn string 600 处罚机关名称
     pendecissdate string 100 处罚决定书签发日期
     publicdate string 100 公示日期
     entinvs array[object] 企业对外投资信息
     regno string 100 注册号
     entjgname string 600 企业机构名称
     regcap string 100 注册资本（企业:万元）
     subconam string 100 认缴出资额（万元）
     esdate string 100 开业日期
     name string 300 法定代表人姓名
     binvvamount string 300 企业总数量
     revdate string 100 吊销日期
     candate string 100 注销日期
     fundedratio string 300 投资比例
     conform string 300 出资方式
     regorg string 300 登记机关
     entstatus string 100 企业状态
     enttype string 300 企业（机构）类型
     congrocur string 300 认缴出资币种
     regcapcur string 100 注册资本币种
     regorgcode string 100 注册地址行政区编号
     creditcode string 300 统一社会信用代码
     filiations array[object] 分支机构
     brname string 600 分支机构名称
     brregno string 300 分支机构企业注册号
     brncreditcode string 300 分支机构统一社会信用代码
     brnregorg string 300 分支机构登记机关
     frinvs array[object] 企业法定代表人对外投资信
    息
     regno string 100 注册号
     creditcode string 300 统一社会信用代码
     enttype string 300 企业（机构）类型
     regcap string 100 注册资本（企业:万元）
     entstatus string 100 企业状态
     regorg string 300 登记机关
     regorgcode string 100 注册地址行政区编号
     subconam string 100 认缴出资额（万元）
     currency string 300 认缴出资币种
     conform string 300 出资方式
     regcapcur string 100 注册资本币种
     esdate string 100 开业日期
     pinvamount string 100 企业总数量
     revdate string 100 吊销日期
     candate string 100 注销日期
     entname string 600 企业(机构)名称
     name string 300 法定代表人姓名
     fundedratio string 300 出资比例
     frpositions array[object] 法定代表人其他公司任职
     regno string 100 注册号
     entname string 600 企业机构名称
     regcap string 100 注册资本（企业:万元）
     esdate string 100 成立日期
     revdate string 100 吊销日期
     candate string 100 注销日期
     regorg string 300 登记机关
     entstatus string 100 企业状态
     position string 100 职务
     enttype string 300 企业（机构）类型
     lerepsign string 300 是否法定代表人
     ppvamount string 300 企业总数量
     regcapcur string 100 注册资本币种
     name string 300 法定代表人姓名
     regorgcode string 100 注册地址行政区编号
     liquidations array[object] 清算信息
     debttranee string 1000 债务承接人
     claimtranee string 600 债权承接人
     ligprincipal string 600 清算负责人
     liqmen string 600 清算组成员
     addr string 2000 地址
     tel string 100 联系电话
     ligst string 300 清算完结情况
     ligenddate string 100 清算完结日期
     mortgagealts array[object] 动产抵押-变更信息
     mabregno string 300 登记编号
     mabaltdate string 100 变更日期
     mabaltdetails string 4000 变更内容
     mortgagebasics array[object] 动产抵押-基本信息
     mabregno string 300 登记编号
     mabregdate string 100 登记日期
     mabregorg string 300 登记机关
     mabguaramt string 2000 被担保债权数额
     mabstatus string 100 状态
     mabgsdate string 100 公示日期
     mortgagecans array[object] 动产抵押-注销信息
     mabregno string 300 登记编号
     mabcandate string 100 注销日期
     mabcanres string 4000 注销原因
     mortgagedebts array[object] 动产抵押-被担保主债权信
    息
     mabregno string 300 登记编号
     mabdebttype string 300 种类
     mabdebtrange string 4000 担保范围
     mabdebtrmk string 2000 备注
     mabdebtamt string 300 数额
     debtsdate string 100 履行债务开始日期
     debtedate string 100 履行债务结束日期
     mortgagepawns array[object] 动产抵押-抵押物信息
     mabregno string 300 登记编号
     mabpawnname string 600 名称
     mabpawnowner string 2000 所有权或使用权归属
     mabpawndetails string 4000 数量、质量、状况、所在地
    等情况
     mabpawnrmk string 2000 备注
     mortgagepers array[object] 动产抵押-抵押人信息
     mabregno string 300 登记编号
     mabpername string 600 抵押权人名称
     mabpercertype string 600 抵押权人证照/证件类型
     mabpercerno string 300 抵押权人证照/证件号码
     mabperdom string 600 所在地
     mortgageregs array[object] 动产抵押-登记信息
     mabregno string 300 登记编号
     mabregdate string 100 登记日期
     mabregorg string 300 登记机关
     mabguaramt string 2000 被担保债权数额
     nodenum string 100 省份代码
     mabguarrange string 4000 担保范围
     mabguartype string 2000 被担保债券种类
     debtsdate string 100 履行债务开始日期
     debtedate string 100 履行债务结束日期
     status string 100 状态
     persons array[object] 主要管理人员
     isFr string 2 是否法人 1.是
    0.否
     entname string 600 企业名称
     pername string 300 人员姓名
     position string 100 职位
     personamount string 100 人员总数量
     punishbreaks array[object] 失信被执行人信息
     type string 1000 失信人类型
     inameclean string 600 被执行人姓名/名称
     publishdateclean string 100 发布时间
     regdateclean string 100 立案时间
     cardnum string 600 身份证号码/工商注册号
     courtname string 2000 执行法院
     gistid string 1000 执行依据文号
     casecode string 1000 案号
     gistunit string 1000 做出执行依据单位
     duty string CLOB 生效法律文书确定的义务
     performance string 1000 被执行人履行情况
     performedpart string 2000 已履行（元）
     unperformpart string 2000 未履行（元）
     disrupttypename string 4000 失信被执行人行为具体情形
     businessentity string 300 法定代表人或者负责人姓名
     areanameclean string 300 省份
     sexyclean string 100 性别
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     ysfzd string 300 身份证原始发证地
     exitdate string 100 退出日期
     casestate string 1000 案件状态
     punisheds array[object] 被执行人信息
     inameclean string 600 被执行人姓名/名称
     casestate string 1000 案件状态
     execmoney string 600 执行标的（元）
     regdateclean string 100 立案时间
     courtname string 2000 执行法院
     casecode string 1000 案号
     type string 1000 被执行人类型
     cardnumclean string 600 身份证号码/企业注册号
     areanameclean string 300 省份
     ysfzd string 300 身份证原始发证地
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     sexyclean string 100 性别
     relatedpunishbreaks array[object] 关联失信被执行人信息
     gistunit string 1000 做出执行依据单位
     duty string CLOB 生效法律文书确定的义务
     performance string 1000 被执行人履行情况
     performedpart string 2000 已履行（元）
     unperformpart string 2000 未履行（元）
     disrupttypename string 4000 失信被执行人行为具体情形
     businessentity string 300 法定代表人或者负责人姓名
     areanameclean string 300 省份
     sexyclean string 100 性别
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     ysfzd string 300 身份证原始发证地
     exitdate string 100 退出日期
     casestate string 1000 案件状态
     type string 1000 失信人类型
     inameclean string 600 被执行人姓名/名称
     publishdateclean string 100 发布时间
     regdateclean string 100 立案时间
     cardnum string 600 身份证号码/工商注册号
     courtname string 2000 执行法院
     gistid string 1000 执行依据文号
     casecode string 1000 案号
     relatedpunisheds array[object] 关联被执行人信息
     courtname string 2000 执行法院
     casecode string 1000 案号
     type string 1000 被执行人类型
     cardnumclean string 600 身份证号码/企业注册号
     areanameclean string 300 省份
     ysfzd string 300 身份证原始发证地
     ageclean string 100 年龄
     focusnumber string 300 关注次数
     sexyclean string 100 性别
     inameclean string 600 被执行人姓名/名称
     casestate string 1000 案件状态
     execmoney string 600 执行标的（元）
     regdateclean string 100 立案时间
     shareholders array[object] 股东及出资信息
     condate string 100 出资日期
     subconam string 100 认缴出资额（万元）
     fundedratio string 300 出资比例
     invtype string 100 股东类型
     conform string 300 出资方式
     regcapcur string 100 认缴出资币种
     shaname string 600 股东名称
     country string 300 国别
     sharesfrosts array[object] 股权冻结信息
     froam string 100 冻结金额（万元）
     froauth string 300 冻结机关
     frofrom string 100 冻结起始日期
     frodocno string 4000 冻结文号
     thawauth string 300 解冻机关
     thawdocno string 100 解冻文号
     thawdate string 100 解冻日期
     thawcomment string 4000 解冻说明
     froto string 100 冻结截至日期
     stockpawns array[object] 股权出质信息（新）
     stkpawnregno string 300 登记编号
     stkpawnczper string 300 出质人
     stkpawnczcerno string 600 出质人证件/证件号
     stkpawnczamt string 600 出质股权数额
     stkpawnzqper string 300 质权人姓名
     stkpawnzqcerno string 600 质权人证件/证件号
     stkpawnregdate string 100 质权出质设立登记日期
     stkpawnstatus string 600 状态
     stkpawndate string 100 公示日期
     url string 4000 关联内容
     stockpawnalts array[object] 股权出质信息（新）-变更
    信息
     stkpawnbgnr string 4000 变更内容
     stkpawnbgrq string 100 变更日期
     url string 4000 关联内容
     stockpawnrevs array[object] 股权出质信息（新）-注销
    信息
     url string 4000 关联内容
     stkpawndate string 100 注销日期
     stkpawnres string 4000 注销原因
     yearReportAlters array[object] 年报-修改信息
     ancheid string 300 年报ID
     altitem string 200 修改事项
     altaf string 200 修改后
     altbe string 200 修改前
     altdate string 100 修改日期
     yearReportAlterStock
     s
    array[object] 年报-股权变更信息
     altdate string 100 股权变更日期
     ancheid string 100 年报ID
     inv string 100 股东名称
     transamaft string 100 转让后股权比例
     transampr string 100 转让前股权比例
     yearReportBasics array[object] 年报-企业年报基本信息
     ancheid string 300 年报ID
     addr string 300 地址
     anchedate string 100 年报日期
     ancheyear string 100 年报年份
     busst string 100 经营状态
     creditno string 100 统一信用代码
     email string 100 电子邮箱
     entname string 100 企业名称
     postalcode string 100 邮政编码
     regno string 100 注册号
     tel string 100 电话
     yearReportForGuarant
     ees
    array[object] 年报-企业对外提供保证担
    保信息
     ancheid string 300 年报ID
     gatype string 100 保证的方式
     guarapperiod string 100 保证的期间
     more string 100 债权人
     mortgagor string 100 债务人
     pefperform string 100 履行债务的期限自
     pefperto string 100 履行债务的期限至
     priclasecam string 100 主债权数额
     priclaseckind string 100 主债权种类
     rage string 200 保证担保的范围
     yearReportForInvs array[object] 年报-企业对外投资信息
     ancheid string 300 年报ID
     creditno string 100 统一信用代码
     entname string 100 企业名称
     regno string 100 注册号
     yearReportPaidUpCapi
     tals array[object] 年报-企业实缴出资信息
     ancheid string 300 年报ID
     condate string 100 实缴出资日期
     conform string 100 出资方式
     currency string 100 币种
     inv string 100 股东/发起人
     liacconam string 100 累计实缴额（万元）
     yearReportSocSecs array[object] 年报-社会保险信息
     ancheid string 300 年报ID
     so110 string 100 城镇职工基本养老保险参保
    人数
     so210 string 100 失业保险参保人数
     so310 string 100 职工基本医疗保险参保人数
     so410 string 100 工伤保险参保人数
     so510 string 100 生育保险参保人数
     totalpaymentso110 string 100 参加城镇职工基本养老保险
    本期实际缴费金额
     totalpaymentso210 string 100 参加失业保险本期实际缴费
    金额
     totalpaymentso310 string 100 参加职工基本医疗保险本期
    实际缴费金额
     totalpaymentso410 string 100 参加工伤保险本期实际缴费
    金额
     totalpaymentso510 string 100 参加生育保险本期实际缴费
    金额
     totalwagesso110 string 200 单位参加城镇职工基本养老
    保险缴费基数
     totalwagesso210 string 200 单位参加失业保险缴费基数
     totalwagesso310 string 200 单位参加职工基本医疗保险
    缴费基数
     totalwagesso410 string 200 单位参加工伤保险缴费基数
     totalwagesso510 string 200 单位参加生育保险缴费基数
     unpaidsocialinsso1
     10 string 100 单位参加城镇职工基本养老
    保险累计欠缴金额
     unpaidsocialinsso2
     10 string 100 单位参加失业保险累计欠缴
    金额
     unpaidsocialinsso3
     10 string 100 单位参加职工基本医疗保险
    累计欠缴金额
     unpaidsocialinsso4
     10 string 100 参加工伤保险累计欠缴金额
     unpaidsocialinsso5
     10 string 100 单位参加生育保险累计欠缴
    金额
     yearReportSubCapital
     s
    array[object] 年报-认缴出资信息
     ancheid string 300 年报ID
     condate string 100 认缴出资日期
     conform string 200 出资方式
     currency string 100 出资币种
     inv string 100 投资人/发起人
     lisubconam string 100 累计认缴额
     yearReportWebSiteInf
     os
    array[object] 年报-网站信息
     ancheid string 300 年报ID
     domain string 200 网站（网店）地址
     websitname string 200 网站（网店）名称
     webtype string 100 网站（网店）类型
     managerPositions array[object] 高管在外任职
     position string 100 职务
     entname string 100 企业名称
     lerepsign boolean 是否法人
     name string 100 姓名
     entstatus string 100 企业状态
     managerPersoninvs array[object] 高管对外投资
     entnameInv string 200 投资公司
     name string 100 姓名
     country string 100 国家
     currency string 100 币种
     subconam string 100 认缴出资额
     acconam string 100 实缴出资额
     conprop string 100 出资比例
     conform string 100 出资方式
     condate string 100 出资日期
     entstatus string 100 企业状态
     invpersoninvs array[object] 股东对外投资
     entnameInv string 200 投资公司
     name string 100 姓名
     country string 100 国家
     currency string 100 币种
     subconam string 100 认缴出资额
     acconam string 100 实缴出资额
     conprop string 100 出资比例
     conform string 100 出资方式
     condate string 100 出资日期
     entstatus string 100 企业状态
     invpositions array[object] 股东在外任职
     entname string 200 公司名称
     name string 100 姓名
     position string 100 职务
     lerepsign boolean 是否法人
     entstatus string 100 企业状态
```

## **<a name="monitorGroupAdd"> 企业工商信息变更监控</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/monitor/group/add", // Y 请求地址
        "groupName":"元素征信", // Y 监控组名称
        "period":"12", // N 监控周期 月
        "monitoringNodes":[ // N 监控节点 格式如：["basic","frinvs.fundedratio","frinvs.subconam"]
            "basic.entname",
            "basic.entno",
            "frinvs"
        ]
    }

```

#### 返回结果
```javascript
    {
        "msg": "保存成功",
        "code": "000",
        "data": {
            "groupName": "元素征信", //监控组名称
            "period": 7, //周期
            "updateDate": "2018-12-24", //更新日期
            "monitoringNodes": [ //监控节点
                "relatedpunishbreaks",
                "shareholders",
                "filiations",
                "mortgagecans",
                "punisheds",
                "frinvs",
                "frpositions",
                "relatedpunisheds",
                "sharesfrosts",
                "mortgagebasics",
                "mortgagepers",
                "stockpawns",
                "mortgagedebts",
                "persons",
                "mortgagepawns",
                "entcasebaseinfos",
                "entinvs",
                "punishbreaks",
                "stockpawnrevs",
                "stockpawnalts",
                "mortgageregs",
                "basic",
                "mortgagealts"
            ],
            "groupId": "526696381792911360", //监控组ID
            "nextCheckDate": "2018-12-31", //下次更新日期
            "noticeType": 1, //通知类型
            "pushAddress": "", //推送地址
            "createDate": "2018-12-24",
            "pushType": 1 //推送类型
        }
    }
```

## **<a name="companyLevel"> 企业大中小微划型服务</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/companyLevel", // Y 请求地址
        "key":"包头市中诚信矿业技术服务有限公司" // Y 关键词
    }

```

#### 返回结果
```javascript
    {
        "msg": "保存成功",
        "code": "000",
        "data": {
            "level":"大型" //企业级别
        }   
    }
```

## **<a name="getLaunderInfo">  企业工商反洗钱查询接</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/getLaunderInfo", // Y 请求地址
        "entName":"北京市XXX有限公司", // N 企业名称
        "regNo":"", // N 工商注册号
        "creditCode":"", // N 统一社会信用代码
        "orgCode":"" // N 组织机构代码
    }

```

#### 返回结果
```javascript
    {
      "msg":"查询成功",
      "code":"000",
      "data":{
        "invs":[
          {
            "finalentname":"XX", //受益人姓名
            "finalacconam":"-", //最终实缴
            "address":"北京市XX区北四环中路A座19E", //地址
            "certype":"P01", // 证件类型
            "finalratio":"77.8%", // 最终占比
            "ratioroad":"77.8%", // 出资计算过程
            "capitalchain":"XX -> XX科技有限责任公司", // 出资链
            "position":"经理 董事长", // 职位
            "finalsubconam":"-" // 最终认缴
          }
        ],
        "road":{ //关系
          "children":[ //子节点关系
            {
              "conprop":"0", // 上级节点投资比例
              "address":"上海市XX区南昌路11号", //地址
              "certype":"P01", // 证件类型
              "children":[], // 子节点关系
              "name":"XX", // 节点名称
              "position":"董事", // 职位
              "tags":"4" // 节点类型
            }
          ],
          "name":"XX科技有限责任公司", //节点名称
          "tags":"1" // 节点类型
        }
      }
    }
```

## **<a name="monitorSaasInvAdd">  企业工商反洗钱变更监控</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/monitor/saasInv/add", // Y 请求地址
        "entName":"北京市XXX有限公司", // Y 企业名称
        "regNo":"" // N 工商注册号
    }

```

#### 返回结果
```javascript
    {
      "msg":"查询成功",
      "code":"000",
      "data":{
        "regNo":"440000000021704", //注册号
        "entName":"中国南方电网有限责任公司" // 企业名称
      }   
    }
```

## **<a name="multipleRelation">  企业多点关联查询</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/multipleRelation", // Y 请求地址
        "entName":"北京市XXX有限公司", // N 企业名称
        "entId":"310101000175160,051178176", // N 企业标识
        "idNo":"11020819621216311X", // N 身份证号码
        "depth":"", // N 关联层次
        "weight":"" // N 工商注册号 优先方式 1.路径优先 2.占比优先 默认1
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "nodes": [//节点
                {
                    "name": "xx有限责任公司上海分公司",// 名称
                    "id": "ZSIPZovzYkO", // 唯一标识
                    "type": "1" // 节点类型 1 企业 4 个人
                }
            ],
            "edges": [//关系
                {
                    "source": "nV3HGznvzw",//起始节点
                    "relation": "投资(77.8%)",//关系类型
                    "target": "ZeVtUVTkcmO"//目标节点
                }
            ]
        }
    }
```

## **<a name="getIndexScoreOpe">  企业多维智能评分查询</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/invoice/getIndexScore/ope", // Y 请求地址
        "entName":"北京市XXX有限公司", // N 企业名称
        "regNo":"", // N 注册号
        "orgCode":"", // N 组织机构代码
        "creditCode":"", // N 社会统一信用代码
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "ope":{ 
                "scoreOpe":"1231" // 运营能力评分
             }
        }
    }
```

## **<a name="invoiceGetIndex">  企业深度画像-经营分析</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/invoice/getIndex", // Y 请求地址
        "entName":"北京市XXX有限公司", // N 企业名称
        "regNo":"", // N 注册号
        "orgCode":"", // N 组织机构代码
        "creditCode":"", // N 社会统一信用代码
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "increaseRateRevenue": "0.2135210150674068",
            "netProfitMarginCityRank": "0.03429587602675925",
            "operatingMargin": "0.5559410642439615",
            "revenueToAssetsCityRank": "0.9618788291354663",
            "entName": "",
            "totalAssets": "1.74827E+7",
            "equity": "7460200.0",
            "rankRateModifyLocationCity": "1.0",
            "progro": "200772.0",
            "equityCityRank": "0.0006180469715698393",
            "rateModifyOperation": "0.0",
            "empNum": "",
            "rankRateModifyOperationCity": "1.0",
            "revenueToLiability": "0.03603282614118234",
            "amtInvestRegcapCompany": "11511234.308100002",
            "netProfitCityRank": "0.0012991512212021479",
            "liagro": "1.00225E+7",
            "nInvestRevPerson": "",
            "totalAssetsCityRank": "0.0002396740433011105",
            "reccapCityPprRank": "1.0",
            "roaCityRank": "0.20169964937303145",
            "revenueToAssets": "0.02065693514159712",
            "salesRevenue": "361139.0",
            "esDate": "1049090400000",
            "increaseRateNetProfitCityRank": "0.6737385321100917",
            "increaseRateRevenueCityRank": "0.5668459852560271",
            "maibusinc": "361139.0",
            "revenueToEquity": "0.0484087557974317",
            "roe1CityRank": "0.4231186966640807",
            "nInvestCompanyPerson": "",
            "liabilityToAssetsCityRank": "0.7877176015473888",
            "reccapToRevenue": "0.0",
            "roa": "0.01148403850663799",
            "equityToAssetsCityRank": "0.2094727435210009",
            "revenueToEquityCityRank": "0.934878587196468",
            "increaseRateProfit": "-0.8099235990797807",
            "reccapToAssets": "0.0",
            "nSuperAlarmCompany": "",
            "esdateCityOprRank": "0.732034552471972",
            "nInvestRevCompany": "0",
            "salesRevenueCityRank": "0.0037292349418013336",
            "reccapToAssetsCityRank": "1.0",
            "rateModifyPerson": "0.11764705882352941",
            "liabilityToAssets": "0.573281014946204",
            "netinc": "200772.0",
            "equityToAssets": "0.426718985053796",
            "roe1": "0.02691241521675022",
            "amtInvestRegcapPerson": "",
            "roe2": "0.02691241521675022",
            "rankRateModifyPersonCity": "0.524390243902439",
            "grossProfitMarginCityRank": "0.037533967391304345",
            "nCaseLesscreditPerson": "",
            "regcapCityOprRank": "0.0013559322033898306",
            "revenueToLiabilityCityRank": "0.9371589358799455",
            "nCaseLesscreditCompany": "",
            "nSuperAlarmPerson": "",
            "debtToAssetsCityRank": "0.47505584512285925",
            "netProfitMargin": "0.5559410642439615",
            "grossProfitMargin": "0.5559410642439615",
            "nInvestCompany": "49",
            "rateModifyLocation": "0.0",
            "regcap": "3500000.0",
            "amtInvestReccapCompany": "11511234.308100002",
            "increaseRateProfitCityRank": "0.6737267967634459",
            "roe2CityRank": "0.4618774790656677",
            "entStatus": "1",
            "amtInvestReccapPerson": "",
            "reccapToRevenueCityRank": "0.99800796812749",
            "operatingMarginCityRank": "0.037533967391304345",
            "increaseRateNetProfit": "-0.8099235990797807"
        }
    }
```

#### 返回结果
``` javascript
     entName string 企业名称
     entStatus string 企业状态
     esDate string 注册时间
     regcap string 注册资本
     empNum string 从业人数
     totalAssets string 资产总额
     liagro string 负债总额
     salesRevenue string 营业收入
     maibusinc string 主营业务收入
     progro string 利润总额
     netinc string 净利润
     equity string 所有者权益
     roa string 资本报酬率
     operatingMargin string 营业利润率
     netProfitMargin string 净利润率
     roe1 string 净资产收益率（净利润）
     roe2 string 净资产收益率（营业利润）
     revenueToEquity string 营业收入/所有者权益
     grossProfitMargin string 毛利率
     reccapToAssets string 净运营资本/总资产(实缴资本代替)
     reccapToRevenue string 净运营资本/营业收入(实缴资本代替)
     revenueToLiability string 营业收入/总债务
     liabilityToAssets string 总债务/（总债务＋总权益）
     equityToAssets string 所有者权益/总资产
     revenueToAssets string 营业收入/资产总额
     increaseRateRevenue string 营业收入增长率
     increaseRateProfit string 营业利润增长率
     increaseRateNetProfit string 净利润增长率
     operatingMarginCityRank string 同行业营业利润率排名（市）
     roaCityRank string 同行业资本报酬率排名（市）
     netProfitMarginCityRank string 同行业净利润率排名（市）
     roe1CityRank string 同行业净资产收益率（净利润）排名（市）
     roe2CityRank string 同行业净资产收益率（营业利润）排名（市）
     revenueToEquityCityRank string 同行业营业收入/所有者权益排名（市）
     grossProfitMarginCityRank string 同行业毛利率排名（市）
     reccapToAssetsCityRank string 同行业净运营资本/总资产排名（市）
     reccapToRevenueCityRank string 同行业净运营资本/营业收入排名（市）
     revenueToLiabilityCityRank string 同行业营业收入/总债务排名（市）
     totalAssetsCityRank string 同行业总资产排名（市）
     salesRevenueCityRank string 同行业营业收入排名（市）
     equityCityRank string 同行业所有者权益排名（市）
     netProfitCityRank string 同行业净利润排名（市）
     liabilityToAssetsCityRank string 同行业总债务/（总债务＋总权益）排名（市）
     debtToAssetsCityRank string 同行业资本负债率排名（市）
     equityToAssetsCityRank string 同行业所有者权益/总资产合计排名（市）
     revenueToAssetsCityRank string 同行业营业收入/资产总额排名（市）
     increaseRateRevenueCityRank string 同行业营业收入增长率排名市）
     increaseRateProfitCityRank string 同行业营业利润增长率排名（市）
     increaseRateNetProfitCityRank string 同行业净利润增长率排名（市）
     nInvestCompany string 公司对外投资企业数
     nInvestRevCompany string 公司对外投资企业吊销数
     amtInvestRegcapCompany string 公司对外投资企业注册资本总和
     amtInvestReccapCompany string 公司对外投资企业实际缴纳资本总和
     nCaseLesscreditCompany string 公司对外投资企业失信被执行人次数
     nSuperAlarmCompany string 公司对外投资企业行政处罚次数
     nInvestCompanyPerson string 董监高对外投资企业数
     nInvestRevPerson string 董监高对外投资企业吊销数
     amtInvestRegcapPerson string 董监高对外投资企业注册资本总和
     amtInvestReccapPerson string 董监高对外投资企业实际缴纳资本总和
     nCaseLesscreditPerson string 董监高对外投资企业失信被执行人次数
     nSuperAlarmPerson string 董监高对外投资企业行政处罚次数
     esdateCityOprRank string 同行业内注册时间在营企业排名（市）
     regcapCityOprRank string 同行业在营企业注册资本排名（市）
     reccapCityPprRank string 同行业在营企业实缴资本排名（市）
     rateModifyPerson string 股东或法人变化次数/年份
     rankRateModifyPersonCity string 同行业股东或法人变化次数/年份排名（市）
     rateModifyOperation string 经营范围或行业变更次数/年份
     rankRateModifyOperationCity string 同行业经营范围或行业变更/年份排名（市）
     rateModifyLocation string 经营场所或登记机关变更次数/年份
     rankRateModifyLocationCity string 同行业经营场所或登记机关变更次数/年份排名（市）
```

## **<a name="enterpriseEcoPort_A">  企业深度画像-交易分析</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/enterprise/ecoPort_A", // Y 请求地址 四选一
        "entName":"北京市XXX有限公司", // N 企业名称 四选一
        "regNo":"", // N 注册号 四选一
        "orgCode":"", // N 组织机构代码 四选一
        "creditCode":"", // N 社会统一信用代码 四选一
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "enterTaxRisk": {
                "ulsEnterExe": {
                    "usExeAmtPer": "56.29%",
                    "usExeCntPer": "32.45%",
                    "lsExeCntPer": "28.21%",
                    "lsExeAmtPer": "35%"
                },
                "ulsEnterLost": {
                    "usLcreditAmtPer": "3.42%",
                    "lsLcreditAmtPer": "3.87%",
                    "lsLcreditCntPer": "2.13%",
                    "usLcreditCntPer": "3.54%"
                },
                "uLsEnterCase": {
                    "usLawCntPerExcCC": "5.16%",
                    "lsLawAmtPerExcCC": "0.08%",
                    "lsLawAmtPer": "68.99%",
                    "usLawAmtPerExcCC": "5.52%",
                    "lsLawCntPer": "62.61%",
                    "usLawAmtPer": "80.91%",
                    "lsLawCntPerExcCC": "2.03%",
                    "usLawCntPer": "62.39%"
                },
                "enterLsRisk": {
                    "xCntPerOpen": "30.84%",
                    "invalidCntPerOpen": "10.85%",
                    "redCntPerOpen": "2.67%",
                    "xAmtPerOpen": "62.65%",
                    "redAmtPerOPen": "3.39%",
                    "invalidAmtPerOpen": "12.6%"
                }
            },
            "enterOperate": {
                "enterMonthPro": {
                    "isHighJan": "1",
                    "isHighNov": "1",
                    "isHighJune": "",
                    "isHighMar": "1",
                    "isHighApr": "0",
                    "isHighOct": "",
                    "isHighMay": "0",
                    "isHighJuly": "",
                    "isHighAug": "0",
                    "isHighSept": "",
                    "isHighFeb": "",
                    "isHighDec": "0"
                },
                "enterQuaPro": {
                    "isHighQ1": "",
                    "isHighQ2": "",
                    "isHighQ3": "0",
                    "isHighQ4": ""
                },
                "enterProfit": {
                    "isHigh": ""
                }
            },
            "ulsEnter": {
                "lsGroupEnter": {
                    "lsGcCntPer": "",
                    "lsGcAmtPer": ""
                },
                "usBcEnter": {
                    "usBcAmtPer": "",
                    "usBcCntPer": ""
                },
                "lsBcEnter": {
                    "lsBcCntPer": "",
                    "lsBcAmtPer": ""
                },
                "usOsEnter": {
                    "usOsCntPer": "",
                    "usOsAmtPer": ""
                },
                "lsOsEnter": {
                    "lsOsAmtPer": "",
                    "lsOsCntPer": ""
                },
                "usGroupEnter": {
                    "usGcAmtPer": "",
                    "usGcCntPer": ""
                },
                "lsNaEnter": {
                    "lsSoeAmtPer": "0%",
                    "lsSoeCntPer": "0.43%"
                },
                "lsLargeEnter": {
                    "lsLcCntPer": "22.22%",
                    "sLcAmtPer": "27.51%"
                },
                "lsMidEnter": {
                    "lsMcCntPer": "15.25%",
                    "lsMcAmtPer": ""
                },
                "usLargeEnter": {
                    "usLcCntPer": "8.74%",
                    "usLcAmtPer": "9.72%"
                },
                "usListEnter": {
                    "usListAmtPer": "81.74%",
                    "usListCntPer": "59.52%"
                },
                "usMidEnter": {
                    "usMcCnt": "785",
                    "usMcAmtPer": "42.08%"
                },
                "lsListEnter": {
                    "lsListAmtPer": "67.09%",
                    "lsListCntPer": "62.96%"
                },
                "usNaEnter": {
                    "usSoeCntPer": "0.04%",
                    "usSoeAmtPer": "0%"
                }
            }
        }
    }
```

#### 返回结果
``` javascript
      ulsEnter object 上下游企业信息查询
      usNaEnter object 上游国有企业查询
      usSoeAmtPer string 上游国有企业交易金额占比
      usSoeCntPer string 上游国有企业交易笔数占比
      lsNaEnter object 下游国有企业查询
      lsSoeAmtPer string 下游国有企业交易金额占比
      lsSoeCntPer string 下游国有企业交易笔数占比
      usListEnter object 上游上市企业查询
      usListAmtPer string 上游上市公司交易金额占比
      usListCntPer string 上游上市公司交易笔数占比
      lsListEnter object 下游上市企业查询
      lsListAmtPer string 下游上市公司交易金额占比
      lsListCntPer string 下游上市公司交易笔数占比
      usLargeEnter object 上游大型企业查询
      usLcAmtPer string 上游大型企业交易金额占比
      usLcCntPer string 上游大型企业交易笔数占比
      lsLargeEnter object 下游大型企业查询
      sLcAmtPer string 下游大型企业交易金额占比
      lsLcCntPer string 下游大型企业交易笔数占比
      usMidEnter object 上游中型企业查询
      usMcAmtPer string 上游中型企业交易金额占比
      usMcCnt string 上游中型企业交易笔数
      lsMidEnter object 下游中型企业查询
      lsMcAmtPer string 下游中型企业交易金额占比
      lsMcCntPer string 下游中型企业交易笔数占比
      usGroupEnter object 上游集团企业（母公司、子公司、控股50%及以上的公司）查询
      usGcCntPer string 上游企业为集团公司交易笔数占比
      usGcAmtPer string 上游企业为集团公司交易金额占比
      lsGroupEnter object 下游集团企业（母公司、子公司、控股50%及以上的公司）查询
      lsGcCntPer string 下游企业为集团公司交易笔数占比
      lsGcAmtPer string 下游企业为集团公司交易金额占比
      usBcEnter object 上游总公司/分公司查询
      usBcCntPer string 上游企业为总公司/分公司交易笔数占比
      usBcAmtPer string 上游企业为总公司/分公司交易金额占比
      lsBcEnter object 下游总公司/分公司查询
      lsBcCntPer string 下游企业为总公司/分公司交易笔数占比
      lsBcAmtPer string 下游企业为总公司/分公司交易金额占比
      usOsEnter object 有直接股权关系上游企业查询
      usOsCntPer string 有直接股权关系的上游企业交易笔数占比
      usOsAmtPer string 有直接股权关系的上游企业交易金额占比
      lsOsEnter object 有直接股权关系下游企业查询
      lsOsCntPer string 有直接股权关系的下游企业交易笔数占比
      lsOsAmtPer string 有直接股权关系的下游企业交易金额占比
      enterTaxRisk object 企业税务风险信息查询
      enterLsRisk object 企业与下游企业疑似风险交易情况
      redCntPerOpen string 冲正交易次数占比
      redAmtPerOPen string 冲正交易金额占比
      invalidCntPerOpen string 无效交易次数占比
      invalidAmtPerOpen string 无效交易金额占比
      xCntPerOpen string 疑似虚假交易次数占比
      xAmtPerOpen string 疑似虚假交易金额占比
      uLsEnterCase object 与上下游企业有诉讼关系情况
      usLawCntPerExcCC string 与上游企业有诉讼关系（不含已结案）数量占比
      usLawAmtPerExcCC string 与上游企业有诉讼关系（不含已结案）金额占比
      lsLawCntPerExcCC string 与下游企业有诉讼关系（不含已结案）数量占比
      lsLawAmtPerExcCC string 与下游企业有诉讼关系（不含已结案）金额占比
      usLawCntPer string 与上游企业有诉讼关系（含已结案）数量占比
      usLawAmtPer string 与上游企业有诉讼关系（含已结案）金额占比
      lsLawCntPer string 与下游企业有诉讼关系（含已结案）数量占比
      lsLawAmtPer string 与下游企业有诉讼关系（含已结案）金额占比
      ulsEnterLost object 上下游企业失信被执行人情况
      usLcreditCntPer string 上游企业失信被执行人占比（数量）
      usLcreditAmtPer string 上游企业失信被执行人占比（金额）
      lsLcreditCntPer string 下游企业失信被执行人占比（数量）
      lsLcreditAmtPer string 下游企业失信被执行人占比（金额）
      ulsEnterExe object 上下游企业被执行人情况
      usExeCntPer string 上游企业被执行人占比（数量）
      usExeAmtPer string 上游企业被执行人占比（金额）
      lsExeCntPer string 下游企业被执行人占比（数量）
      lsExeAmtPer string 下游企业被执行人占比（金额）
      usOftQuery object 上游企业频繁查询
      usSameCompCount2CntPer string 近一年上游同一企业交易次数为2次（含）以上的企业数量占比
      usSameCompCount2AmtPer string 近一年上游同一企业交易次数为2次（含）以上的企业交易金额占比
      usSameCompCount5CntPer string 近一年上游同一企业交易次数为5次（含）以上的企业数量占比
      usSameCompCount5AmtPer string 近一年上游同一企业交易次数为5次（含）以上的企业交易金额占比
      usSameCompCount10CntPer string 近一年上游同一企业交易次数为10次（含）以上的企业数量占比
      usSameCompCount10AmtPer string 一年下游同一企业交易次数为10次（含）以上的企业交易金额占比
      lsOftQuery object 下游企业频繁查询
      lsSameCompCount2CntPer string 近一年上游同一企业交易次数为2次（含）以上的企业数量占比
      lsSameCompCount2AmtPer string 近一年上游同一企业交易次数为2次（含）以上的企业交易金额占比
      lsSameCompCount5CntPer string 近一年上游同一企业交易次数为5次（含）以上的企业数量占比
      lsSameCompCount5AmtPer string 近一年上游同一企业交易次数为5次（含）以上的企业交易金额占比
      lsSameCompCount10CntPer string 近一年上游同一企业交易次数为10次（含）以上的企业数量占比
      lsSameCompCount10AmtPer string 近一年下游同一企业交易次数为10次（含）以上的企业交易金额占比
      enterOperate object 企业经营情况查询
      enterProfit object 企业年度盈利情况
      isHigh string 近一年进项金额是否大于出项金额
      enterMonthPro object 企业月度盈利情况
      isHighJan string 1月企业进项金额是否大于出项金额
      isHighFeb string 2月企业进项金额是否大于出项金额
      isHighMar string 3月企业进项金额是否大于出项金额
      isHighApr string 4月企业进项金额是否大于出项金额
      isHighMay string 5月企业进项金额是否大于出项金额
      isHighJune string 6月企业进项金额是否大于出项金额
      isHighJuly string 7月企业进项金额是否大于出项金额
      isHighAug string 8月企业进项金额是否大于出项金额
      isHighSept string 9月企业进项金额是否大于出项金额
      isHighOct string 10月企业进项金额是否大于
      isHighNov string 11月企业进项金额是否大于出项金额
      isHighDec string 12月企业进项金额是否大于出项金额
      enterQuaPro object 企业季度盈利情况
      isHighQ1 string 第一季度企业进项金额是否大于出项金额
      isHighQ2 string 第2季度企业进项金额是否大于出项金额
      isHighQ3 string 第3季度企业进项金额是否大于出项金额
      isHighQ4 string 第4季度企业进项金额是否大于出项金额
```

## **<a name="enterpriseFuzzyQuery"> 司法数据查询（模糊）</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/risk/enterprise/fuzzyQuery", // Y 请求地址
        "keyword":"XX",// Y 关键词 关键词长度不能小于2
        "dataType":"ktgg", // N 数据类型 cpws 裁判文书 zxgg 执行公告 shixin 失信公告 ktgg 开庭公告 fygg 法院公告 ajlc 案件流程信息 bgt 曝光台
        "pageNum":"10",
        "pageSize":"1"
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "ajlcCount": "9", //案件流程信息数量
            "zxggCount": "7", //执行公告信息数量
            "cpwsCount": "4", //裁判文书信息数量
            "fyggCount": "0", //法院公告信息数量
            "count": "25",
            "pageSize": "20",
            "entryList": [ // 被查询企业
                {
                    "sortTimeString": "2019年03月20日", //审结时间
                    "sortTime": "1553011200000", //审结时间 
                    "dataType": "zxgg", //数据类型
                    "body": "...公司 被执行人 ： 深圳市瑞赛尔再生资源有限公司...", //内容概要
                    "title": "案号：（2019）粤0303执4960号",
                    "entryId": "tl_c2019440303zhi4960_t20190320_pszsrsezszyyxgs@cG5hbWU65rex5Zyz5biC55Ge6LWb5bCU5YaN55Sf6LWE5rqQ5pyJ6ZmQ5YWs5Y%2B4" //详情ID
                }
            ],
            "ktggCount": "4", //开庭公告信息数量
            "bgtCount": "0", //曝光台信息数量
            "pageNum": "1",
            "shixinCount": "1" //失信公告信息数量
        }
    }

```

## **<a name="enterpriseKeyword"> 司法数据查询（精准）</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/risk/enterprise/keyword", // Y 请求地址
        "enterpriseName":"清河县xx制品有限公司",// Y 企业名称
        "dataType":"cpws", // N 数据类型 cpws 裁判文书 zxgg 执行公告 shixin 失信公告 ktgg 开庭公告 fygg 法院公告 ajlc 案件流程信息 bgt 曝光台
        "pageNum":"10",
        "pageSize":"1"
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "ajlcCount": "9", //案件流程信息数量
            "zxggCount": "7", //执行公告信息数量
            "cpwsCount": "4", //裁判文书信息数量
            "fyggCount": "0", //法院公告信息数量
            "count": "25",
            "pageSize": "20",
            "entryList": [ // 被查询企业
                {
                    "sortTimeString": "2019年03月20日", //审结时间
                    "sortTime": "1553011200000", //审结时间 
                    "dataType": "zxgg", //数据类型
                    "body": "...公司 被执行人 ： 深圳市瑞赛尔再生资源有限公司...", //内容概要
                    "title": "案号：（2019）粤0303执4960号",
                    "entryId": "tl_c2019440303zhi4960_t20190320_pszsrsezszyyxgs@cG5hbWU65rex5Zyz5biC55Ge6LWb5bCU5YaN55Sf6LWE5rqQ5pyJ6ZmQ5YWs5Y%2B4" //详情ID
                }
            ],
            "ktggCount": "4", //开庭公告信息数量
            "bgtCount": "0", //曝光台信息数量
            "pageNum": "1",
            "shixinCount": "1" //失信公告信息数量
        }
    }

```

## **<a name="addressSearch"> 地址标准化查询</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/address/search", // Y 请求地址
        "keywords":"美食"// Y 关键词 多个关键字用“|”分割
    }

```

#### 返回结果
```javascript
   {
       "msg": "查询成功",
       "code": "000",
       "data": {
           "list": [
               {
                   "adName": "海淀区",
                   "address": "甘家口小区21号楼(近三里河路)",
                   "cityName": "北京市",
                   "pName": "北京市",
                   "name": "柴氏风味斋(甘家口店)",
                   "location": "116.331047,39.926575",
                   "tel": "010-88385108",
                   "type": "餐饮服务;中餐厅;清真菜馆"
               },
               {
                   "adName": "西城区",
                   "address": "护国寺街乙75号",
                   "cityName": "北京市",
                   "pName": "北京市",
                   "name": "褡裢火烧(护国寺店)",
                   "location": "116.376162,39.935165",
                   "tel": "010-83220618;010-83282028",
                   "type": "餐饮服务;中餐厅;特色/地方风味餐厅"
               }
           ]
       }
   }

```

## **<a name="personSearch"> 个人工商信息查询</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/saic/person", // Y 请求地址
        "certNo":"110111199901120600"// Y 身份证号或护照号
    }

```

#### 返回结果
```javascript
   {
       "msg": "查询成功",
       "code": "000",
       "data": {
           "ryposfrs": [
               {
                   "esdate": "2012-07-16",
                   "regno": "521721611037998",
                   "creditcode": "91521727MW6GQ5C55K",
                   "entname": "xx县xxx店",
                   "enttype": "个体",
                   "regcap": "3.500000",
                   "palgorithmid": "V1!AfWQCy0F/XYnBxUPbsWBzopwur43QcoWhS9/9UTrVtw7B/3WKvOc0soQ0r6AvcTOmjHrPx7g9bMD<n>tpwbtMx7yw==",
                   "ryname": "xxx",
                   "regorgprovince": "贵州省",
                   "industryphyname": "批发和零售业",
                   "entstatus": "在营（开业）",
                   "regcapcur": "人民币元"
               }
           ],
           "entcaseinfos": [],
           "punisheds": [],
           "punishbreaks": []
       }
   }
```

#### 返回数据参数说明
``` javascript
    entcaseinfos array[object] 行政处罚信息
     creditcode string 300 统一社会信用代码
     illegacttype string 4000 主要违法事实
     penauth string 300 处罚机关
     penauthcn string 600 处罚机关名称
     pencontent string 4000 行政处罚内容
     pendecissdate string 100 处罚决定书签发日期
     pendecno string 600 处罚决定文书
     pentype string 4000 处罚种类
     pentypecn string 4000 处罚种类名称
     publicdate string 100 公示日期
     unitname string 600 当事人名称
     punishbreaks array[object] 人员失信被执行人
     ageclean string 100 年龄
     areanameclean string 300 省份
     businessentity string 300 法定代表人/负责人姓名
     cardnum string 600 身份证号码/工商注册号
     casecode string 1000 案号
     courtname string 2000 执行法院
     disrupttypename string 4000 失信被执行人行为具体情形
     duty string CLOB 生效法律文书确定的义务
     exitdate string 100 退出日期
     focusnumber string 300 关注次数
     gistid string 1000 执行依据文号
     gistunit string 1000 做出执行依据单位
     inameclean string 600 被执行人姓名 /名称
     performance string 1000 被执行人的履行情况
     performedpart string 2000 已履行 ( 元 )
     publishdateclean string 100 发布时间
     regdateclean string 100 立案时间
     sexyclean string 100 性别
     type string 1000 失信人类型
     unperformpart string 2000 未履行 ( 元 )
     ysfzd string 300 身份证原始发证地
     punisheds array[object] 人员被执行人
     ageclean string 100 年龄
     areanameclean string 300 省份
     cardnumclean string 600 身份证号码 /企业注册号
     casecode string 1000 案号
     casestate string 1000 案件状态
     courtname string 2000 执行法院
     execmoney string 600 执行标的(元)
     focusnumber string 300 关注次数
     inameclean string 600 被执行人姓名/名称
     regdateclean string 100 立案时间
     sexyclean string 100 性别
     type string 1000 被执行人类型
     ysfzd string 300 身份证原始发证地
     ryposfrs array[object] 人员法人信息
     ryname string 300 查询人姓名
     creditcode string 300 统一社会信用代码
     entname string 600 企业(机构)名称
     entstatus string 100 企业状态
     enttype string 300 企业(机构)类型
     esdate string 100 成立时间
     industryphyname string 100 行业名称
     palgorithmid string 200 个人标识码
     regcap string 100 注册资本(企业:万元)
     regcapcur string 100 注册资本币种
     regno string 100 注册号
     regorgprovince string 100 省份
     rypospers array[object] 人员高管信息
     ryname string 300 查询人姓名
     creditcode string 300 统一社会信用代码
     entname string 600 企业 (机构 )名称
     entstatus string 100 企业状态
     enttype string 300 企业 (机构 )类型
     esdate string 100 成立时间
     industryphyname string 100 行业名称
     palgorithmid string 200 个人标识码
     position string 100 职务
     regcap string 100 注册资本 (企业 :万元 )
     regcapcur string 100 注册资本币种
     regno string 100 注册号
     regorgprovince string 100 省份
     ryposshas array[object] 人员股东信息
     ryname string 300 查询人姓名
     entname string 600 企业(机构)名称
     creditcode string 300 统一社会信用代码
     regno string 100 注册号
     enttype string 300 企业(机构)类型
     esdate string 100 成立时间
     regorgprovince string 100 省份
     entstatus string 100 企业状态
     conform string 300 出资方式
     regcap string 100 注册资本(万元)
     regcapcur string 100 注册资本币种
     subconam string 100 认缴出资额(万元)
     currency string 300 认缴出资币种
     fundedratio string 300 出资比例
     industryphyname string 100 行业名称
     palgorithmid string 200 个人标识码
```

## **<a name="mobileOnline"> 手机号码在网时长</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/mobile/mobileOnline", // Y 请求地址
        "mobile":"13123456789"// Y 手机号码
    }

```

#### 返回结果
```javascript
    {
     "msg":"查询成功",
     "code":"000",
     "data":{
         "rangeStart":24, // 在网时长范围起始值 单位为月，-1代表未知
         "operator":3, //在网时长范围结束值 单位为月，-1代表未知
         "rangeEnd":-1 //运营商类型 1 移动 2 联通 3 电信
     }
    }

```

## **<a name="antiFraudWool"> 羊毛反欺诈查询</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/antiFraud/wool", // Y 请求地址
        "mobile":"13123456789"// Y 手机号码
        "ip":"", // N 手机ip地址 重要参数 非必传，不传将对检测结果产生影响不能传入10,192,172开头的内网IP地址
        "type":"0" // N 查询类型 1：MD5(32位小写)，0：普通手机号（默认）
    }

```

#### 返回结果
```javascript
    {
     "msg":"查询成功",
     "code":"000",
     "data":{
         "tradeNo":"18102513244932068", //交易号
          "mobile":"13881388928", //手机号
          "status":"W1 //检测结果
            //W1
            //确定为白名单：拥有活跃的地理位置信息、收发快递信息、线
            //下消费信息、身份要素信息、等综合判断是正常使用用户的概
            //率在95%以上。
            //B1
            //确定为黑名单：检测为黑产数据库中的数据，并且有安装过群
            //控相关的软件，同时地址位置信息基本不变，有类似模式的手
            //机号码在同一个IP内，并且同时更换IP，检测准确率95%以上。
            //B2 可信用度低：经平台检测为黑产数据库中的数据，没有安装过
            //群控软件，活跃度一般，综合判断是黑名单的概率为80%。
            //N 未查询到数据
     }
    }

```

## **<a name="financialOverdue"> 金融服务</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/financial/overdue", // Y 请求地址
        "phone":"13123456789"// Y 手机号码
        "idNo":"", // Y 身份证号
        "name":"张三", // Y 姓名
        "backTime":"" // N 回溯日期 格式: yyyy-MM-ddHH:mm:ss 根据回溯日期往前返回 24 月（720 天）的借贷历史，不 传参数时默认从当前日期往前返回 24 月 （720 天，忽略大小月，每月按30 天计 算）的借贷历史。示例：2018-12-0213:05:06
    }

```

#### 返回结果
```javascript
    {
     "msg":"查询成功",
     "code":"000",
     "data":{
            "lastTime": { //最近逾期时间天数
                "overdueRepayLastToNow": "17", //最近一次逾期已还事件距当前时间天数
                "overdueRemindLastToNow": "17" //最近一次逾期提醒事件距当前时间天数
            },
            "sections": [  //变量时间切片集合
                {
                    "maxOverdueRepayDelayLevel": "", //最大借贷类逾期提醒金额等级
                    "sliceName": "m1", //时间切片名称
                    "overdueRepaySum": "5", //逾期已还事件累计次数
                    "maxOverdueDelayLevel": "", //最大逾期时长等级
                    "overdueRepayCount": "", //逾期已还平台累计次数
                    "maxAllOverdueRemindAmtLevel": "", //最大逾期已还时长等级
                    "overdueCount": "", //逾期提醒平台累计次数
                    "overdueSum": "26" //逾期提醒事件累计次数
                }
            ],
            "basicInfo": { //入参信息
                "trueName": "张三", //姓名
                "idLocation": "北京市东城区", //身份证归属地
                "idCard": "110101199910101234",//身份证
                "mobileNo": "13888888888", //手机号
                "mobileOperator": "中国移动" //运营商
            }
        }
    }
```

#### 返回数据参数说明
``` javascript
    金额等级
    L1 0-250 元(包含 250 元)
    L2 250-500 元(包含 500 元)
    L3 500-750 元(包含 750 元)
    L4 750-1000 元(包含 1000 元)
    L5 1000-1250 元(包含 1250 元)
    L6 1250-1500 元(包含 1500 元)
    L7 1500-1750 元(包含 1750 元)
    L8 1750-2000 元(包含 2000 元)
    L9 2000-2400 元(包含 2400 元)
    L10 2400-2800 元(包含 2800 元)
    L11 2800-3200 元(包含 3200 元)
    L12 3200-3600 元(包含 3600 元)
    L13 3600-4000 元(包含 4000 元)
    L14 4000-4500 元(包含 4500 元)
    L15 4500-5000 元(包含 5000 元)
    L16 5000-5500 元(包含 5500 元)
    L17 5500-6000 元(包含 6000 元)
    L18 6000-7000 元(包含 7000 元)
    L19 7000-8000 元(包含 8000 元)
    L20 8000-9000 元(包含 9000 元)
    L21 9000-10000 元(包含 10000 元)
    L22 10000-12000 元(包含 12000 元)
    L23 12000-14000 元(包含 14000 元)
    L24 14000-16000 元(包含 16000 元)
    L25 16000-18000 元(包含 18000 元)
    L26 18000-20000 元(包含 20000 元)
    L27 20000-40000 元(包含 40000 元)
    L28 40000-60000 元(包含 60000 元)
    L29 60000-80000 元(包含 80000 元)
    L30 80000-100000 元(包含 100000 元)
    L31 大于 100000 元
    null 没有数据或者没有获取到该数据

    逾期时长等级
    A 1 天(包含 1 天)
    B 2-7 天(包含 7 天)
    C 8-31 天(包含 31 天)
    D 32-62 天(包含 62 天)
    E 63-92 天(包含 92 天)
    F 大于 92 天
```

## **<a name="entLabel"> 企业标签</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/invoice/entLabel", // Y 请求地址
        "entName":"企业名称"// N 企业名称
        "regNo":"", // N 企业注册号
        "creditCode":"张三", // N 统一信用代码 
        "orgCode":"" // N 组织结构代码
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "flagIpa": "1", //近3年度是否有申请知识产权
            "isLesscredit": "0", //是否失信被执行人 0 否 1 是
            "rankPos": "高", //市场地位等级
            "invseRoundName": "IPO上市", //创投融资轮次
            "isAbnormity": "0", //近1年是否进入工商总局经营异常名录 0 否 1 是
            "entAge": "10.21", //企业年龄
            "isYzwfsx": "0", //近3年是否进入工商总局严重违法失信名单 0 否 1 是
            "isAdminiPunish": "1", //近3年是否存在行政处罚记录 0 否 1 是
            "listSec": "未上市", //上市板块
            "strategyNic": "", //战略性新兴产业
            "flagForgua": "0", //近1年度是否有对外担保 0 否 1 是
            "isList": "0", //是否上市 0 否 1 是
            "rankPay": "较低", //偿付能力等级
            "assgro": "1331590.0", //总资产
            "rankSfrd": "中等", //财报造假风险等级
            "rankGro": "较高", //成长潜力等级
            "rankOpe": "较低", //运营能力等级
            "domdistrict": "", //管辖区（待定）
            "flagMort": "1", //近1年度是否有抵质押 0 否 1 是
            "isExecute": "1", //是否高法被执行人 0 否 1 是
            "ecoTp1": "内资私营公司", //经济类型大类
            "ecoTp2": "内资私营企业", //经济类型小类
            "listCountry": "未上市", //上市区域
            "entScale": "大型", //企业规模
            "rankCredit": "R4", //信用评级
            "vendinc": "169475.0", //营业收入
            "rankPro": "中等", //盈利能力等级
            "nearlynums12315": "0", //近1年近一年12315投诉次数
            "empnum": "964", //从业人数
            "flagTenderer": "0", //近1年度是否投标或中标 0 否 1 是
            "rankTfrd": "较高", //虚假交易等级
            "isTaxCase": "0", //是否有重大税收违法行为 0 否 1 是
            "rankShell": "低", //空壳风险等级
            "regionId": "110108", //注册地
            "regcap": "185000.0", //注册资金(万元)
            "nicId": "M7590", //行业
            "flagTenderee": "0" //近1年度是否招标 0 否 1 是
        }
    }
```

## **<a name="invoiceInfo"> 企业开票信息查询</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/invoice/entLabel", // Y 请求地址
        "entName":"企业名称"// N 企业名称 二选一
        "taxNum":"" // N 社会统一信用码/税号 二选一
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
            "address":"北京市海淀区xxxxx", //地址
            "entNname":"xxx公司", //企业名称
            "tel":"xxx", //电话
            "taxNum":"9111xxxxx8135175", //税号
            "account":"9105015xxxx0007672" //开户行
        }
    }
```

## **<a name="invoiceCheck"> 企业开票信息核验</a>**
[返回到目录](#menu)
##### URL
[/openPlatform/business/credit]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头 Headers Authorization:token
``` javascript
    {
        "path":"/invoice/check", // Y 请求地址
        "entName":"企业名称"// N 企业名称 二选一
        "taxNum":"", // N 社会统一信用码/税号 二选一
        "bank":"", // N 开户行
        "account":"" // N 账户
    }

```

#### 返回结果
```javascript
    {
        "msg": "查询成功",
        "code": "000",
        "data": {
             "taxNumMatch":"1", //税号是否匹配  0:不匹配；1：匹配；2：null; 3:暂不支持；
             "entNameMatch":"1", //企业名称是否匹配 0:不匹配；1：匹配；2：null; 3:暂不支持；
             "bankMatch":"1", //开户行是否匹配 0:不匹配；1：匹配；2：null; 3:暂不支持；
             "accountNumMatch":"1" //银行账户是否匹配 0:不匹配；1：匹配；2：null; 3:暂不支持；
        }
    }
```

## **<a name="GeneralCode"> 通用响应代码</a>**
[返回到目录](#menu)

 |代码 | 是否计费 | 说明 |
 | --- | --- | --- |
 |SYS001 | 否 | 认证失败 |
 |SYS002 | 否 | 请求过期 |
 |SYS003 | 否 | 签名错误 |
 |SYS004 | 否 | 无权访问 |
 |SYS005 | 否 | 账户余额不足 |
 |SYS006 | 否 | 请求IP受限 |
 |SYS007 | 否 | 请求流水号重复 |
 |SYS008 | 否 | 请求频率过快 |
 |SYS044 | 否 | 资源不存在 |
 |SYS050 | 否 | 报文格式不正确 |
 |SYS055 | 否 | 报文解密失败 |
 |SYS098 | 否 | 服务不可用 |
 |SYS099 | 否 | 系统异常 |
